import vtk
import wx
from numpy import *
from stc_io import *
from dv3dFreeSurferLoad import *
import time
from dv3dObjectsToRender import *
from dv3dPropertyFrames import *
from dv3dFreeSurferLoad import *
from common_functions import align_all_planes

import dv3dSTC_ProbeShepardVolumeData


def loadSTC(the_parent_frame):
    
    print 'here'
    
    frame_parent = the_parent_frame
    stc_filename = '/home/andre/stc/StimOnset_Active_Low_white-lh.stc'
    surf_filename = '/home/andre/stc/lh.white'
    
    slice_number = 0

    #stc_filename = '/home/andre/ind-lh.stc'
    #surf_filename = '/home/andre/ind.ynic'

    v,data,start_ms,sample_ms = read_stc(stc_filename)
    vertices, triangles = read_fs_surf(surf_filename)
    

    #data=data*1000000
    
    print data.shape

    scalar_verts = vertices[v]

    sc_points = vtk.vtkPoints()
    for i in range(len(scalar_verts)):
        sc_points.InsertPoint(i,scalar_verts[i,0],scalar_verts[i,1],scalar_verts[i,2])

    full_points = vtk.vtkPoints()
    for i in range(len(vertices)):
        full_points.InsertPoint(i,vertices[i,0],vertices[i,1],vertices[i,2]+100)    #offset 2 surfs so we can view simulataneously

    mm = data.max()
    mmin = data.min()
    print mm, mmin

    sc_scalars = vtk.vtkFloatArray()
    for i in range(len(data[:,0])):
        val = data[i,slice_number]/mm
        sc_scalars.InsertNextValue(val)
    
    tmp_full_scalars = zeros(len(vertices),'f')
    tmp_full_scalars[v] = array(data[:,slice_number],'f')

    full_scalars = vtk.vtkFloatArray()
    for i in range(len(vertices)):
        val = tmp_full_scalars[i]/mm
        full_scalars.InsertNextValue(val)
    

    # Process faces (triangles) for 'full' surface
    polys = vtk.vtkCellArray()
    nTriangles = triangles.shape[0]
    for i in range(nTriangles):
        polys.InsertNextCell(3)
        for j in range(1,4):
            polys.InsertCellPoint(triangles[i,j])


    profileA = vtk.vtkPolyData()
    profileA.SetPoints(full_points)
    profileA.GetPointData().SetScalars(full_scalars)
    profileA.SetPolys(polys)
    profileA.Update()

            
    profile = vtk.vtkPolyData()
    profile.SetPoints(sc_points)
    profile.GetPointData().SetScalars(sc_scalars)
    profile.Update()
    
    bounds = array(profile.GetBounds())
    bounds[0:6:2] =  bounds[0:6:2]-20
    bounds[1:7:2] =  bounds[1:7:2]+20
    
    shepard = vtk.vtkShepardMethod()
    shepard.SetInput(profile)
    shepard.SetModelBounds(bounds)
    shepard.SetMaximumDistance(0.1)
    shepard.SetNullValue(1)
    shepard.SetSampleDimensions(50, 50, 50)
    shepard.Update()

            
    ######origMapper = vtk.vtkPolyDataMapper()
    ######origMapper.SetInput(profileA)
    ######origMapper.ScalarVisibilityOn()
    ######origActor = vtk.vtkActor()
    ######origActor.SetMapper(origMapper)
    ######origActor.VisibilityOn()
    ######the_parent_frame.ren.AddActor(origActor)
    ######origMapper.Update()
    ######origMapper.GetLookupTable().SetNumberOfTableValues(256000)
    ######origMapper.GetLookupTable().Build()
    ######origMapper.GetLookupTable().SetTableValue(0, (0.5,0.5,0.5,1.0))
    ######origMapper.GetLookupTable().SetTableValue(1, (1.0,0.0,0.0,1.0))
    ######origMapper.GetLookupTable().SetTableValue(255999, (0.0,0.0,1.0,1.0))
        
	
    ######origMapper.GetLookupTable().SetTableRange((mmin,mm))
    #######origMapper.GetLookupTable().Build()
    ######origMapper.Update()
            
    
    #gen fs surface
    polyData = get_surf_polyData (vertices, triangles)
    
    origMapper2 = vtk.vtkPolyDataMapper()
    origMapper2.ImmediateModeRenderingOn()
    origMapper2.SetInput(polyData)
    origMapper2.Update()
    origActor2 = vtk.vtkLODActor()
    origActor2.SetMapper(origMapper2)
    
    Actor_to_add = dv3dSTC_ProbeShepardVolumeData.ProbeShepardVolume(frame_parent, origActor2, shepard.GetOutput())
    
    AddVTKObjectWithAttributes(Actor_to_add,\
                            the_parent_frame,\
                            'vtkSTCSurface',\
                            'surface',\
                            None,\
                            None,\
                            0,\
                            1,\
                            1,\
                            'structural',\
                            None,\
                            stc_filename,\
                            1,\
                            'STC_Properties',\
                            None)

    the_parent_frame.ren.AddActor(the_parent_frame.ListOfObjects[-1])
    
    the_parent_frame.ListOfObjects[-1].time_series_data = data
    the_parent_frame.ListOfObjects[-1].curr_timepoint = 0
    the_parent_frame.ListOfObjects[-1].surface_data = origActor2
    
    new_surface = the_parent_frame.tree.AppendItem(the_parent_frame.tree_structural, the_parent_frame.ListOfObjects[-1].my_label)
    #add the newly created treeitem as an atribute of the plane_group
    the_parent_frame.ListOfObjects[-1].my_treeitem = new_surface
    the_parent_frame.tree.Refresh()
    
    # .. create a properties window for the plane set ...
    # we pass the parent frame and the newly created object as args
    frame = MyPropertyFrame(the_parent_frame, the_parent_frame.ListOfObjects[-1], 0)
    frame.Show(True)
    
    # ... and apply it to the relevant list object
    the_parent_frame.ListOfObjects[-1].my_property_frame_instance = frame
    
    align_all_planes(the_parent_frame)


def prepareShepardVolume():
    pass