import vtk

def AddOrientationsAxes(frame_parent):

	frame_parent = frame_parent

	# AxesActor
	axes = vtk.vtkAxesActor()
	axes.SetShaftTypeToCylinder()

	# Orientation marker to be used with vtkAxesActor.
	frame_parent.OrientationsAxes = vtk.vtkOrientationMarkerWidget()
	frame_parent.OrientationsAxes.SetOrientationMarker(axes)
	frame_parent.OrientationsAxes.SetViewport(0,0,0.1,0.1)

	frame_parent.OrientationsAxes.SetInteractor(frame_parent.widget)
	frame_parent.OrientationsAxes.EnabledOn()
	#frame_parent.OrientationsAxes.InteractiveOff()
	
	my_axes = frame_parent.tree.AppendItem(frame_parent.tree_root, 'XYZ Axes')
	#add the newly created treeitem as an atribute of the plane_group
	frame_parent.ListOfObjects[-1].my_treeitem = my_axes
	frame_parent.tree.Refresh()	

	frame_parent.widget.Render()

