import vtk

from dv3dObjectsToRender import *
from dv3dProbePropertyFrame import *
from dv3dExportPolyDataToDotVTKFile import *

def UseCurrentSurfaceAsDataProbe(frame_parent, the_surface, the_volume):

    LUT = the_volume[0].lookuptable
    
    new_LUT = vtk.vtkLookupTable()

    new_LUT.DeepCopy(LUT)
    
    #here we do not want null values to be transparent
    new_LUT.SetTableValue(0, (0.5,0.5,0.5,1.0))
    new_LUT.Build()
    
    a = the_surface.GetMapper()
    b = a.GetInput()
    
    # the really clever bit (thx VTK!) - wherever i have a datapoint on my
    # surface, go to thesame datapoint in the stat-volume and extract the
    # scalar value there- probe the data with spatial filter - ProbeFilter
    stat_probe = vtk.vtkProbeFilter()
    
    #stat_probe.SetInput(deci.GetOutput()) 
    stat_probe.SetInput(b) 
    stat_probe.SetSource(the_volume[0].volume_data.GetOutput())#.GetOutput())
    transform1 = vtk.vtkTransform()
    transform1.Scale(1.001, 1.001, 1.001)
    
    transformer1 = vtk.vtkTransformPolyDataFilter()
    transformer1.SetInput(stat_probe.GetOutput())
    transformer1.SetTransform(transform1)
    
    
    stat_contourMapper = vtk.vtkPolyDataMapper()
    stat_contourMapper.SetInput(transformer1.GetOutput())
    #stat_contourMapper.SetScalarRange(frame_parent.stat_vol.GetOutput().GetScalarRange()) #e.g. dynamically set the scalarrange based on values in the data
    stat_contourMapper.SetScalarRange(new_LUT.GetTableRange())
    #stat_contourMapper.GetLookupTable().SetTableValue(0, (0.5,0.5,0.5,1.0))
    stat_contourMapper.SetLookupTable(new_LUT)
    stat_contourMapper.SetColorModeToMapScalars()
    
    # set a colour bar for reference of scalar value mapping
    pos_scalarBar =  vtk.vtkScalarBarActor()
    pos_scalarBar.SetLookupTable(the_volume[0].lookuptable)
    pos_scalarBar.SetTitle('')
    pos_scalarBar.GetTitleTextProperty().SetFontSize(24)
    pos_scalarBar.GetPositionCoordinate().SetCoordinateSystemToNormalizedViewport()
    pos_scalarBar.GetPositionCoordinate().SetValue(0.05,0.75)
    pos_scalarBar.SetWidth(0.05)
    pos_scalarBar.SetHeight(0.2)
    pos_scalarBar.SetNumberOfLabels(5)
    pos_scalarBar.SetOrientationToVertical()
    
    sbw = vtk.vtkScalarBarWidget()
    sbw.SetScalarBarActor(pos_scalarBar)
    
    #now pass all our created and updated objects to the renderer
    stat_contourActor = vtk.vtkActor()
    stat_contourActor.SetMapper(stat_contourMapper)
    stat_contourActor.VisibilityOn()
    stat_contourActor.GetProperty().SetBackfaceCulling(0)
    
    
    dlg = wx.FileDialog(frame_parent, "Save your new surface file here:", "", "", ".vtk file|*.vtk", wx.SAVE)
        
    if dlg.ShowModal() == wx.ID_OK:
        file_to_save = dlg.GetPath()
    else:
        return
    
    frame_parent.applyVTKxfm = 0
    file_name = dv3dExportPolyDataToDotVTKFile(file_to_save, stat_contourActor, LUT)
    
    frame_parent.AutoLoadFileNow = file_name #TODO explain why - circular arg hack
    frame_parent.temp_LUT = new_LUT
    
    