import vtk
from dv3dObjectsToRender import *
from dv3dPropertyFrames import *

def GeneratePositionMarker(frame_parent, x_slice=None, y_slice=None, z_slice=None, radius=2.5,r=255.0, g=255.0, b=255.0):

    if x_slice==None or y_slice==None or z_slice==None:
        pick = frame_parent.widget.GetPicker()
        r = frame_parent.widget.GetEventPosition()
        s = r[0],r[1],0
        pick.Pick(s, frame_parent.ren)
        ppos = pick.GetPickPosition()
    else:
        ppos=(-x_slice, y_slice, z_slice) #? need a negative pixel dimension here?
    
    s1 = vtk.vtkSphereSource()
    s1.SetCenter(ppos)
    s1.SetRadius(radius)
    
    map = vtk.vtkPolyDataMapper()
    map.SetInput(s1.GetOutput())
    
    act = vtk.vtkActor()
    act.SetMapper(map)
    try:
    	act.GetProperty().SetColor(r/255.0, g/255.0, b/255.0)
    except:
	pass

    map.Update()
    #allows us to scaling about the object's center later if we want
    print act.GetOrigin()
    print act.GetCenter()
    act.SetOrigin(act.GetCenter())
    print act.GetOrigin()
    print act.GetCenter()


    AddVTKObjectWithAttributes(act,\
                            frame_parent,\
                            'vtkPolyDataSurfaceFromOFF',\
                            'surface',\
                            None,\
                            None,\
                            0,\
                            1,\
                            1,\
                            'functional',\
                            None,\
                            'None',\
                            1,\
                            'MarkerProperties',\
                            None)

    ###TODO URGENT FIX
    ###frame_parent.ortho_window.ortho_ren1.AddActor(frame_parent.ListOfObjects[-1])
    ###frame_parent.ortho_window.ortho_ren2.AddActor(frame_parent.ListOfObjects[-1])
    ###frame_parent.ortho_window.ortho_ren3.AddActor(frame_parent.ListOfObjects[-1])
    frame_parent.ren.AddActor(frame_parent.ListOfObjects[-1])
    
    #frame_parent.ortho_ren1.AddActor(frame_parent.ListOfObjects[-1])
    #frame_parent.ortho_ren2.AddActor(frame_parent.ListOfObjects[-1])
    #frame_parent.ortho_ren3.AddActor(frame_parent.ListOfObjects[-1])
    
    frame_parent.ListOfObjects[-1].my_label = 'Marker at %s,%s,%s' %(str(int(-ppos[0])), str(int(ppos[1])), str(int(ppos[2])))
    new_surface = frame_parent.tree.AppendItem(frame_parent.tree_structural, frame_parent.ListOfObjects[-1].my_label)
    #add the newly created treeitem as an atribute of the plane_group
    frame_parent.ListOfObjects[-1].my_treeitem = new_surface


    frame_parent.tree.Refresh()
    
    # .. create a properties window for the plane set ...
    # we pass the parent frame and the newly created object as args
    frame = MyPropertyFrame(frame_parent, frame_parent.ListOfObjects[-1], 0)
    frame.Show(True)
    
    # ... and apply it to the relevant list object
    frame_parent.ListOfObjects[-1].my_property_frame_instance = frame
    
    align_all_planes(frame_parent)
