
import wx
import os

import globalvar as globalvar
from utils import *

class ViewsTab(wx.Panel):
    def __init__(self, parent, frame_parent):
        wx.Panel.__init__(self, parent, -1)
        
        self.frame_parent = frame_parent
        #self.text_ctrl_x_slice = wx.TextCtrl(self, -1, "")
        self.CaptureCurrentViewButton = wx.Button(self, -1, "Capture current viewpoint ")
        self.CaptureCurrentViewButton.Bind(wx.EVT_BUTTON, self.OnVPCaptureButton,
              id=-1)
        
        self.CapturedViewPointCount = 0
        
        self.drop_down_content = [] #the list holder for the viewpoint selection
        self.drop_down_content.append('')

        self.ViewpointChoiceLabel = wx.StaticText(id=-1, label='Choose a pre-acquired viewpoint', name='ChooseVP',
              parent=self, pos=wx.Point(16, 16), style=0)
        
        self.VPChoice = wx.Choice(choices=self.drop_down_content, id=-1,
              name='VolumeChoice', parent=self, pos=wx.Point(16, 42),
              size=wx.Size(250, 30), style=0)
        self.VPChoice.Bind(wx.EVT_CHOICE, self.OnVPChoice,
              id=-1)
        
        self.SaveViewsToFileButton = wx.Button(self, -1, "Save views to file")
        self.SaveViewsToFileButton.Bind(wx.EVT_BUTTON, self.OnSaveViewsToFile,
              id=-1)

        self.LoadViewsFromFileButton = wx.Button(self, -1, "Load views from file")
        self.LoadViewsFromFileButton.Bind(wx.EVT_BUTTON, self.OnLoadViewsFromFile,
              id=-1)

        grid_sizer = wx.GridBagSizer(3, 3)
	grid_sizer.Add(self.CaptureCurrentViewButton, pos=(2,0), span=(1,3), flag=wx.EXPAND)
        grid_sizer.Add(self.ViewpointChoiceLabel, pos=(0,0), span=(1,3), flag=wx.EXPAND)
        grid_sizer.Add(self.VPChoice, pos=(1,0), span=(1,3), flag=wx.EXPAND)
        grid_sizer.Add(self.SaveViewsToFileButton, pos=(0,5), flag=wx.EXPAND)
        grid_sizer.Add(self.LoadViewsFromFileButton, pos=(1,5),flag=wx.EXPAND)
        
        self.SetSizer(grid_sizer)
        self.Fit()

    def OnSaveViewsToFile (self, evt):
	dlg = wx.FileDialog(self, "Save As", "", "","ViewPoint files(*.vpf)|*.vpf|All Files|*.*", wx.SAVE)
        if (dlg.ShowModal() == wx.ID_OK):
            self.fileName = dlg.GetFilename()
            self.dirName = dlg.GetDirectory()
	    f = open(self.dirName+'/'+self.fileName, 'a')
	    for i in self.frame_parent.CapturedViewPointList:
		f.write(str(i))
		f.write('\n')
	    f.close()
	    print 'Saved viewpoint file to '+self.dirName+'/'+self.fileName
	else:
	    print 'Save viewpoint file cancelled ...'
        dlg.Destroy()
	


    def OnLoadViewsFromFile (self, evt):
	dlg = wx.FileDialog(self, "Open vpf file ...", "", "","ViewPoint files(*.vpf)|*.vpf|All Files|*.*", wx.OPEN)
        if (dlg.ShowModal() == wx.ID_OK):
            self.fileName = dlg.GetFilename()
            self.dirName = dlg.GetDirectory()
	    f = open(self.dirName+'/'+self.fileName)
	    t = f.read()
	    f.close()
	    r = t.splitlines()
	    for i in r:
		u = eval(i)
		self.frame_parent.CapturedViewPointList.append(u)
		self.drop_down_content.append(str(u[-1]))
	    
            self.VPChoice.SetItems(self.drop_down_content)
            self.VPChoice.Update()		
		
	    print 'Loaded viewpoint file from '+self.dirName+'/'+self.fileName
	else:
	    print 'Load viewpoint file cancelled ...'
        dlg.Destroy()
   
    def OnVPChoice (self, evt):
	choice = self.VPChoice.GetSelection()
        if choice > 0:
            curr_vals = self.frame_parent.CapturedViewPointList[choice-1]
            self.frame_parent.ren.GetActiveCamera().SetViewUp(curr_vals[0])
            self.frame_parent.ren.GetActiveCamera().SetPosition(curr_vals[1])
            self.frame_parent.ren.GetActiveCamera().SetDistance(curr_vals[2])
            self.frame_parent.ren.GetActiveCamera().SetEyeAngle(curr_vals[3])
            self.frame_parent.ren.GetActiveCamera().SetFocalPoint(curr_vals[4])
            self.frame_parent.ren.GetActiveCamera().SetViewAngle(curr_vals[5])
            self.frame_parent.ren.GetActiveCamera().SetClippingRange(curr_vals[6])
            self.frame_parent.widget.Render()


    def OnVPCaptureButton (self, evt):
        self.CapturedViewPointCount += 1
        dialog = wx.TextEntryDialog(None, "Would you like to specifically name this viewpoint?", "Name your viewpoint .. ", 'Viewpoint %s' %self.CapturedViewPointCount, style=wx.OK|wx.CANCEL)
        if dialog.ShowModal() == wx.ID_OK:
	    self.vp_name = dialog.GetValue()
            self.drop_down_content.append(dialog.GetValue())
        else:
            self.drop_down_content.append('Viewpoint %s' %self.CapturedViewPointCount)
	    self.vp_name = 'Viewpoint %s' %self.CapturedViewPointCount
        dialog.Destroy()

        curr_view = [   self.frame_parent.ren.GetActiveCamera().GetViewUp(),
                        self.frame_parent.ren.GetActiveCamera().GetPosition(),
                        self.frame_parent.ren.GetActiveCamera().GetDistance(),
                        self.frame_parent.ren.GetActiveCamera().GetEyeAngle(),
                        self.frame_parent.ren.GetActiveCamera().GetFocalPoint(),
                        self.frame_parent.ren.GetActiveCamera().GetViewAngle(),
                        self.frame_parent.ren.GetActiveCamera().GetClippingRange(),
			self.vp_name]

        self.frame_parent.CapturedViewPointList.append(curr_view)
        self.VPChoice.SetItems(self.drop_down_content)
        self.VPChoice.Update()
