import wx
import globalvar

class TopPanel(wx.FlexGridSizer):
    def __init__(self, parent, static_text):
        wx.FlexGridSizer.__init__(self, cols=2, hgap=4, vgap=10)
        item_list = []
        self.ctrl = []
        for i in range(len(static_text)):
            self.ctrl.append( wx.TextCtrl(parent, -1, size=static_text[i][1]) )
            item_list.append( wx.StaticText(parent, -1, static_text[i][0]) )
            item_list.append( self.ctrl[-1] )
        self.AddMany(item_list)

    def GetTextCtrl(self, num):
        return self.ctrl[num]


def ShowMsg(parent, msgstr):
    dlg = wx.MessageDialog(parent, msgstr, '', wx.OK | wx.ICON_INFORMATION)
    dlg.ShowModal()
    dlg.Destroy()

def update_title(ob):
    main_window = ob.GetParent().GetParent().GetParent()
    if not globalvar.modified:
       main_window.SetTitle('%s*'%main_window.GetTitle())
