import vtk

class create_new_planewidget(vtk.vtkImagePlaneWidget):
    #a subclass of the vtkImagePlaneWidget with additional properties
    
    def __init__(self,widget,volume,slice_pos,ptype,picker,corresponding_vol_data,parent_frame):
        #TODO - option for interpolation on/off
        #self.SetTextureInterpolate(0)        
        self.corresponding_vol_data = corresponding_vol_data
        self.SetKeyPressActivation(0)
        self.DisplayTextOn()
        self.SetInteractor(widget)
        self.SetInput(volume)
        self.SetSliceIndex(slice_pos)
        self.SetPicker(picker)
        self.SetHandleSize(500)
        prop1 = self.GetPlaneProperty()
        if ptype == 0:
            self.SetPlaneOrientationToXAxes()
            prop1.SetColor(1, 1, 0)
        elif ptype == 1:
            self.SetPlaneOrientationToYAxes()
            prop1.SetColor(1, 0, 1)
        elif ptype == 2:
            self.SetPlaneOrientationToZAxes()
            prop1.SetColor(0, 1, 1)
        self.SetKeyPressActivation(0)
	# this means that the user cannot change the window/level
        self.UserControlledLookupTableOn()
	
	#change the default behaviour of the mouse buttons .. since we hardly use the right mouse
	# button we will move the middle mouse button (reslice) fucntionality to the right mouse button
	
	self.SetMiddleButtonAction(2)
	self.SetRightButtonAction(1)
	
	self.On()
        self.RestrictPlaneToVolumeOn()
        if parent_frame != None:
            if len(parent_frame.ListOfObjects) < 4:
                self.AddObserver("InteractionEvent", parent_frame.MouseTracker)

    def setlocation(self, pw):
        self.SetOrigin(pw.GetOrigin())
        self.SetPoint1(pw.GetPoint1())
        self.SetPoint2(pw.GetPoint2())
        self.UpdatePlacement()


class planewidget_group:
    def __init__(self,xwidget,ywidget,zwidget):
        self.planewidgets=[xwidget,ywidget,zwidget]
        for i in range(1,3):
            self.planewidgets[i].SetLookupTable(self.planewidgets[0].GetLookupTable())
        
    def setlocation(self,wc,frame_parent):
        for i in range(len(frame_parent.ListOfObjects)):
            if frame_parent.ListOfObjects[i].my_label == 'Sagittal plane':
                frame_parent.ListOfObjects[i].setlocation(frame_parent.ListOfObjects[0])
            elif frame_parent.ListOfObjects[i].my_label == 'Coronal plane':
                frame_parent.ListOfObjects[i].setlocation(frame_parent.ListOfObjects[1])                
            elif frame_parent.ListOfObjects[i].my_label == 'Axial plane':
                frame_parent.ListOfObjects[i].setlocation(frame_parent.ListOfObjects[2])

            