import vtk
import os, wx
from numpy import *
from struct import unpack, calcsize

from dv3dObjectsToRender import *
from dv3dPropertyFrames import *


def Load_OFF_File(self, the_parent_frame):
    my_filetypes = 'OFF|*.off|All files|*' #the restiction for the file choice dialog
    surface_data_to_load = ChooseFile(self, my_filetypes)    
    
    f=open(str(surface_data_to_load),'rb')
    d=f.readline() #ignore first line
       
    dim = unpack('>lll', f.read(calcsize('lll'))) #get dims
    #p = fromfile(f, float32, dim[0]*3) 
    #vertices = reshape(p, (- 1,3))
    
    vertices = []
    for i in range(dim[0]):
        vert = unpack('>fff', f.read(calcsize('fff')))
        vertices.append(vert)    
    
    triangles = []
    for i in range(dim[1]):
        tri = unpack('>lllll', f.read(calcsize('lllll')))
        triangles.append(tri)    
    
    f.close()
    nVertices = dim[0]
    nTriangles = dim[1]
    
    pts = vtk.vtkIdList()
    newPolys = vtk.vtkCellArray()
    newPts = vtk.vtkPoints()

    # generate parts
    for i in range(nVertices):
        newPts.InsertPoint(i, float(vertices[i][0]),float(vertices[i][1]),float(vertices[i][2]))
    pts.Reset()

    # loop here for multiple parts
    
    for j in range(nTriangles):
        pts.Reset()
        
        for i in range(1,len(triangles[j])-1):
        
            pts.InsertNextId(triangles[j][i])
        
        newPolys.InsertNextCell(pts)
        
    output = vtk.vtkPolyData()
    output.SetPolys(newPolys)
    output.SetPoints(newPts)

    origMapper = vtk.vtkPolyDataMapper()
    origMapper.SetInput(output)
    origMapper.Update()
    origActor = vtk.vtkLODActor()
    origActor.SetMapper(origMapper)
    origActor.VisibilityOn()

    # --- Add the Surface Actor with a set opacity and Colour
    origActor.GetProperty().SetOpacity(1.0)
    origActor.GetProperty().SetColor(0.8, 0.0, 0.0)

    #the_parent_frame.ren.AddActor(origActor)
    
    AddVTKObjectWithAttributes(origActor,\
                            the_parent_frame,\
                            'vtkPolyDataSurfaceFromOFF',\
                            'surface',\
                            None,\
                            None,\
                            0,\
                            1,\
                            1,\
                            'structural',\
                            None,\
                            surface_data_to_load,\
                            1,\
                            'SurfaceProperties',\
                            None)
    
    the_parent_frame.ren.AddActor(the_parent_frame.ListOfObjects[-1])
    
    
    new_surface = the_parent_frame.tree.AppendItem(the_parent_frame.tree_structural, the_parent_frame.ListOfObjects[-1].my_label)
    #add the newly created treeitem as an atribute of the plane_group
    the_parent_frame.ListOfObjects[-1].my_treeitem = new_surface
    the_parent_frame.tree.Refresh()
    
    # .. create a properties window for the plane set ...
    # we pass the parent frame and the newly created object as args
    frame = MyPropertyFrame(the_parent_frame, the_parent_frame.ListOfObjects[-1], 0)
    frame.Show(True)
    
    # ... and apply it to the relevant list object
    the_parent_frame.ListOfObjects[-1].my_property_frame_instance = frame
    

def ChooseFile(self, my_filetypes):
    dlg = wx.FileDialog(self, "Choose file:", '', "", my_filetypes, wx.OPEN)
    if dlg.ShowModal() == wx.ID_OK:
        path = dlg.GetPath()
        return path