import vtk


def AddMainLights(the_frame_parent):

        light1 = vtk.vtkLight()
        #light1.SetColor(1,1,0.9)
        light1.SetIntensity(0.2)
        light1.SetFocalPoint(0,0,0)
        light1.SetPosition(0,0,5000)
        light1.SetLightTypeToCameraLight()
        light1.SwitchOff()


        light2 = vtk.vtkLight()
        #light2.SetColor(0.9,1,1)
        light2.SetIntensity(0.3)
        light2.SetFocalPoint(0,0,0)
        light2.SetPosition(0,5000,0)
        light2.SetLightTypeToCameraLight()
        light2.SwitchOff()
        
        light3 = vtk.vtkLight()
        #light3.SetColor(1,0.9,1)
        light3.SetIntensity(0.1)
        light3.SetFocalPoint(0,0,0)
        light3.SetPosition(5000,0,0)
        light3.SetLightTypeToCameraLight()
        light3.SwitchOff()


        light4 = vtk.vtkLight()
        #light4.SetColor(1,1,1)
        light4.SetIntensity(0.2)
        light4.SetFocalPoint(0,0,0)
        light4.SetPosition(-5000,-5000,-5000)
        light4.SetLightTypeToCameraLight()
        light4.SwitchOff()
        the_frame_parent.light1 = light1
        the_frame_parent.light2 = light2
        the_frame_parent.light3 = light3
        the_frame_parent.light4 = light4
        
        
        the_frame_parent.ren.AddLight(the_frame_parent.light1)        
        the_frame_parent.ren.AddLight(the_frame_parent.light2)
        the_frame_parent.ren.AddLight(the_frame_parent.light3)
        the_frame_parent.ren.AddLight(the_frame_parent.light4) 



#example code for now - fix references self, etc
def AddLightToActor(the_frame_parent, the_actor):       
        # Associate the line widget with the interactor
        
        the_frame_parent.sphereWidget = vtk.vtkSphereWidget()
        the_frame_parent.sphereWidget.SetInteractor(the_frame_parent.widget)
        the_frame_parent.sphereWidget.SetProp3D(the_actor)
        the_frame_parent.sphereWidget.SetPlaceFactor(4)
        the_frame_parent.sphereWidget.PlaceWidget()
        the_frame_parent.sphereWidget.TranslationOff()
        the_frame_parent.sphereWidget.ScaleOff()
        the_frame_parent.sphereWidget.HandleVisibilityOn()
        
        # Uncomment the next line if you want to see the widget active when
        # the script starts
        #sphereWidget.EnabledOn()

        light = vtk.vtkLight()
        light.SetFocalPoint(the_actor.GetCenter())
        the_frame_parent.ren.AddLight(light)
        
        # Actually probe the data
        def MoveLight(obj, event):
            light.SetPosition(obj.GetHandlePosition())
         
        the_frame_parent.sphereWidget.AddObserver("InteractionEvent", MoveLight)
        
        # Add the actors to the renderer, set the background and size
        #self.ren.SetBackground(1, 1, 1)
        
        cam1 = the_frame_parent.ren.GetActiveCamera()
        cam1.SetViewUp(0, 0, 1)
        cam1.SetFocalPoint(the_actor.GetCenter())
        cam1.SetPosition(1, 0, 0)
        the_frame_parent.ren.ResetCamera()
        cam1.Elevation(25)
        cam1.Azimuth(125)
        cam1.Zoom(1.25)
        the_frame_parent.sphereWidget.On()
        

                
        
        
        
        
