#common functions used by multiple dv3d subroutines/modules/classes


def toggle_base_plane_from_buttons(theCheckBox, theTreeItem, theParentFrame, plane_orientation):
#toggles the x,y, or z base planewidgets and all other planes of the same orientation -
# takes the checkbox object on the button_plane of the gui, the placeholder in the
# item tree, the main application frame and the orientation (0,1 or 2) as arguments

    if plane_orientation == 0:
        search_string = 'Sagittal plane'
    elif plane_orientation == 1:
        search_string = 'Coronal plane'
    elif plane_orientation == 2:
        search_string = 'Axial plane'
    
    if theCheckBox.GetValue() == True:
        for i in range(len(theParentFrame.ListOfObjects)):
            if theParentFrame.ListOfObjects[i].my_label == search_string:
                theParentFrame.ListOfObjects[i].On()
                theParentFrame.ListOfObjects[i].my_visibility = 1
                theParentFrame.widget.Render()
                theCheckBox.SetValue(True)
                #TODO - catch the event and toggle tree image
                #if theTreeItem != -1:
                #    theParentFrame.tree.SetItemImage(theTreeItem, theParentFrame.ListOfObjects[i].my_treeitem_img2)
    else:
        for i in range(len(theParentFrame.ListOfObjects)):
            if theParentFrame.ListOfObjects[i].my_label == search_string:
                theParentFrame.ListOfObjects[i].Off()
                theParentFrame.ListOfObjects[i].my_visibility = 1
                theParentFrame.widget.Render()
                theCheckBox.SetValue(False)
                #TODO - catch the event and toggle tree image
                #if theTreeItem != -1:
                #    theParentFrame.tree.SetItemImage(theTreeItem, theParentFrame.ListOfObjects[i].my_treeitem_img2)


def toggle_base_plane_from_tree(theCheckBox, theTreeItem, theParentFrame, plane_orientation):
#toggles the x,y, or z base planewidgets and all other planes of the same orientation -
# takes the checkbox object on the button_plane of the gui, the placeholder in the
# item tree, the main application frame and the orientation (0,1 or 2) as arguments

    if plane_orientation == 0:
        search_string = 'Sagittal plane'
    elif plane_orientation == 1:
        search_string = 'Coronal plane'
    elif plane_orientation == 2:
        search_string = 'Axial plane'
    
    if theCheckBox.GetValue() == True:
        for i in range(len(theParentFrame.ListOfObjects)):
            if theParentFrame.ListOfObjects[i].my_label == search_string:
                theParentFrame.ListOfObjects[i].Off()
                theParentFrame.ListOfObjects[i].my_visibility = 0
                theParentFrame.widget.Render()
                theCheckBox.SetValue(False)
                theParentFrame.tree.SetItemImage(theTreeItem, theParentFrame.ListOfObjects[i].my_treeitem_img2)
    else:
        for i in range(len(theParentFrame.ListOfObjects)):
            if theParentFrame.ListOfObjects[i].my_label == search_string:
                theParentFrame.ListOfObjects[i].On()
                theParentFrame.ListOfObjects[i].my_visibility = 1
                theParentFrame.widget.Render()
                theCheckBox.SetValue(True)
                theParentFrame.tree.SetItemImage(theTreeItem, theParentFrame.ListOfObjects[i].my_treeitem_img1)


#TODO
def toggle_single_stat_plane(theTreeItem, theParentFrame, plane_orientation):
#toggles the x,y, or z base planewidgets for an individual overlay image - 
# takes the placeholder in the item tree, the main application frame and the
# orientation (0,1 or 2) as arguments

    if theCheckBox.GetValue() == True:
        for i in range(len(theParentFrame.PWG)):   
            theParentFrame.PWG[i][0].planewidgets[plane_orientation].GetTexturePlaneProperty().SetOpacity(1.0)
            theParentFrame.widget.Render()
    else:
        for i in range(len(theParentFrame.PWG)):   
            theParentFrame.PWG[i][0].planewidgets[plane_orientation].GetTexturePlaneProperty().SetOpacity(0.0)
            theParentFrame.widget.Render()
                      
                      

def align_all_planes(frame_parent):
    
        or_map = [0,2,1] #swap the mapping dimensions of the MRI volume 
        
        # first align the ortho planes
        for i in range(3):
            #frame_parent.ortho_planes[i].SetOrigin(frame_parent.ListOfObjects[or_map[i]].GetOrigin())
            #frame_parent.ortho_planes[i].SetPoint1(frame_parent.ListOfObjects[or_map[i]].GetPoint1())
            #frame_parent.ortho_planes[i].SetPoint2(frame_parent.ListOfObjects[or_map[i]].GetPoint2())
            frame_parent.ortho_planes[i].SetOrigin(frame_parent.ListOfObjects[i].GetOrigin())
            frame_parent.ortho_planes[i].SetPoint1(frame_parent.ListOfObjects[i].GetPoint1())
            frame_parent.ortho_planes[i].SetPoint2(frame_parent.ListOfObjects[i].GetPoint2())
            frame_parent.ortho_planes[i].UpdatePlacement()
            frame_parent.ortho_planes[i].ortho_ren1.ResetCamera()
            if frame_parent.SYNC_ortho == 1:
                frame_parent.ortho_planes[i].GetInteractor().Render()
            #frame_parent.ortho_window.ortho_ren2.ResetCamera()
            #frame_parent.ortho_window.ortho_ren3.ResetCamera()

        
        #now align stat overlays
        for i in range(len(frame_parent.ListOfObjects)):
            if frame_parent.ListOfObjects[i].my_type == 'overlay_imageplanegroup':
                frame_parent.ListOfObjects[i].setlocation(frame_parent.ListOfObjects[3], frame_parent)
        frame_parent.widget.Render()
        
        
        if len(frame_parent.ListOfObjects) == 5:
            if frame_parent.base_loaded == 0:
                frame_parent.ren.Render()
                frame_parent.widget.Render()
                frame_parent.ren.ResetCamera()
                frame_parent.ren.Render()
                frame_parent.widget.Render()
