import wx
import os
import vtk
import time
from CLT_selection_Frame import *
from dv3dUpdateTimeSeries import *
from dv3dSurfaceFunctions import *
from common_functions import align_all_planes
from dv3dSurfaceIntersectsVolumeData import UseCurrentSurfaceAsDataProbe

from PFrame_PUMenu import PUMenu
from PFrame_BasePlanes import PropertyPanel_BasePlaneWidgets
from PFrame_OverlayPlanes import PropertyPanel_OverlayPlaneWidgets


class PropertyPanel_4DNI_Dipole(wx.Panel):
    def __init__(self, parent, frame_parent, thevtkobject):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        self.thevtkobject = thevtkobject
        
        self.dipole_rows = thevtkobject.dipole_rows
        self.dipole_mat = thevtkobject.dipole_mat
        self.ar = thevtkobject.ar
        self.line = thevtkobject.line
        self.Sphere = thevtkobject.Sphere
        
        self.parent = parent
        
        self.parent.SetSize(wx.Size(410,310))
        
        #first extract both the actors from the vtkActorCollection
        self.data_source_path = thevtkobject.InitTraversal()
        self.line_actor = thevtkobject.GetNextActor()
        self.sphere_actor = thevtkobject.GetNextActor()

        
        #get the time points
        self.dipole_max_time = thevtkobject.dipole_max_time
        self.dipole_min_time = thevtkobject.dipole_min_time
        self.curr_pos = thevtkobject.curr_pos
        
        self.my_data_path = thevtkobject.my_data_path
        self.index_into_objects = len(self.frame_parent.ListOfObjects)-1
        
        
        self.staticBox1 = wx.StaticBox(id=-1,
              label='Colours', name='staticBox1', parent=self,
              pos=wx.Point(24, 112), size=wx.Size(360, 56), style=0)

        self.staticBox2 = wx.StaticBox(id=-1,
              label='Time-series', name='staticBox2', parent=self,
              pos=wx.Point(24, 16), size=wx.Size(360, 88), style=0)

        self.staticBox3 = wx.StaticBox(id=-1,
              label='Data source', name='staticBox3', parent=self,
              pos=wx.Point(24, 176), size=wx.Size(360, 48), style=0)

        self.textCtrl1 = wx.TextCtrl(id=-1, name='textCtrl1',
              parent=self, pos=wx.Point(32, 192), size=wx.Size(336, 21),
              style=0, value='%s' %self.my_data_path)
        self.textCtrl1.SetEditable(False)

        self.staticText1 = wx.StaticText(id=-1,
              label='Last time-point', name='staticText1', parent=self,
              pos=wx.Point(208, 40), size=wx.Size(71, 13), style=0)

        self.staticText2 = wx.StaticText(id=-1,
              label='%s' %str(self.dipole_max_time), name='staticText2', parent=self,
              pos=wx.Point(288, 40), size=wx.Size(40, 13), style=0)#TODO - hack -hardcoded for HBM

        self.staticText3 = wx.StaticText(id=-1,
              label='First time-point', name='staticText3', parent=self,
              pos=wx.Point(40, 40), size=wx.Size(72, 13), style=0)

        self.staticText4 = wx.StaticText(id=-1,
              label='Transparency', name='staticText4', parent=self,
              pos=wx.Point(40, 136), size=wx.Size(66, 13), style=0)

        self.slider1 = wx.Slider(id=-1, maxValue=100,
              minValue=0, name='slider1', parent=self, pos=wx.Point(120,
              136), size=wx.Size(168, 24), style=wx.SL_HORIZONTAL, value=0)
        self.slider1.Bind(wx.EVT_SLIDER, self.Onslider1,
              id=-1)

        self.staticText5 = wx.StaticText(id=-1,
              label='%s' %str(self.dipole_min_time), name='staticText5', parent=self,
              pos=wx.Point(120, 40), size=wx.Size(40, 13), style=0)#TODO - hack -hardcoded for HBM

        self.textCtrl2 = wx.TextCtrl(id=-1, name='textCtrl2',
              parent=self, pos=wx.Point(304, 72), size=wx.Size(72, 21),
              style=0, value=str(self.dipole_min_time))
        self.textCtrl2.Bind(wx.EVT_TEXT, self.OnTextCtrl2TextEnter,
              id=-1)


        self.slider2 = wx.Slider(id=-1, maxValue=self.dipole_max_time,
              minValue=self.dipole_min_time, name='slider2', parent=self, pos=wx.Point(136,
              72), size=wx.Size(168, 24), style=wx.SL_HORIZONTAL, value=0)#TODO - hack -hardcoded for HBM
        self.slider2.Bind(wx.EVT_SLIDER, self.Onslider2,
              id=-1)

        self.textCtrl3 = wx.TextCtrl(id=-1, name='textCtrl3',
              parent=self, pos=wx.Point(304, 136), size=wx.Size(72, 21),
              style=0, value='100')
        self.textCtrl3.Bind(wx.EVT_TEXT, self.OnTextCtrl3TextEnter,
              id=-1)

        self.staticText6 = wx.StaticText(id=-1,
              label='Current time-point', name='staticText6',
              parent=self, pos=wx.Point(40, 72), size=wx.Size(88, 13),
              style=0)
    
    def Onslider2(self, event):
        new_position = self.slider2.GetValue()
        Update_4DNI_dipole(self.frame_parent, self, int(new_position), self.ar,
                           self.line, self.Sphere)
        self.textCtrl2.SetValue(str(new_position))
        
        
    def Onslider1(self, event):
        opacity = self.slider1.GetValue()/100.0
        self.line_actor.GetProperty().SetOpacity(1-opacity)
        self.sphere_actor.GetProperty().SetOpacity(1-opacity)
        self.textCtrl3.SetValue('%d' %int((opacity)*100))
        self.frame_parent.widget.Render()
        event.Skip()
        
    def OnTextCtrl2TextEnter(self, event):
        new_position = int(self.textCtrl2.GetValue())
        UpdateMinNormType1(self.frame_parent, self, int(new_position))
        self.slider2.SetValue(new_position)
        
    def OnTextCtrl3TextEnter(self, event):
        new_val = int(self.textCtrl3.GetValue())
        if new_val > 100:
            self.textCtrl3.SetValue('100')
            new_val = 100
        elif new_val < 0:
            self.textCtrl3.SetValue('0')
            new_val = 0
        self.slider1.SetValue(new_val)
        self.line_actor.GetProperty().SetOpacity((100-new_val)/100.0)
        self.sphere_actor.GetProperty().SetOpacity((100-new_val)/100.0)        
        self.frame_parent.widget.Render()




class PropertyPanel_MinNormType1(wx.Panel):
    def __init__(self, parent, frame_parent, thevtkobject):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        self.thevtkobject = thevtkobject
        self.parent = parent
        
        self.parent.SetSize(wx.Size(410,310))
        
        self.data_source_path = thevtkobject.my_data_path
        self.index_into_objects = len(self.frame_parent.ListOfObjects)-1
        
        
        self.staticBox1 = wx.StaticBox(id=-1,
              label='Colours', name='staticBox1', parent=self,
              pos=wx.Point(24, 112), size=wx.Size(360, 56), style=0)

        self.staticBox2 = wx.StaticBox(id=-1,
              label='Time-series', name='staticBox2', parent=self,
              pos=wx.Point(24, 16), size=wx.Size(360, 88), style=0)

        self.staticBox3 = wx.StaticBox(id=-1,
              label='Data source', name='staticBox3', parent=self,
              pos=wx.Point(24, 176), size=wx.Size(360, 48), style=0)

        self.textCtrl1 = wx.TextCtrl(id=-1, name='textCtrl1',
              parent=self, pos=wx.Point(32, 192), size=wx.Size(336, 21),
              style=0, value=self.data_source_path)
        self.textCtrl1.SetEditable(False)

        self.staticText1 = wx.StaticText(id=-1,
              label='Last time-point', name='staticText1', parent=self,
              pos=wx.Point(208, 40), size=wx.Size(71, 13), style=0)

        self.staticText2 = wx.StaticText(id=-1,
              label='347', name='staticText2', parent=self,
              pos=wx.Point(288, 40), size=wx.Size(40, 13), style=0)#TODO - hack -hardcoded for HBM

        self.staticText3 = wx.StaticText(id=-1,
              label='First time-point', name='staticText3', parent=self,
              pos=wx.Point(40, 40), size=wx.Size(72, 13), style=0)

        self.staticText4 = wx.StaticText(id=-1,
              label='Transparency', name='staticText4', parent=self,
              pos=wx.Point(40, 136), size=wx.Size(66, 13), style=0)

        self.slider1 = wx.Slider(id=-1, maxValue=100,
              minValue=0, name='slider1', parent=self, pos=wx.Point(120,
              136), size=wx.Size(168, 24), style=wx.SL_HORIZONTAL, value=0)
        self.slider1.Bind(wx.EVT_SLIDER, self.Onslider1,
              id=-1)

        self.staticText5 = wx.StaticText(id=-1,
              label='1', name='staticText5', parent=self,
              pos=wx.Point(120, 40), size=wx.Size(40, 13), style=0)#TODO - hack -hardcoded for HBM

        self.textCtrl2 = wx.TextCtrl(id=-1, name='textCtrl2',
              parent=self, pos=wx.Point(304, 72), size=wx.Size(72, 21),
              style=0, value='0')
        self.textCtrl2.Bind(wx.EVT_TEXT, self.OnTextCtrl2TextEnter,
              id=-1)


        self.slider2 = wx.Slider(id=-1, maxValue=347,
              minValue=1, name='slider2', parent=self, pos=wx.Point(136,
              72), size=wx.Size(168, 24), style=wx.SL_HORIZONTAL, value=0)#TODO - hack -hardcoded for HBM
        self.slider2.Bind(wx.EVT_SLIDER, self.Onslider2,
              id=-1)

        self.textCtrl3 = wx.TextCtrl(id=-1, name='textCtrl3',
              parent=self, pos=wx.Point(304, 136), size=wx.Size(72, 21),
              style=0, value='100')
        self.textCtrl3.Bind(wx.EVT_TEXT, self.OnTextCtrl3TextEnter,
              id=-1)

        self.staticText6 = wx.StaticText(id=-1,
              label='Current time-point', name='staticText6',
              parent=self, pos=wx.Point(40, 72), size=wx.Size(88, 13),
              style=0)
    
    def Onslider2(self, event):
        new_position = self.slider2.GetValue()
        UpdateMinNormType1(self.frame_parent, self, int(new_position))
        self.textCtrl2.SetValue(str(new_position))
        
        
    def Onslider1(self, event):
        opacity = self.slider1.GetValue()/100.0
        self.thevtkobject.GetProperty().SetOpacity(1-opacity)
        self.textCtrl3.SetValue('%d' %int((opacity)*100))
        self.frame_parent.widget.Render()
        event.Skip()
        
    def OnTextCtrl2TextEnter(self, event):
        new_position = int(self.textCtrl2.GetValue())
        UpdateMinNormType1(self.frame_parent, self, int(new_position))
        self.slider2.SetValue(new_position)
        
    def OnTextCtrl3TextEnter(self, event):
        new_val = int(self.textCtrl3.GetValue())
        if new_val > 100:
            self.textCtrl3.SetValue('100')
            new_val = 100
        elif new_val < 0:
            self.textCtrl3.SetValue('0')
            new_val = 0
        self.slider1.SetValue(new_val)
        self.thevtkobject.GetProperty().SetOpacity((100-new_val)/100.0)
        self.frame_parent.widget.Render()




class PropertyPanel_3DContourPlot(wx.Panel):
    def __init__(self, parent, frame_parent, thevtkobject):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        self.thevtkobject = thevtkobject
        self.parent = parent
        
        self.parent.SetSize(wx.Size(410,310))
        
        self.data_source_path = thevtkobject.my_data_path
        self.index_into_objects = len(self.frame_parent.ListOfObjects)-1
        pretrig = self.frame_parent.ListOfObjects[self.index_into_objects].pretrig
        duration = self.frame_parent.ListOfObjects[self.index_into_objects].duration
        
        self.staticBox1 = wx.StaticBox(id=-1,
              label='Colours', name='staticBox1', parent=self,
              pos=wx.Point(24, 112), size=wx.Size(360, 56), style=0)

        self.staticBox2 = wx.StaticBox(id=-1,
              label='Time-series', name='staticBox2', parent=self,
              pos=wx.Point(24, 16), size=wx.Size(360, 88), style=0)

        self.staticBox3 = wx.StaticBox(id=-1,
              label='Data source', name='staticBox3', parent=self,
              pos=wx.Point(24, 176), size=wx.Size(360, 48), style=0)

        self.textCtrl1 = wx.TextCtrl(id=-1, name='textCtrl1',
              parent=self, pos=wx.Point(32, 192), size=wx.Size(336, 21),
              style=0, value=self.data_source_path)
        self.textCtrl1.SetEditable(False)

        self.staticText1 = wx.StaticText(id=-1,
              label='Last time-point', name='staticText1', parent=self,
              pos=wx.Point(208, 40), size=wx.Size(71, 13), style=0)

        self.staticText2 = wx.StaticText(id=-1,
              label='+%d' %(duration-pretrig), name='staticText2', parent=self,
              pos=wx.Point(288, 40), size=wx.Size(40, 13), style=0)#TODO - hack -hardcoded for HBM

        self.staticText3 = wx.StaticText(id=-1,
              label='First time-point', name='staticText3', parent=self,
              pos=wx.Point(40, 40), size=wx.Size(72, 13), style=0)

        self.staticText4 = wx.StaticText(id=-1,
              label='Transparency', name='staticText4', parent=self,
              pos=wx.Point(40, 136), size=wx.Size(66, 13), style=0)

        self.slider1 = wx.Slider(id=-1, maxValue=100,
              minValue=0, name='slider1', parent=self, pos=wx.Point(120,
              136), size=wx.Size(168, 24), style=wx.SL_HORIZONTAL, value=0)
        self.slider1.Bind(wx.EVT_SLIDER, self.Onslider1,
              id=-1)

        self.staticText5 = wx.StaticText(id=-1,
              label='%d' %(0-pretrig), name='staticText5', parent=self,
              pos=wx.Point(120, 40), size=wx.Size(40, 13), style=0)#TODO - hack -hardcoded for HBM

        self.textCtrl2 = wx.TextCtrl(id=-1, name='textCtrl2',
              parent=self, pos=wx.Point(304, 72), size=wx.Size(72, 21),
              style=0, value='0')
        self.textCtrl2.Bind(wx.EVT_TEXT, self.OnTextCtrl2TextEnter,
              id=-1)


        self.slider2 = wx.Slider(id=-1, maxValue=(duration-pretrig),
              minValue=(0-pretrig), name='slider2', parent=self, pos=wx.Point(136,
              72), size=wx.Size(168, 24), style=wx.SL_HORIZONTAL, value=0)
        self.slider2.Bind(wx.EVT_SLIDER, self.Onslider2,
              id=-1)

        self.textCtrl3 = wx.TextCtrl(id=-1, name='textCtrl3',
              parent=self, pos=wx.Point(304, 136), size=wx.Size(72, 21),
              style=0, value='100')
        self.textCtrl3.Bind(wx.EVT_TEXT, self.OnTextCtrl3TextEnter,
              id=-1)

        self.staticText6 = wx.StaticText(id=-1,
              label='Current time-point', name='staticText6',
              parent=self, pos=wx.Point(40, 72), size=wx.Size(88, 13),
              style=0)
    
    def Onslider2(self, event):
        new_position = self.slider2.GetValue()
        UpdateContourPlot3D(self.frame_parent, self, int(new_position))
        self.textCtrl2.SetValue(str(new_position))
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)
        
        
    def Onslider1(self, event):
        opacity = self.slider1.GetValue()/100.0
        self.thevtkobject.GetProperty().SetOpacity(1-opacity)
        self.textCtrl3.SetValue('%d' %int((opacity)*100))
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)
        event.Skip()
        
    def OnTextCtrl2TextEnter(self, event):
        new_position = int(self.textCtrl2.GetValue())
        UpdateContourPlot3D(self.frame_parent, self, int(new_position))
        self.slider2.SetValue(new_position)
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)
        
    def OnTextCtrl3TextEnter(self, event):
        new_val = int(self.textCtrl3.GetValue())
        if new_val > 100:
            self.textCtrl3.SetValue('100')
            new_val = 100
        elif new_val < 0:
            self.textCtrl3.SetValue('0')
            new_val = 0
        self.slider1.SetValue(new_val)
        self.thevtkobject.GetProperty().SetOpacity((100-new_val)/100.0)
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)
        
        


class PropertyPanel_TMSCoil(wx.Panel): #TODO - finsih this panel
    def __init__(self, parent, frame_parent, thevtkobject):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        self.thevtkobject = thevtkobject
        
        self.data_source_path = thevtkobject.my_data_path

        self.window_CT = wx.StaticBox(id=-1,
              label='Colour / Transparency', name='window_CT', parent=self,
              pos=wx.Point(12, 24), size=wx.Size(265, 90), style=0)
        
        self.ColourChooseButton = wx.Button(self, -1, 'Choose a new colour', (25,45))
        self.Bind(wx.EVT_BUTTON, self.OnColourChooseButton, self.ColourChooseButton)

        self.transp_text_label = wx.StaticText(id=-1, label='Transparency:', name='TranspT',
              parent=self, pos=wx.Point(25, 85), size=wx.Size(75, 13),
              style=0)

        #self.transp_value_label = wx.StaticText(id=-1, label='0%', name='TranspT',
        #      parent=self, pos=wx.Point(235, 85), size=wx.Size(35, 13),
        #      style=0)

        self.transp_value_label = wx.TextCtrl(id=-1, name='TranspT',
              parent=self, pos=wx.Point(235, 85), size=wx.Size(35, 20),
              style=wx.TE_RIGHT, value='0')
        self.transp_value_label.SetEditable(1)
        self.transp_value_label.Bind(wx.EVT_TEXT, self.OnManualTransp, id=-1)
        

        self.SliderTransparency = wx.Slider(id=-1, maxValue=100,
              minValue = 0, name='TransparencySlider', parent=self, pos=wx.Point(100,
              85), size=wx.Size(125, 16), style=wx.SL_HORIZONTAL, value=0)
        self.SliderTransparency.Bind(wx.EVT_SLIDER, self.OnSliderTransparency,
              id=-1)

        self.box = wx.StaticBox(id=-1,
              label='Coil location', name='coilWidget', parent=self,
              pos=wx.Point(12, 120), size=wx.Size(265, 100), style=0)

        self.WidgetButton = wx.ToggleButton(self, -1, 'OFF', (200,140))
        self.Bind(wx.EVT_TOGGLEBUTTON, self.OnWidgetButton, self.WidgetButton)

        self.text_label2 = wx.StaticText(id=-1, label='TMS Coil position widget', name='instr',
              parent=self, pos=wx.Point(25, 140), 
              style=0)

        self.WidgetManualPlacement = wx.Button(self, -1, 'Launch fine controls', (35,180))
        self.Bind(wx.EVT_BUTTON, self.OnWidgetManualPlacementButton, self.WidgetManualPlacement)



    def OnWidgetManualPlacementButton(self, evt):
        pass


    def OnWidgetButton(self, evt):
        if self.WidgetButton.GetValue() == 1:
            self.frame_parent.TMS_Widget.On()
            self.WidgetButton.SetLabel('On')
        else:
            self.frame_parent.TMS_Widget.Off()            
            self.WidgetButton.SetLabel('Off')
    
    def OnManualTransp(self, evt):
        new_val = int(self.transp_value_label.GetValue())
        if new_val > 100:
            self.transp_value_label.SetValue('100')
            new_val = 100
        elif new_val < 0:
            self.transp_value_label.SetValue('0')
            new_val = 0
        self.SliderTransparency.SetValue(new_val)
        self.thevtkobject.GetProperty().SetOpacity((100-new_val)/100.0)
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)

    def OnColourChooseButton(self, evt):
        dialog = wx.ColourDialog(self)
        if dialog.ShowModal() == wx.ID_OK:
            new_colour = dialog.GetColourData().GetColour()
            new_colour = new_colour.Get()
            self.thevtkobject.GetProperty().SetDiffuseColor(new_colour[0]/255.0, new_colour[1]/255.0, new_colour[2]/255.0)
            self.frame_parent.widget.Render()
            align_all_planes(self.frame_parent)
            
    def OnSliderTransparency(self, evt):
        opacity = self.SliderTransparency.GetValue()/100.0
        self.thevtkobject.GetProperty().SetOpacity(1-opacity)
        self.transp_value_label.SetLabel('%d' %int((opacity)*100))
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)
        evt.Skip()        



class PropertyPanel_TMSRay(wx.Panel): #TODO - finsih this panel
    def __init__(self, parent, frame_parent, thevtkobject):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        self.thevtkobject = thevtkobject
        
        self.data_source_path = thevtkobject.my_data_path

        self.window_CT = wx.StaticBox(id=-1,
              label='Colour / Transparency', name='window_CT', parent=self,
              pos=wx.Point(12, 24), size=wx.Size(265, 90), style=0)
        
        self.ColourChooseButton = wx.Button(self, -1, 'Choose a new colour', (25,45))
        self.Bind(wx.EVT_BUTTON, self.OnColourChooseButton, self.ColourChooseButton)

        self.transp_text_label = wx.StaticText(id=-1, label='Transparency:', name='TranspT',
              parent=self, pos=wx.Point(25, 85), size=wx.Size(75, 13),
              style=0)

        #self.transp_value_label = wx.StaticText(id=-1, label='0%', name='TranspT',
        #      parent=self, pos=wx.Point(235, 85), size=wx.Size(35, 13),
        #      style=0)

        self.transp_value_label = wx.TextCtrl(id=-1, name='TranspT',
              parent=self, pos=wx.Point(235, 85), size=wx.Size(35, 20),
              style=wx.TE_RIGHT, value='0')
        self.transp_value_label.SetEditable(1)
        self.transp_value_label.Bind(wx.EVT_TEXT, self.OnManualTransp, id=-1)
        

        self.SliderTransparency = wx.Slider(id=-1, maxValue=100,
              minValue = 0, name='TransparencySlider', parent=self, pos=wx.Point(100,
              85), size=wx.Size(125, 16), style=wx.SL_HORIZONTAL, value=0)
        self.SliderTransparency.Bind(wx.EVT_SLIDER, self.OnSliderTransparency,
              id=-1)

        #self.box = wx.StaticBox(id=-1,
        #      label='Ray location', name='coilWidget', parent=self,
        #      pos=wx.Point(12, 120), size=wx.Size(265, 100), style=0)
        #
        #self.WidgetButton = wx.ToggleButton(self, -1, 'OFF', (200,140))
        #self.Bind(wx.EVT_TOGGLEBUTTON, self.OnWidgetButton, self.WidgetButton)
        #
        #self.text_label2 = wx.StaticText(id=-1, label='TMS Ray position widget', name='instr',
        #      parent=self, pos=wx.Point(25, 140), 
        #      style=0)
        #
        #self.RayManualPlacement = wx.Button(self, -1, 'Run auto-place for ray', (35,180))
        #self.Bind(wx.EVT_BUTTON, self.OnRayManualPlacementButton, self.RayManualPlacement)
        #
        #self.target_set = 0
        #self.source_set = 0


    #def OnTimer(self, evt):
    #    if self.target_set == 0:
    #        if self.frame_parent.pickPos == []:
    #            pass
    #        else:
    #            self.timer.Stop()
    #            self.target = self.frame_parent.pickPos
    #            print self.target
    #            self.target_set = 1
    #            self.frame_parent.pickPos = []
    #            self.timer.Start(100)
    #            print 'Hover the mouse pointer over the ray start point and press p on your keyboard'
    #
    #    else:
    #        if self.frame_parent.pickPos == []:
    #            pass
    #        else:
    #            self.timer.Stop()
    #            self.source = self.frame_parent.pickPos
    #            print self.source
    #            self.source_set = 1
    #            
    #            t = vtk.vtkSphereSource()
    #            t.SetRadius(5)
    #            t.SetCenter(self.target)
    #            tt = vtk.vtkPolyDataMapper()
    #            tt.SetInput(t.GetOutput())
    #            ttt = vtk.vtkActor()
    #            ttt.SetMapper(tt)
    #            
    #            self.frame_parent.ren.AddActor(ttt)
    #
    #            t2 = vtk.vtkSphereSource()
    #            t2.SetRadius(5)
    #            t2.SetCenter(self.source)
    #            tt2 = vtk.vtkPolyDataMapper()
    #            tt2.SetInput(t2.GetOutput())
    #            ttt2 = vtk.vtkActor()
    #            ttt2.SetMapper(tt2)
    #            
    #            self.frame_parent.ren.AddActor(ttt2)
    #           
    #            #clean up
    #            self.target_set = 0
    #            self.source_set = 0
    #            self.frame_parent.pickPos = []
    #            
    #            
    #            
    #
    #def OnRayManualPlacementButton(self, evt):
    #    self.Bind(wx.EVT_TIMER, self.OnTimer)
    #    self.timer = wx.Timer(self)
    #    self.timer.Start(100)
    #    print 'Hover the mouse pointer over the ray target and press p on your keyboard'
    #
    #
    #
    #def OnWidgetButton(self, evt):
    #    if self.WidgetButton.GetValue() == 1:
    #        self.frame_parent.Ray_Widget.On()
    #        self.WidgetButton.SetLabel('On')
    #    else:
    #        self.frame_parent.Ray_Widget.Off()            
    #        self.WidgetButton.SetLabel('Off')
    
    def OnManualTransp(self, evt):
        new_val = int(self.transp_value_label.GetValue())
        if new_val > 100:
            self.transp_value_label.SetValue('100')
            new_val = 100
        elif new_val < 0:
            self.transp_value_label.SetValue('0')
            new_val = 0
        self.SliderTransparency.SetValue(new_val)
        self.thevtkobject.GetProperty().SetOpacity((100-new_val)/100.0)
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)

    def OnColourChooseButton(self, evt):
        dialog = wx.ColourDialog(self)
        if dialog.ShowModal() == wx.ID_OK:
            new_colour = dialog.GetColourData().GetColour()
            new_colour = new_colour.Get()
            self.thevtkobject.GetProperty().SetDiffuseColor(new_colour[0]/255.0, new_colour[1]/255.0, new_colour[2]/255.0)
            self.frame_parent.widget.Render()
            align_all_planes(self.frame_parent)
            
    def OnSliderTransparency(self, evt):
        opacity = self.SliderTransparency.GetValue()/100.0
        self.thevtkobject.GetProperty().SetOpacity(1-opacity)
        self.transp_value_label.SetLabel('%d' %int((opacity)*100))
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)
        evt.Skip()


class PropertyPanel_Markers(wx.Panel): #TODO - finsih this panel
    def __init__(self, parent, frame_parent, thevtkobject):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        self.thevtkobject = thevtkobject
        
        self.data_source_path = thevtkobject.my_data_path

        self.window_CT = wx.StaticBox(id=-1,
              label='Colour / Transparency', name='window_CT', parent=self,
              pos=wx.Point(12, 12), size=wx.Size(265, 90), style=0)
        
        self.ColourChooseButton = wx.Button(self, -1, 'Choose a new colour', (25,33))
        self.Bind(wx.EVT_BUTTON, self.OnColourChooseButton, self.ColourChooseButton)
        
        self.Surface1Surface2 = wx.ToggleButton(self, -1, 'Front', (200, 33))
        self.Bind(wx.EVT_TOGGLEBUTTON, self.OnSurface1Surface2, self.Surface1Surface2)
        
        self.transp_text_label = wx.StaticText(id=-1, label='Transparency:', name='TranspT',
              parent=self, pos=wx.Point(25, 73), size=wx.Size(75, 13),
              style=0)

        #self.transp_value_label = wx.StaticText(id=-1, label='0%', name='TranspT',
        #      parent=self, pos=wx.Point(235, 85), size=wx.Size(35, 13),
        #      style=0)

        self.transp_value_label = wx.TextCtrl(id=-1, name='TranspT',
              parent=self, pos=wx.Point(235, 73), size=wx.Size(35, 20),
              style=wx.TE_RIGHT, value='0')
        self.transp_value_label.SetEditable(1)
        self.transp_value_label.Bind(wx.EVT_TEXT, self.OnManualTransp, id=-1)
        

        self.SliderTransparency = wx.Slider(id=-1, maxValue=100,
              minValue = 0, name='TransparencySlider', parent=self, pos=wx.Point(100,
              73), size=wx.Size(125, 16), style=wx.SL_HORIZONTAL, value=0)
        self.SliderTransparency.Bind(wx.EVT_SLIDER, self.OnSliderTransparency,
              id=-1)

        self.box = wx.StaticBox(id=-1,
              label='Probe underlying data', name='probe', parent=self,
              pos=wx.Point(12, 108), size=wx.Size(265, 45), style=0)

        self.ProbeButton = wx.Button(self, -1, 'Report coordinates', (30,128))
        self.Bind(wx.EVT_BUTTON, self.OnProbeButton, self.ProbeButton)

        self.annotations_box = wx.StaticBox(id=-1,
              label='', name='window_anno', parent=self,
              pos=wx.Point(12, 214), size=wx.Size(265, 40), style=0)
                
        self.source_text_label = wx.StaticText(id=-1, label='Source:', name='SourceT',
              parent=self, pos=wx.Point(20, 225), size=wx.Size(50, 13),
              style=0)

        self.source_text = wx.TextCtrl(id=-1, name='Source',
              parent=self, pos=wx.Point(70, 225), size=wx.Size(200, 20),
              style=wx.TE_RIGHT, value='%s' %thevtkobject.my_data_path)
        self.source_text.SetEditable(0)


    def OnSurface1Surface2(self, evt):
        if self.Surface1Surface2.GetValue() == 1:
            self.Surface1Surface2.SetLabel('Back')
        else:
            self.Surface1Surface2.SetLabel('Front')    


    def OnProbeButton(self, evt):
        print 'bounds = ', self.thevtkobject.GetBounds()
        print 'center = ', self.thevtkobject.GetCenter()
        
    
    def OnManualTransp(self, evt):
        new_val = int(self.transp_value_label.GetValue())
        if new_val > 100:
            self.transp_value_label.SetValue('100')
            new_val = 100
        elif new_val < 0:
            self.transp_value_label.SetValue('0')
            new_val = 0
        self.SliderTransparency.SetValue(new_val)
        self.thevtkobject.GetProperty().SetOpacity((100-new_val)/100.0)
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)

    def OnColourChooseButton(self, evt):
        dialog = wx.ColourDialog(self)
        if dialog.ShowModal() == wx.ID_OK:
            new_colour = dialog.GetColourData().GetColour()
            new_colour = new_colour.Get()
            if self.Surface1Surface2.GetValue() == 1:
                self.thevtkobject.GetProperty().SetColor(new_colour[0]/255.0, new_colour[1]/255.0, new_colour[2]/255.0)
            else:
                prop = vtk.vtkProperty()
                prop.SetDiffuseColor(new_colour[0]/255.0, new_colour[1]/255.0, new_colour[2]/255.0)
                self.thevtkobject.SetBackfaceProperty(prop)
                
            self.frame_parent.widget.Render()
            align_all_planes(self.frame_parent)
            
    def OnSliderTransparency(self, evt):
        opacity = self.SliderTransparency.GetValue()/100.0
        
        if self.Surface1Surface2.GetValue() == 1:
            self.thevtkobject.GetProperty().SetOpacity(1-opacity)
        else:
            prop = vtk.vtkProperty()
            prop.SetOpacity(1-opacity)
            self.thevtkobject.SetBackfaceProperty(prop)
        
        #self.thevtkobject.GetProperty().SetOpacity(1-opacity)
        self.transp_value_label.SetLabel('%d' %int((opacity)*100))
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)
        evt.Skip()  




class PropertyPanel_SurfaceFromFile(wx.Panel): #TODO - finsih this panel
    def __init__(self, parent, frame_parent, thevtkobject):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        self.thevtkobject = thevtkobject
        
        self.data_source_path = thevtkobject.my_data_path

        self.window_CT = wx.StaticBox(id=-1,
              label='Colour / Transparency', name='window_CT', parent=self,
              pos=wx.Point(12, 12), size=wx.Size(265, 90), style=0)
        
        self.ColourChooseButton = wx.Button(self, -1, 'Choose a new colour', (25,33))
        self.Bind(wx.EVT_BUTTON, self.OnColourChooseButton, self.ColourChooseButton)
        
        self.Surface1Surface2 = wx.ToggleButton(self, -1, 'Front', (200, 33))
        self.Bind(wx.EVT_TOGGLEBUTTON, self.OnSurface1Surface2, self.Surface1Surface2)
        
        self.transp_text_label = wx.StaticText(id=-1, label='Transparency:', name='TranspT',
              parent=self, pos=wx.Point(25, 73), size=wx.Size(75, 13),
              style=0)

        #self.transp_value_label = wx.StaticText(id=-1, label='0%', name='TranspT',
        #      parent=self, pos=wx.Point(235, 85), size=wx.Size(35, 13),
        #      style=0)

        self.transp_value_label = wx.TextCtrl(id=-1, name='TranspT',
              parent=self, pos=wx.Point(235, 73), size=wx.Size(35, 20),
              style=wx.TE_RIGHT, value='0')
        self.transp_value_label.SetEditable(1)
        self.transp_value_label.Bind(wx.EVT_TEXT, self.OnManualTransp, id=-1)
        

        self.SliderTransparency = wx.Slider(id=-1, maxValue=100,
              minValue = 0, name='TransparencySlider', parent=self, pos=wx.Point(100,
              73), size=wx.Size(125, 16), style=wx.SL_HORIZONTAL, value=0)
        self.SliderTransparency.Bind(wx.EVT_SLIDER, self.OnSliderTransparency,
              id=-1)

        self.box = wx.StaticBox(id=-1,
              label='Probe underlying data', name='probe', parent=self,
              pos=wx.Point(12, 108), size=wx.Size(265, 45), style=0)

        self.ProbeButton = wx.Button(self, -1, 'GO', (200,128))
        self.Bind(wx.EVT_BUTTON, self.OnProbeButton, self.ProbeButton)

        self.text_label2 = wx.StaticText(id=-1, label='map stat data to surface', name='instr',
              parent=self, pos=wx.Point(25, 128), 
              style=0)


        self.box_clipper = wx.StaticBox(id=-1,
              label='Clip the surface', name='clipper', parent=self,
              pos=wx.Point(12, 160), size=wx.Size(265, 45), style=0)

        self.ClipperOnOff = wx.ToggleButton(self, -1, 'Clipper OFF', (25,180))
        self.Bind(wx.EVT_TOGGLEBUTTON, self.OnClipperOnOffButton, self.ClipperOnOff)


        self.Wireframe = wx.ToggleButton(self, -1, 'Wireframe OFF', (325,180))
        self.Bind(wx.EVT_TOGGLEBUTTON, self.OnWireframeButton, self.Wireframe)

        self.ClipperInsideOut = wx.ToggleButton(self, -1, 'Clip outside', (150,180))
        self.Bind(wx.EVT_TOGGLEBUTTON, self.OnClipperInsideOutButton, self.ClipperInsideOut)
        self.ClipperInsideOut.SetValue(1)




        self.annotations_box = wx.StaticBox(id=-1,
              label='', name='window_anno', parent=self,
              pos=wx.Point(12, 214), size=wx.Size(265, 40), style=0)
                
        self.source_text_label = wx.StaticText(id=-1, label='Source:', name='SourceT',
              parent=self, pos=wx.Point(20, 225), size=wx.Size(50, 13),
              style=0)

        self.source_text = wx.TextCtrl(id=-1, name='Source',
              parent=self, pos=wx.Point(70, 225), size=wx.Size(200, 20),
              style=wx.TE_RIGHT, value='%s' %thevtkobject.my_data_path)
        self.source_text.SetEditable(0)


    def OnSurface1Surface2(self, evt):
        if self.Surface1Surface2.GetValue() == 1:
            self.Surface1Surface2.SetLabel('Back')
        else:
            self.Surface1Surface2.SetLabel('Front')    


    def OnClipperInsideOutButton(self, evt):
        if self.ClipperInsideOut.GetValue() == 1:
            self.ClipperInsideOut.SetLabel('Clip outside')
            self.thevtkobject.my_Clipper.InsideOutOn()
            self.thevtkobject.my_Clipper.UpdateWholeExtent()
            self.thevtkobject.my_Clipper.Modified()
            self.thevtkobject.my_ClipperBoxWidget.Modified()
            self.frame_parent.widget.Render()
        else:
            self.ClipperInsideOut.SetLabel('Clip inside')
            self.thevtkobject.my_Clipper.InsideOutOff()
            self.thevtkobject.my_Clipper.UpdateWholeExtent()
            self.thevtkobject.my_Clipper.Modified()
            self.thevtkobject.my_ClipperBoxWidget.Modified()
            self.frame_parent.widget.Render()
    
    def OnClipperOnOffButton(self, evt):
        if self.ClipperOnOff.GetValue() == 1:
            self.ClipperOnOff.SetLabel('Clipper ON')
            self.thevtkobject.my_ClipperBoxWidget.On()
            self.thevtkobject.my_ClipperBoxWidget.Modified()
            self.frame_parent.widget.Render()
        else:
            self.ClipperOnOff.SetLabel('Clipper OFF')
            self.thevtkobject.my_ClipperBoxWidget.Off()
            self.thevtkobject.my_ClipperBoxWidget.Modified()
            self.frame_parent.widget.Render()

    def OnWireframeButton(self, evt):
        if self.Wireframe.GetValue() == 1:
            self.Wireframe.SetLabel('Wireframe ON')
            self.thevtkobject.GetProperty().SetRepresentationToWireframe()
            self.frame_parent.widget.Render()
        else:
            self.Wireframe.SetLabel('Wireframe OFF')
            self.thevtkobject.GetProperty().SetRepresentationToSurface()
            self.frame_parent.widget.Render()



    def OnProbeButton(self, evt):
        frame = MyLocalDialogFrame(self.frame_parent, 'Surface_Intersection', self.thevtkobject)
        frame.Show()
        
    
    def OnManualTransp(self, evt):
        new_val = int(self.transp_value_label.GetValue())
        if new_val > 100:
            self.transp_value_label.SetValue('100')
            new_val = 100
        elif new_val < 0:
            self.transp_value_label.SetValue('0')
            new_val = 0
        self.SliderTransparency.SetValue(new_val)
        self.thevtkobject.GetProperty().SetOpacity((100-new_val)/100.0)
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)

    def OnColourChooseButton(self, evt):
        dialog = wx.ColourDialog(self)
        if dialog.ShowModal() == wx.ID_OK:
            new_colour = dialog.GetColourData().GetColour()
            new_colour = new_colour.Get()
            if self.Surface1Surface2.GetValue() == 1:
                self.thevtkobject.GetProperty().SetColor(new_colour[0]/255.0, new_colour[1]/255.0, new_colour[2]/255.0)
            else:
                prop = vtk.vtkProperty()
                prop.SetDiffuseColor(new_colour[0]/255.0, new_colour[1]/255.0, new_colour[2]/255.0)
                self.thevtkobject.SetBackfaceProperty(prop)
                
            self.frame_parent.widget.Render()
            align_all_planes(self.frame_parent)
            
    def OnSliderTransparency(self, evt):
        opacity = self.SliderTransparency.GetValue()/100.0
        
        if self.Surface1Surface2.GetValue() == 1:
            self.thevtkobject.GetProperty().SetOpacity(1-opacity)
        else:
            prop = vtk.vtkProperty()
            prop.SetOpacity(1-opacity)
            self.thevtkobject.SetBackfaceProperty(prop)
        
        #self.thevtkobject.GetProperty().SetOpacity(1-opacity)
        self.transp_value_label.SetLabel('%d' %int((opacity)*100))
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)
        evt.Skip()        


class MyLocalDialogFrame(wx.Frame):
    def __init__(self, frame_parent, type, thevtkobject):
        wx.Frame.__init__(self, None, -1, 'Input required ...',  size=(300, 300), style=wx.STAY_ON_TOP|wx.DEFAULT_FRAME_STYLE)
        #check which type of object we are creating a property panel for
        # and call the appropriate panel class
                
        #if we are dealing with the 'base' image ...
        if type == 'Surface_Intersection':
            panel = SelectOverlayToIntersect(self, frame_parent, thevtkobject)


class SelectOverlayToIntersect(wx.Panel):
    def __init__(self, parent, frame_parent, thevtkobject):
        wx.Panel.__init__(self, parent, -1)  
        
        #some constants to allow handling later
        self.parent = parent
        self.frame_parent = frame_parent
        self.index_to_data = 0
        self.thevtkobject = thevtkobject
        
        
        drop_down_content = [] #the list holder for the volume selection
        drop_down_content.append('')
        
        #scan all loaded volumes not base, tal, or ref (start at 4th element)
        
        for i in range(3,len(self.frame_parent.my_loaded_volumes)):
            #check if any objects are associated with them therefore if list items exist
            for j in range(len(self.frame_parent.ListOfObjects)):
                #as before ..
                try:
                    if self.frame_parent.ListOfObjects[j].my_loaded_volumesindex == i:
                        label = self.frame_parent.ListOfObjects[j].my_label
                        if drop_down_content[-1] == label:
                            pass
                        else:
                            drop_down_content.append(label)
                except:
                    pass

        
        if drop_down_content == ['']:
            print 'No overlay volumes suitable for intersection loaded / generated yet.'
            self.parent.Destroy()
        
        self.OverlayChoiceLabel = wx.StaticText(id=-1, label='Choose an overlay to intersect:', name='ChooseOverlay',
              parent=self, pos=wx.Point(16, 16), style=0)
        
        self.OverlayChoice = wx.Choice(choices=drop_down_content, id=-1,
              name='OverlayChoice', parent=self, pos=wx.Point(16, 42),
              size=wx.Size(250, 21), style=0)
        
        self.DoIntersect = wx.Button(self, -1, 'Export Now', (100,200))
        self.Bind(wx.EVT_BUTTON, self.OnDoIntersectButton, self.DoIntersect)


    def OnDoIntersectButton(self, event):
        choice = self.OverlayChoice.GetStringSelection()
        for j in range(len(self.frame_parent.ListOfObjects)):
            #try:
                if choice == self.frame_parent.ListOfObjects[j].my_label:
                    
                    volume_to_intersect = self.frame_parent.ListOfObjects[j].my_loaded_volumesindex
                    self.parent.Destroy()
                    UseCurrentSurfaceAsDataProbe(self.frame_parent, self.thevtkobject,
                                     self.frame_parent.my_loaded_volumes[volume_to_intersect])
                    return
            #except:
            #    print 'export failed for some reason (?) ...'
            #    pass #TODO fix

        
class MyPropertyFrame(wx.Frame):
    def __init__(self, frame_parent, thevtkobject, index_in_volume_list):
        label = thevtkobject.my_label
        wx.Frame.__init__(self, None, -1, 'Properties for '+label, size=(300, 300), style=wx.STAY_ON_TOP|wx.DEFAULT_FRAME_STYLE)
        #check which type of object we are creating a property panel for
        # and call the appropriate panel class
        
        #if we are dealing with the 'base' image ...
        if thevtkobject == frame_parent.ListOfObjects[3]:      
            panel = PropertyPanel_BasePlaneWidgets(self, frame_parent, thevtkobject)
        
        #else:
        elif thevtkobject.my_property_frame_type == 'PlaneWidgetProperties':
            panel = PropertyPanel_OverlayPlaneWidgets(self, frame_parent, thevtkobject)
            #label the frame with its corresponding data volume (so we can update later)
            panel.index_in_volume_list = index_in_volume_list
        elif thevtkobject.my_property_frame_type == 'SurfaceProperties':
            panel = PropertyPanel_SurfaceFromFile(self, frame_parent, thevtkobject)
            #label the frame with its corresponding data volume (so we can update later)
            panel.index_in_volume_list = index_in_volume_list
        elif thevtkobject.my_property_frame_type == '3DContourPlotProperties':
            panel = PropertyPanel_3DContourPlot(self, frame_parent, thevtkobject)
        elif thevtkobject.my_property_frame_type == 'MinNormType1':
            panel = PropertyPanel_MinNormType1(self, frame_parent, thevtkobject)
        elif thevtkobject.my_property_frame_type == '4DNI_Dipole':
            panel = PropertyPanel_4DNI_Dipole(self, frame_parent, thevtkobject)
        elif thevtkobject.my_property_frame_type == 'TMSCoilProperties':
            panel = PropertyPanel_TMSCoil(self, frame_parent, thevtkobject)
        elif thevtkobject.my_property_frame_type == 'TMSRayProperties':
            panel = PropertyPanel_TMSRay(self, frame_parent, thevtkobject)
        elif thevtkobject.my_property_frame_type == 'MarkerProperties':
            panel = PropertyPanel_Markers(self, frame_parent, thevtkobject)
        else:
            pass
        
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
        
        
    def OnCloseWindow(self, event):
        self.Show(False)



        