import vtk

def AddPolyDataClipper(frame_parent, PolyDataObject):
    
    #PolyDataObject = PolyDataObject.GetLastActor()
    f = PolyDataObject.GetMapper().GetInput()
    
    output = f
    output.Update()
    
    planes1 = vtk.vtkPlanes()
    clipper1 = vtk.vtkClipPolyData()
    clipper1.SetInput(output)
    clipper1.SetClipFunction(planes1)
    clipper1.InsideOutOn()
    selectMapper1 = vtk.vtkPolyDataMapper()
    selectMapper1.SetInput(clipper1.GetOutput())
    #TODO fix
    try:
        if PolyDataObject.vertex_file[-5:-4] != 's':
            selectMapper1.SetColorModeToDefault()
            selectMapper1.ScalarVisibilityOff()
    except:
        pass
    selectActor1 = vtk.vtkLODActor()
    selectActor1.SetMapper(selectMapper1)
    #inherit the colors and transparency assigned to the original actor
    selectActor1.GetProperty().SetColor(PolyDataObject.GetProperty().GetColor())
    selectActor1.GetProperty().SetOpacity(PolyDataObject.GetProperty().GetOpacity())
    
    
    #set some properties for the inner face
    #property1 = vtk.vtkProperty()
    #property1.SetColor((0.6, 0.6, 0.6))

    #selectActor1.SetBackfaceProperty(property1)
    #selectActor1.SetScale(1.01, 1.01, 1.01)
    
    #frame_parent.ren.AddActor(selectActor1)
    
    # This callback funciton does the actual work: updates the vtkPlanes
    # implicit function.  This in turn causes the pipeline to update.
    def SelectPolygons1(object, event):
        # object will be the boxWidget
        object.GetPlanes(planes1)
        selectActor1.VisibilityOn()
        
    def RefreshMe(object, event):
        object.GetPlanes(planes1)
        selectActor1.VisibilityOn()
        selectActor1.my_ClipperBoxWidget.Modified()
        frame_parent.widget.Render()
        
    
    PolyDataObject.my_ClipperBoxWidget = vtk.vtkBoxWidget()
    boxWidget = vtk.vtkBoxWidget()
    boxWidget.SetPriority(1.0)
    boxWidget.SetInteractor(frame_parent.widget)
    #boxWidget.SetKeyPressActivationValue('V')
    boxWidget.KeyPressActivationOff()
    boxWidget.SetPlaceFactor(1.25)
    
    selectActor1.my_Clipper = clipper1
    
    selectActor1.my_ClipperBoxWidget = boxWidget
    selectActor1.my_ClipperBoxWidget.SetInput(output)
            
    selectActor1.my_ClipperBoxWidget.PlaceWidget()
    selectActor1.my_ClipperBoxWidget.AddObserver("StartInteractionEvent", SelectPolygons1)
    selectActor1.my_ClipperBoxWidget.AddObserver("EndInteractionEvent", RefreshMe)
    selectActor1.my_ClipperBoxWidget.AddObserver("WidgetModifiedEvent", RefreshMe)
    
    property2 = vtk.vtkProperty()
    property2.SetDiffuseColor(1.0, 0.5, 0.4)
    #property2.SetDiffuse(0.7)
    #property2.SetSpecular(0.4)
    #property2.SetSpecularPower(20)
    
    
        
    #my_mnorm_brain.GetProperty().SetColor(1.0,0.0,0.0)
    selectActor1.SetBackfaceProperty(property2)
    
    selectActor1.VisibilityOn()


    #boxWidget2 = vtk.vtkBoxWidget()
    #boxWidget2.SetInteractor(frame_parent.widget)
    #boxWidget2.SetPlaceFactor(1.25)
    
    # As the box widget is interacted with, it produces a transformation
    # matrix that is set on the actor.
    #t = vtk.vtkTransform()
    #def TransformActor(obj, event):
    #    global t, selectActor1#, maceActor
    #    obj.GetTransform(t)
    #    selectActor1.SetUserTransform(t)
    #    
    #boxWidget2.SetProp3D(PolyDataObject)
    #boxWidget2.PlaceWidget()
    #boxWidget2.SetKeyPressActivationValue('W')
    #
    #boxWidget2.AddObserver("InteractionEvent", TransformActor)
    #selectActor1.my_TransformBoxWidget = boxWidget2
    
    #boxWidget2 = vtk.vtkBoxWidget()
    #boxWidget2.SetPriority(1.0)
    #boxWidget2.SetProp3D(selectActor1)
    #boxWidget2.SetInteractor(frame_parent.widget)
    #boxWidget2.SetKeyPressActivationValue('W')
    #boxWidget2.SetPlaceFactor(1.25)
    #
    #selectActor1.my_TransformBoxWidget = boxWidget2
    
    return selectActor1, planes1