import wx

class ColourLookupPicker(wx.Dialog):
    def __init__(self, parent, id, title, main_app_frame):
        wx.Dialog.__init__(self, parent, id=-1, title='', size=(200, 480))
        
        self.the_parent_frame = main_app_frame
        
        self.panel1 = wx.Panel(id=-1, name='panel1', parent=self,
              pos=wx.Point(0, 0), size=wx.Size(197, 463),
              style=wx.TAB_TRAVERSAL)

        self.bitmapButton1 = wx.BitmapButton(bitmap=wx.Bitmap(u'./CLT_images/red_yel.bmp',
              wx.BITMAP_TYPE_BMP), id=-1,
              name='bitmapButton1', parent=self.panel1, pos=wx.Point(40, 64),
              size=wx.Size(108, 24), style=wx.BU_AUTODRAW)
        self.bitmapButton1.Bind(wx.EVT_BUTTON, self.OnBitmapButton1Button,
              id=-1)

        self.bitmapButton2 = wx.BitmapButton(bitmap=wx.Bitmap(u'./CLT_images/yel_red.bmp',
              wx.BITMAP_TYPE_BMP), id=-1,
              name='bitmapButton2', parent=self.panel1, pos=wx.Point(40, 104),
              size=wx.Size(108, 24), style=wx.BU_AUTODRAW)
        self.bitmapButton2.Bind(wx.EVT_BUTTON, self.OnBitmapButton2Button,
              id=-1)

        self.bitmapButton3 = wx.BitmapButton(bitmap=wx.Bitmap(u'./CLT_images/blue_cyan.bmp',
              wx.BITMAP_TYPE_BMP), id=-1,
              name='bitmapButton3', parent=self.panel1, pos=wx.Point(40, 136),
              size=wx.Size(108, 24), style=wx.BU_AUTODRAW)
        self.bitmapButton3.Bind(wx.EVT_BUTTON, self.OnBitmapButton3Button,
              id=-1)

        self.bitmapButton4 = wx.BitmapButton(bitmap=wx.Bitmap(u'./CLT_images/cyan_blue.bmp',
              wx.BITMAP_TYPE_BMP), id=-1,
              name='bitmapButton4', parent=self.panel1, pos=wx.Point(40, 176),
              size=wx.Size(108, 24), style=wx.BU_AUTODRAW)
        self.bitmapButton4.Bind(wx.EVT_BUTTON, self.OnBitmapButton4Button,
              id=-1)

        self.bitmapButton5 = wx.BitmapButton(bitmap=wx.Bitmap(u'./CLT_images/wht_red.bmp',
              wx.BITMAP_TYPE_BMP), id=-1,
              name='bitmapButton5', parent=self.panel1, pos=wx.Point(40, 216),
              size=wx.Size(108, 24), style=wx.BU_AUTODRAW)
        self.bitmapButton5.Bind(wx.EVT_BUTTON, self.OnBitmapButton5Button,
              id=-1)

        self.bitmapButton6 = wx.BitmapButton(bitmap=wx.Bitmap(u'./CLT_images/wht_blue.bmp',
              wx.BITMAP_TYPE_BMP), id=-1,
              name='bitmapButton6', parent=self.panel1, pos=wx.Point(40, 256),
              size=wx.Size(108, 24), style=wx.BU_AUTODRAW)
        self.bitmapButton6.Bind(wx.EVT_BUTTON, self.OnBitmapButton6Button,
              id=-1)

        self.bitmapButton7 = wx.BitmapButton(bitmap=wx.Bitmap(u'./CLT_images/wht_grn.bmp',
              wx.BITMAP_TYPE_BMP), id=-1,
              name='bitmapButton7', parent=self.panel1, pos=wx.Point(40, 296),
              size=wx.Size(108, 24), style=wx.BU_AUTODRAW)
        self.bitmapButton7.Bind(wx.EVT_BUTTON, self.OnBitmapButton7Button,
              id=-1)

        self.bitmapButton8 = wx.BitmapButton(bitmap=wx.Bitmap(u'./CLT_images/purp_cyan.bmp',
              wx.BITMAP_TYPE_BMP), id=-1,
              name='bitmapButton8', parent=self.panel1, pos=wx.Point(40, 336),
              size=wx.Size(108, 24), style=wx.BU_AUTODRAW)
        self.bitmapButton8.Bind(wx.EVT_BUTTON, self.OnBitmapButton8Button,
              id=-1)

        self.bitmapButton9 = wx.BitmapButton(bitmap=wx.Bitmap(u'./CLT_images/cyan_purp.bmp',
              wx.BITMAP_TYPE_BMP), id=-1,
              name='bitmapButton9', parent=self.panel1, pos=wx.Point(40, 376),
              size=wx.Size(108, 24), style=wx.BU_AUTODRAW)
        self.bitmapButton9.Bind(wx.EVT_BUTTON, self.OnBitmapButton9Button,
              id=-1)

        self.bitmapButton10 = wx.BitmapButton(bitmap=wx.Bitmap(u'./CLT_images/rainbow.bmp',
              wx.BITMAP_TYPE_BMP), id=-1,
              name='bitmapButton10', parent=self.panel1, pos=wx.Point(40, 416),
              size=wx.Size(108, 24), style=wx.BU_AUTODRAW)
        self.bitmapButton10.Bind(wx.EVT_BUTTON, self.OnBitmapButton10Button,
              id=-1)

        self.staticText1 = wx.StaticText(id=-1,
              label='Click to select a table', name='staticText1',
              parent=self.panel1, pos=wx.Point(40, 24), size=wx.Size(101, 13),
                style=0)
  
        #the list of values to pass back to the routine to generate the
        # chosen lookup table for the data range
        # order = H/S/V
        self.return_colour_list = [\
            ['red_yel.bmp', 0.0, 0.167, 1.0, 1.0, 1.0, 1.0],\
            ['yel_red.bmp', 0.167, 0.0, 1.0, 1.0, 1.0, 1.0],\
            ['blue_cyan.bmp', 0.667, 0.5, 1.0, 1.0, 1.0, 1.0],\
            ['cyan_blue.bmp', 0.5, 0.667, 1.0, 1.0, 1.0, 1.0],\
            ['wht_red.bmp', 1.0, 1.0, 1.0, 1.0, 0.0, 1.0],\
            ['wht_blue.bmp', 0.667, 0.667, 1.0, 1.0, 0.0, 1.0],\
            ['wht_grn.bmp', 0.333, 0.333, 1.0, 1.0, 0.0, 1.0],\
            ['purp_cyan.bmp', 0.833, 0.5, 1.0, 1.0, 1.0, 1.0],\
            ['cyan_purp.bmp', 0.5, 0.833, 1.0, 1.0, 1.0, 1.0],\
            ['rainbow.bmp', 0.667, 0.0, 1.0, 1.0, 1.0, 1.0],\
            ]



    def OnBitmapButton1Button(self, event):
        self.the_parent_frame.tmp_selected_lookup_table = self.return_colour_list[0]
        self.Destroy()

    def OnBitmapButton2Button(self, event):
        self.the_parent_frame.tmp_selected_lookup_table = self.return_colour_list[1]
        self.Destroy()
        
    def OnBitmapButton3Button(self, event):
        self.the_parent_frame.tmp_selected_lookup_table = self.return_colour_list[2]
        self.Destroy()

    def OnBitmapButton4Button(self, event):
        self.the_parent_frame.tmp_selected_lookup_table = self.return_colour_list[3]
        self.Destroy()

    def OnBitmapButton5Button(self, event):
        self.the_parent_frame.tmp_selected_lookup_table = self.return_colour_list[4]
        self.Destroy()
        
    def OnBitmapButton6Button(self, event):
        self.the_parent_frame.tmp_selected_lookup_table = self.return_colour_list[5]
        self.Destroy()

    def OnBitmapButton7Button(self, event):
        self.the_parent_frame.tmp_selected_lookup_table = self.return_colour_list[6]
        self.Destroy()

    def OnBitmapButton8Button(self, event):
        self.the_parent_frame.tmp_selected_lookup_table = self.return_colour_list[7]
        self.Destroy()

    def OnBitmapButton9Button(self, event):
        self.the_parent_frame.tmp_selected_lookup_table = self.return_colour_list[8]
        self.Destroy()

    def OnBitmapButton10Button(self, event):
        self.the_parent_frame.tmp_selected_lookup_table = self.return_colour_list[9]
        self.Destroy()
  


class ColourLookupTableFrame(wx.Frame):
    def __init__(self, prnt, main_app_frame):
        
        wx.Frame.__init__(self, id=-1, name='', parent=prnt,
              pos=wx.Point(616, 208), size=wx.Size(205, 490),
              style=wx.DEFAULT_FRAME_STYLE, title='Select a lookup table ...')
        self.SetClientSize(wx.Size(197, 463))

        main_app_frame = main_app_frame

        t = ColourLookupPicker(self, 'Pick a colour table', -1, main_app_frame)
        t.ShowModal()
        self.Destroy()
        
