import vtk
from dv3dObjectsToRender import *
from dv3dPropertyFrames import *

def GeneratePositionMarker(frame_parent):

    pick = frame_parent.widget.GetPicker()
    r = frame_parent.widget.GetEventPosition()
    s = r[0],r[1],0
    pick.Pick(s, frame_parent.ren)
    ppos = pick.GetPickPosition()
    
    s1 = vtk.vtkSphereSource()
    s1.SetCenter(ppos)
    s1.SetRadius(5.0)
    
    map = vtk.vtkPolyDataMapper()
    map.SetInput(s1.GetOutput())
    
    act = vtk.vtkActor()
    act.SetMapper(map)

    AddVTKObjectWithAttributes(act,\
                            frame_parent,\
                            'vtkPolyDataSurfaceFromOFF',\
                            'surface',\
                            None,\
                            None,\
                            0,\
                            1,\
                            1,\
                            'functional',\
                            None,\
                            'None',\
                            1,\
                            'MarkerProperties',\
                            None)

    ###TODO URGENT FIX
    ###frame_parent.ortho_window.ortho_ren1.AddActor(frame_parent.ListOfObjects[-1])
    ###frame_parent.ortho_window.ortho_ren2.AddActor(frame_parent.ListOfObjects[-1])
    ###frame_parent.ortho_window.ortho_ren3.AddActor(frame_parent.ListOfObjects[-1])
    frame_parent.ren.AddActor(frame_parent.ListOfObjects[-1])
    
    #frame_parent.ortho_ren1.AddActor(frame_parent.ListOfObjects[-1])
    #frame_parent.ortho_ren2.AddActor(frame_parent.ListOfObjects[-1])
    #frame_parent.ortho_ren3.AddActor(frame_parent.ListOfObjects[-1])
    
    
    new_surface = frame_parent.tree.AppendItem(frame_parent.tree_structural, frame_parent.ListOfObjects[-1].my_label)
    #add the newly created treeitem as an atribute of the plane_group
    frame_parent.ListOfObjects[-1].my_treeitem = new_surface


    frame_parent.tree.Refresh()
    
    # .. create a properties window for the plane set ...
    # we pass the parent frame and the newly created object as args
    frame = MyPropertyFrame(frame_parent, frame_parent.ListOfObjects[-1], 0)
    frame.Show(True)
    
    # ... and apply it to the relevant list object
    frame_parent.ListOfObjects[-1].my_property_frame_instance = frame
    
    align_all_planes(frame_parent)
