import wx

class VariableSlider(wx.Slider):
        """Sub-class of wx.Slider allowing extra functions"""
        def __init__(self, parent, id, value,  maxValue,  pos, size, style, minValue, name):
                #wx.Slider.__init__(self, parent, id=-1, value=0, minValue=0, maxValue=100,  pos=wx.Point(0,
              #0), size=wx.Size(100, 16), style=wx.SL_HORIZONTAL)
                
                wx.Slider.__init__(self, parent, id, value, minValue, maxValue,  pos, size, style)
                
                self.Bind(wx.EVT_SLIDER, self.OnSlider)
                self.Bind(wx.EVT_LEFT_DOWN, self.OnSliderLeftMouseDown)
                self.Bind(wx.EVT_COMMAND_SCROLL_THUMBRELEASE, self.OnSliderLeftMouseUp)        
              
                self.left_down = 0
                self.timer_duration = 100
        
        def OnTimer(self, evt):

            event = VariableSliderReturnsTimerEvent(NewVariableSliderEvent, self.GetId())
            self.GetEventHandler().ProcessEvent(event)
            #self.frame_parent.ren.GetActiveCamera().Azimuth(rot_val)
            #self.frame_parent.widget.Render()
    
        def OnSliderLeftMouseDown(self, evt):
            self.left_down = 1
            evt.Skip()
            self.Bind(wx.EVT_TIMER, self.OnTimer)
            self.timer = wx.Timer(self)
            self.timer.Start(self.timer_duration)
    
    
        def OnSliderLeftMouseUp(self, evt):
            self.left_down = 0
            self.SetValue(0)
            evt.Skip()
            self.timer.Stop()
    
        def OnSlider(self, evt):
            evt.Skip()

                

class VariableSliderReturnsTimerEvent(wx.PyCommandEvent):
    def __init__(self, evtType, id):
        wx.PyCommandEvent.__init__(self, evtType, id)
        
        #something will happen - the system will be able to track that a 
        #  VariableSliderReturnsTimerEvent has occurred


NewVariableSliderEvent = wx.NewEventType()
EVT_V_SLIDER = wx.PyEventBinder(NewVariableSliderEvent, 1)


                


