#HISTORY - temporarily disabled styles and image_list 05/10/08

import wx
from common_functions import *
from dv3dPropertyFrames import *


class CreateObjectTree(wx.Panel):
    def __init__(self, parent, frame_parent):

        self.frame_parent = frame_parent
        
        self.frame_parent.notebook_Trees = wx.Notebook(id=-1, name='notebook_Trees',
              parent=self.frame_parent.panel_left_lower, pos=wx.Point(0, 0), size=wx.Size(50, 500), style=0)

        self.frame_parent.treepanel = wx.Panel(id=-1, name='panelRun',
              parent=self.frame_parent.notebook_Trees, pos=wx.Point(0, 0), size=wx.Size(1, 479),
              style=wx.TAB_TRAVERSAL)
        self.frame_parent.treepanel.SetBackgroundColour(wx.Colour(255, 255, 0))
        self.frame_parent.notebook_Trees.AddPage(self.frame_parent.treepanel, "", True)

        self.frame_parent.sizer_panel_ll = wx.GridSizer(rows = 1, cols = 1)
        self.frame_parent.sizer_panel_ll.Add(self.frame_parent.notebook_Trees, 0, wx.EXPAND)

        self.frame_parent.panel_left_lower.SetSizer(self.frame_parent.sizer_panel_ll)


        try:
            self.frame_parent.tree = wx.TreeCtrl(self.frame_parent.treepanel,
                                size=wx.Size(150,750), style = -1)# wx.NO_BORDER|\
                                                                #wx.TR_EDIT_LABELS|\
                                                                #wx.TR_HAS_BUTTONS)
        except:
            self.frame_parent.tree = wx.TreeCtrl(self.frame_parent.treepanel,
                                size=wx.Size(150,750), style = wx.NO_BORDER|\
                                                                wx.TR_EDIT_LABELS|\
                                                                wx.TR_HAS_BUTTONS)        

        #isz = (20,20)
        #il = wx.ImageList(isz[0],isz[1])
        #self.frame_parent.im1 = il.Add(wx.Image('./icons/icon_3dstat.png',wx.BITMAP_TYPE_PNG).ConvertToBitmap())
        #self.frame_parent.im2 = il.Add(wx.Image('./icons/icon_3dstatB.png',wx.BITMAP_TYPE_PNG).ConvertToBitmap())
        #self.frame_parent.im3 = il.Add(wx.Image('./icons/icon_axial_pl.png',wx.BITMAP_TYPE_PNG).ConvertToBitmap())
        #self.frame_parent.im4 = il.Add(wx.Image('./icons/icon_axial_plB.png',wx.BITMAP_TYPE_PNG).ConvertToBitmap())
        #self.frame_parent.im5 = il.Add(wx.Image('./icons/icon_coronal_pl.png',wx.BITMAP_TYPE_PNG).ConvertToBitmap())
        #self.frame_parent.im6 = il.Add(wx.Image('./icons/icon_coronal_plB.png',wx.BITMAP_TYPE_PNG).ConvertToBitmap())
        #self.frame_parent.im7 = il.Add(wx.Image('./icons/icon_sagittal_pl.png',wx.BITMAP_TYPE_PNG).ConvertToBitmap())
        #self.frame_parent.im8 = il.Add(wx.Image('./icons/icon_sagittal_plB.png',wx.BITMAP_TYPE_PNG).ConvertToBitmap())
        #self.frame_parent.im9 = il.Add(wx.Image('./icons/icon_marker.png',wx.BITMAP_TYPE_PNG).ConvertToBitmap())
        #self.frame_parent.im10 = il.Add(wx.Image('./icons/icon_markerB.png',wx.BITMAP_TYPE_PNG).ConvertToBitmap())
        #self.frame_parent.im11 = il.Add(wx.Image('./icons/icon_surface_map.png',wx.BITMAP_TYPE_PNG).ConvertToBitmap())
        #self.frame_parent.im12 = il.Add(wx.Image('./icons/icon_surface_mapB.png',wx.BITMAP_TYPE_PNG).ConvertToBitmap())
        #self.frame_parent.tree.SetImageList(il)
        #self.frame_parent.il = il

        self.frame_parent.tree_root = self.frame_parent.tree.AddRoot('Loaded objects')
        
        
        def CreateInitialTree():
            
            self.frame_parent.tree_structural = self.frame_parent.tree.AppendItem(self.frame_parent.tree_root, 'Structural objects')
            self.frame_parent.tree_overlays = self.frame_parent.tree.AppendItem(self.frame_parent.tree_root, 'Overlay objects')
            self.frame_parent.tools = self.frame_parent.tree.AppendItem(self.frame_parent.tree_root, 'Tools')
            
            for i in range(len(self.frame_parent.ListOfObjects)):
                curr_type = self.frame_parent.ListOfObjects[i].my_type        
                curr_label = self.frame_parent.ListOfObjects[i].my_label
                curr_struct_or_func = self.frame_parent.ListOfObjects[i].my_struct_or_func
                
                if curr_struct_or_func == 'structural':
                    if curr_type == 'base_imageplanegroup':
                        new_tree_item = self.frame_parent.tree.AppendItem(self.frame_parent.tree_structural, curr_label)
                        self.frame_parent.ListOfObjects[i].my_treeitem = new_tree_item
                        for j in range(len(self.frame_parent.ListOfObjects)):
                            if self.frame_parent.ListOfObjects[j].my_parents_label == curr_label:
                                curr_sub_label = self.frame_parent.ListOfObjects[j].my_label
                                new_sub_item = self.frame_parent.tree.AppendItem(new_tree_item, curr_sub_label)
                                self.frame_parent.ListOfObjects[j].my_treeitem = new_sub_item
                            
                
            self.frame_parent.tree.Expand(self.frame_parent.tree_root)

 

        self.frame_parent.un_editable_labels = ['Sagittal plane',\
                              'Axial plane',\
                              'Coronal plane',\
                              'Loaded objects',\
                              'Structural objects',\
                              'Overlay objects',\
                              'Tools',\
                              'Planes'\
                              ]

        def OnDoubleClick(evt):
            #when an item is double clicked ('activated') default behaviour is
            # for it to expand / collapse. We want to capture the 'activated'
            # event but need to reverse the default behaviour - hence we toggle
            # the state (reversing what was done) and then do waht we want - a
            # bit of a hack but gets around the fact that evt.Veto doesn't seem
            # to work here?
            #item = evt.GetItem()
            pt = evt.GetPosition()
            item, flags = self.frame_parent.tree.HitTest(pt)
            
            captured_string = self.frame_parent.tree.GetItemText(item)
            
            #now do what we want ...
            if captured_string == 'Sagittal plane' \
                                or captured_string == 'Coronal plane' \
                                or captured_string == 'Axial plane':
                #scan all objects
                state = 1
                for i in range(len(self.frame_parent.ListOfObjects)):
                    if self.frame_parent.ListOfObjects[i].my_treeitem == item:
                        #if this object is part of the 'base' planes
                        if self.frame_parent.ListOfObjects[i].my_parents_label == 'Planes':
                            
                            #define the current state to apply to all associated planes
                            if state == 1:
                                set_visible_or_not = self.frame_parent.ListOfObjects[i].my_visibility
                                state = 0
                            
                            #turn all other planes associated with this plane orientation on/off
                            for j in range(len(self.frame_parent.ListOfObjects)):
                                #check if label matches
                                if self.frame_parent.ListOfObjects[j].my_label == self.frame_parent.tree.GetItemText(item):
                                    #if it does check its current state and toggle it
                                    if set_visible_or_not == 1:
                                        self.frame_parent.ListOfObjects[j].my_visibility = 0
                                        self.frame_parent.tree.SetItemTextColour(item, wx.Colour(255,0,0))
                                        self.frame_parent.ListOfObjects[j].GetTexturePlaneProperty().SetOpacity(0.0)
                                        self.frame_parent.widget.Render()
                                        align_all_planes(self.frame_parent)
                                    else:
                                        self.frame_parent.ListOfObjects[j].my_visibility = 1
                                        self.frame_parent.tree.SetItemTextColour(item, wx.Colour(0,0,0))
                                        self.frame_parent.ListOfObjects[j].GetTexturePlaneProperty().SetOpacity(1.0)
                                        self.frame_parent.widget.Render()
                                        align_all_planes(self.frame_parent)
                        #if its not part of the base planes it belongs to an overlay
                        else:
                            pass
                                        
                                    
            elif captured_string == 'Planes':
                if 1 in [self.frame_parent.ListOfObjects[0].my_visibility, \
                         self.frame_parent.ListOfObjects[1].my_visibility, \
                        self.frame_parent.ListOfObjects[2].my_visibility]:
                    for i in range(3):
                        self.frame_parent.ListOfObjects[i].my_visibility == 0
                        for j in range(len(self.frame_parent.ListOfObjects)):
                            t = self.frame_parent.ListOfObjects[j].my_label
                            if t == 'Sagittal plane' \
                                  or t == 'Coronal plane' \
                                  or t == 'Axial plane':
                                self.frame_parent.ListOfObjects[j].GetTexturePlaneProperty().SetOpacity(0.0)
                                self.frame_parent.ListOfObjects[j].my_visibility = 0
                                self.frame_parent.tree.SetItemTextColour(item, wx.Colour(255,0,0))
                                try:
                                    sub_item = self.frame_parent.ListOfObjects[j].my_treeitem
                                    self.frame_parent.tree.SetItemTextColour(sub_item, wx.Colour(255,0,0))
                                except:
                                    pass #todo fix
                                self.frame_parent.widget.Render()
                                align_all_planes(self.frame_parent)
                else:
                    for i in range(3):
                        self.frame_parent.ListOfObjects[i].my_visibility == 1
                        for j in range(len(self.frame_parent.ListOfObjects)):
                            t = self.frame_parent.ListOfObjects[j].my_label
                            if t == 'Sagittal plane' \
                                  or t == 'Coronal plane' \
                                  or t == 'Axial plane':
                                self.frame_parent.ListOfObjects[j].GetTexturePlaneProperty().SetOpacity(1.0)
                                self.frame_parent.ListOfObjects[j].my_visibility = 1
                                self.frame_parent.tree.SetItemTextColour(item, wx.Colour(0,0,0))
                                try:
                                    sub_item = self.frame_parent.ListOfObjects[j].my_treeitem
                                    self.frame_parent.tree.SetItemTextColour(sub_item, wx.Colour(0,0,0))
                                except:
                                    pass #todo fix 
                                self.frame_parent.widget.Render()
                                align_all_planes(self.frame_parent)                
            else:
                #scan all objects 
                for i in range(len(self.frame_parent.ListOfObjects)):
                    #find the object to which the activated treeitemid belongs
                    zz = self.frame_parent.ListOfObjects[i].my_label
                    if zz != 'Sagittal plane' \
                                  and zz != 'Coronal plane' \
                                  and zz != 'Axial plane':
                        if self.frame_parent.ListOfObjects[i].my_treeitem == item:
                            #if this object is part of the 'base' planes
                            if self.frame_parent.ListOfObjects[i].my_type in ['overlay_imageplanegroup', 'ortho_overlay_imageplanegroup']:
                                if 1 in [self.frame_parent.ListOfObjects[i-1].my_visibility, \
                                    self.frame_parent.ListOfObjects[i-2].my_visibility, \
                                    self.frame_parent.ListOfObjects[i-3].my_visibility]:
                                    self.frame_parent.ListOfObjects[i-1].my_visibility = 0
                                    self.frame_parent.ListOfObjects[i-2].my_visibility = 0
                                    self.frame_parent.ListOfObjects[i-3].my_visibility = 0
                                    self.frame_parent.tree.SetItemTextColour(item, wx.Colour(255,0,0))
                                    self.frame_parent.ListOfObjects[i-1].GetTexturePlaneProperty().SetOpacity(0.0)
                                    self.frame_parent.ListOfObjects[i-2].GetTexturePlaneProperty().SetOpacity(0.0)
                                    self.frame_parent.ListOfObjects[i-3].GetTexturePlaneProperty().SetOpacity(0.0)
                                    if self.frame_parent.ListOfObjects[i].my_type == 'overlay_imageplanegroup':
                                        self.frame_parent.ListOfObjects[i].myScalarBar.Off()
                                    self.frame_parent.widget.Render()
                                    align_all_planes(self.frame_parent)
                                                                        
                                else:
                                    if self.frame_parent.ListOfObjects[2].my_visibility == 1:
                                        self.frame_parent.ListOfObjects[i-1].my_visibility = 1
                                        self.frame_parent.ListOfObjects[i-1].GetTexturePlaneProperty().SetOpacity(1.0)
                                    if self.frame_parent.ListOfObjects[1].my_visibility == 1:
                                        self.frame_parent.ListOfObjects[i-2].my_visibility = 1
                                        self.frame_parent.ListOfObjects[i-2].GetTexturePlaneProperty().SetOpacity(1.0)
                                    if self.frame_parent.ListOfObjects[0].my_visibility == 1:
                                        self.frame_parent.ListOfObjects[i-3].my_visibility = 1
                                        self.frame_parent.ListOfObjects[i-3].GetTexturePlaneProperty().SetOpacity(1.0)
                                    if self.frame_parent.ListOfObjects[i].my_type == 'overlay_imageplanegroup':
                                        self.frame_parent.ListOfObjects[i].myScalarBar.On()
                                    self.frame_parent.tree.SetItemTextColour(item, wx.Colour(0,0,0))
                                    self.frame_parent.widget.Render()
                                    align_all_planes(self.frame_parent)
                                            
                            elif self.frame_parent.ListOfObjects[i].my_type == '4DNI_Dipole':
                                self.frame_parent.ListOfObjects[i].InitTraversal()
                                line = self.frame_parent.ListOfObjects[i].GetNextActor()
                                sphere = self.frame_parent.ListOfObjects[i].GetNextActor()
                                if self.frame_parent.ListOfObjects[i].my_visibility == 1:
                                    sphere.SetVisibility(0)
                                    line.SetVisibility(0)
                                    self.frame_parent.tree.SetItemTextColour(item, wx.Colour(255,0,0))
                                    self.frame_parent.ListOfObjects[i].my_visibility = 0
                                    self.frame_parent.widget.Render()
                                    align_all_planes(self.frame_parent)
                                else:
                                    sphere.SetVisibility(1)
                                    line.SetVisibility(1)
                                    self.frame_parent.widget.Render()
                                    align_all_planes(self.frame_parent)
                                    self.frame_parent.tree.SetItemTextColour(item, wx.Colour(0,0,0))
                                    self.frame_parent.ListOfObjects[i].my_visibility = 1
                                self.frame_parent.ListOfObjects[i].InitTraversal()
                            elif self.frame_parent.ListOfObjects[i].my_type == 'vtkPolyDataProbeOutputSurface':
                                if self.frame_parent.ListOfObjects[i].my_visibility == 1:
                                    self.frame_parent.ListOfObjects[i].SetVisibility(0)
                                    self.frame_parent.tree.SetItemTextColour(item, wx.Colour(255,0,0))
                                    self.frame_parent.ListOfObjects[i].my_color_bar.SetVisibility(0)
                                    self.frame_parent.ListOfObjects[i].my_visibility = 0
                                    self.frame_parent.widget.Render()
                                    align_all_planes(self.frame_parent)
                                else:
                                    self.frame_parent.ListOfObjects[i].SetVisibility(1)
                                    self.frame_parent.tree.SetItemTextColour(item, wx.Colour(0,0,0))
                                    self.frame_parent.ListOfObjects[i].my_color_bar.SetVisibility(1)
                                    self.frame_parent.ListOfObjects[i].my_visibility = 1
                                    self.frame_parent.widget.Render()
                                    align_all_planes(self.frame_parent)
                            else:
                                if self.frame_parent.ListOfObjects[i].my_visibility == 1:
                                    self.frame_parent.tree.SetItemTextColour(item, wx.Colour(255,0,0))
                                    self.frame_parent.ListOfObjects[i].SetVisibility(0)
                                    self.frame_parent.ListOfObjects[i].my_visibility = 0
                                    self.frame_parent.widget.Render()
                                    align_all_planes(self.frame_parent)
                                else:
                                    self.frame_parent.tree.SetItemTextColour(item, wx.Colour(0,0,0))
                                    self.frame_parent.ListOfObjects[i].SetVisibility(1)
                                    self.frame_parent.ListOfObjects[i].my_visibility = 1
                                    self.frame_parent.widget.Render()
                                    align_all_planes(self.frame_parent)

                                                    
        def OnRightClick(evt):
            pt = evt.GetPosition()

            item, flags = self.frame_parent.tree.HitTest(pt)
            captured_string = self.frame_parent.tree.GetItemText(item)
            
            for i in range(len(self.frame_parent.ListOfObjects)):
                if self.frame_parent.ListOfObjects[i].my_treeitem is not None:
                    if self.frame_parent.ListOfObjects[i].my_treeitem == item:
                        if self.frame_parent.ListOfObjects[i].my_has_property_frame == 1:
                            self.frame_parent.tree.PopupMenu(PUMenu(self.frame_parent, self.frame_parent.ListOfObjects[i]))
        
        
        #we dont want users renaming some of the core objects .. so we lock them down
        def OnLabelEdit(evt):
            item = evt.GetItem()
            captured_string = self.frame_parent.tree.GetItemText(item)
            if self.frame_parent.tree.GetItemText(item) in self.frame_parent.un_editable_labels:
                print 'cant edit this object label'
                try:
                    self.frame_parent.tree.EndEditLabel(item)
                except:
                    pass #todo fix!
            for i in range(len(self.frame_parent.ListOfObjects)):
                if self.frame_parent.ListOfObjects[i].my_treeitem is not None:
                    if self.frame_parent.ListOfObjects[i].my_treeitem == item:
                        if self.frame_parent.ListOfObjects[i].my_has_property_frame == 1:
                            self.frame_parent.ListOfObjects[i].my_property_frame_instance.SetTitle(captured_string)
        
        
        def GetItem(item):
            if item:
                return self.frame_parent.tree.GetItemText(item), item
            else:
                return ""
        
        
        #now build the tree
        CreateInitialTree()
        self.frame_parent.tree.Bind(wx.EVT_LEFT_DCLICK, OnDoubleClick, self.frame_parent.tree)
        self.frame_parent.tree.Bind(wx.EVT_TREE_BEGIN_LABEL_EDIT, OnLabelEdit, self.frame_parent.tree)
        self.frame_parent.tree.Bind(wx.EVT_RIGHT_DOWN, OnRightClick, self.frame_parent.tree)
        self.frame_parent.tree.Expand(self.frame_parent.tree_root)


class EditObjectTree(wx.TreeCtrl):
    def __init__(self, frame_parent):
        
        self.frame_parent= frame_parent
        self.frame_parent.tree.Toggle(self.frame_parent.tree_root)
