import wx
import os
import vtk
from CLT_selection_Frame import *
from dv3dUpdateTimeSeries import *
from dv3dSurfaceFunctions import *
from common_functions import align_all_planes
from dv3dSurfaceIntersectsVolumeData import UseCurrentSurfaceAsDataProbe


class PUMenu(wx.Menu):
    def __init__(self, parent, thevtkobject):
        wx.Menu.__init__(self)
        
        self.parent = parent
        self.thevtkobject = thevtkobject
        
        min = wx.MenuItem(self, wx.NewId(),'Show properties window')
        self.AppendItem(min)
        self.Bind(wx.EVT_MENU, self.OnShow, id=min.GetId())
        
    def OnShow(self, evt):
        self.thevtkobject.my_property_frame_instance.Show(True)



class PropertyPanel_4DNI_Dipole(wx.Panel):
    def __init__(self, parent, frame_parent, thevtkobject):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        self.thevtkobject = thevtkobject
        
        self.dipole_rows = thevtkobject.dipole_rows
        self.dipole_mat = thevtkobject.dipole_mat
        self.ar = thevtkobject.ar
        self.line = thevtkobject.line
        self.Sphere = thevtkobject.Sphere
        
        self.parent = parent
        
        self.parent.SetSize(wx.Size(410,310))
        
        #first extract both the actors from the vtkActorCollection
        self.data_source_path = thevtkobject.InitTraversal()
        self.line_actor = thevtkobject.GetNextActor()
        self.sphere_actor = thevtkobject.GetNextActor()

        
        #get the time points
        self.dipole_max_time = thevtkobject.dipole_max_time
        self.dipole_min_time = thevtkobject.dipole_min_time
        self.curr_pos = thevtkobject.curr_pos
        
        self.my_data_path = thevtkobject.my_data_path
        self.index_into_objects = len(self.frame_parent.ListOfObjects)-1
        
        
        self.staticBox1 = wx.StaticBox(id=-1,
              label='Colours', name='staticBox1', parent=self,
              pos=wx.Point(24, 112), size=wx.Size(360, 56), style=0)

        self.staticBox2 = wx.StaticBox(id=-1,
              label='Time-series', name='staticBox2', parent=self,
              pos=wx.Point(24, 16), size=wx.Size(360, 88), style=0)

        self.staticBox3 = wx.StaticBox(id=-1,
              label='Data source', name='staticBox3', parent=self,
              pos=wx.Point(24, 176), size=wx.Size(360, 48), style=0)

        self.textCtrl1 = wx.TextCtrl(id=-1, name='textCtrl1',
              parent=self, pos=wx.Point(32, 192), size=wx.Size(336, 21),
              style=0, value='%s' %self.my_data_path)
        self.textCtrl1.SetEditable(False)

        self.staticText1 = wx.StaticText(id=-1,
              label='Last time-point', name='staticText1', parent=self,
              pos=wx.Point(208, 40), size=wx.Size(71, 13), style=0)

        self.staticText2 = wx.StaticText(id=-1,
              label='%s' %str(self.dipole_max_time), name='staticText2', parent=self,
              pos=wx.Point(288, 40), size=wx.Size(40, 13), style=0)#TODO - hack -hardcoded for HBM

        self.staticText3 = wx.StaticText(id=-1,
              label='First time-point', name='staticText3', parent=self,
              pos=wx.Point(40, 40), size=wx.Size(72, 13), style=0)

        self.staticText4 = wx.StaticText(id=-1,
              label='Transparency', name='staticText4', parent=self,
              pos=wx.Point(40, 136), size=wx.Size(66, 13), style=0)

        self.slider1 = wx.Slider(id=-1, maxValue=100,
              minValue=0, name='slider1', parent=self, pos=wx.Point(120,
              136), size=wx.Size(168, 24), style=wx.SL_HORIZONTAL, value=0)
        self.slider1.Bind(wx.EVT_SLIDER, self.Onslider1,
              id=-1)

        self.staticText5 = wx.StaticText(id=-1,
              label='%s' %str(self.dipole_min_time), name='staticText5', parent=self,
              pos=wx.Point(120, 40), size=wx.Size(40, 13), style=0)#TODO - hack -hardcoded for HBM

        self.textCtrl2 = wx.TextCtrl(id=-1, name='textCtrl2',
              parent=self, pos=wx.Point(304, 72), size=wx.Size(72, 21),
              style=0, value=str(self.dipole_min_time))
        self.textCtrl2.Bind(wx.EVT_TEXT, self.OnTextCtrl2TextEnter,
              id=-1)


        self.slider2 = wx.Slider(id=-1, maxValue=self.dipole_max_time,
              minValue=self.dipole_min_time, name='slider2', parent=self, pos=wx.Point(136,
              72), size=wx.Size(168, 24), style=wx.SL_HORIZONTAL, value=0)#TODO - hack -hardcoded for HBM
        self.slider2.Bind(wx.EVT_SLIDER, self.Onslider2,
              id=-1)

        self.textCtrl3 = wx.TextCtrl(id=-1, name='textCtrl3',
              parent=self, pos=wx.Point(304, 136), size=wx.Size(72, 21),
              style=0, value='100')
        self.textCtrl3.Bind(wx.EVT_TEXT, self.OnTextCtrl3TextEnter,
              id=-1)

        self.staticText6 = wx.StaticText(id=-1,
              label='Current time-point', name='staticText6',
              parent=self, pos=wx.Point(40, 72), size=wx.Size(88, 13),
              style=0)
    
    def Onslider2(self, event):
        new_position = self.slider2.GetValue()
        Update_4DNI_dipole(self.frame_parent, self, int(new_position), self.ar,
                           self.line, self.Sphere)
        self.textCtrl2.SetValue(str(new_position))
        
        
    def Onslider1(self, event):
        opacity = self.slider1.GetValue()/100.0
        self.line_actor.GetProperty().SetOpacity(1-opacity)
        self.sphere_actor.GetProperty().SetOpacity(1-opacity)
        self.textCtrl3.SetValue('%d' %int((opacity)*100))
        self.frame_parent.widget.Render()
        event.Skip()
        
    def OnTextCtrl2TextEnter(self, event):
        new_position = int(self.textCtrl2.GetValue())
        UpdateMinNormType1(self.frame_parent, self, int(new_position))
        self.slider2.SetValue(new_position)
        
    def OnTextCtrl3TextEnter(self, event):
        new_val = int(self.textCtrl3.GetValue())
        if new_val > 100:
            self.textCtrl3.SetValue('100')
            new_val = 100
        elif new_val < 0:
            self.textCtrl3.SetValue('0')
            new_val = 0
        self.slider1.SetValue(new_val)
        self.line_actor.GetProperty().SetOpacity((100-new_val)/100.0)
        self.sphere_actor.GetProperty().SetOpacity((100-new_val)/100.0)        
        self.frame_parent.widget.Render()




class PropertyPanel_MinNormType1(wx.Panel):
    def __init__(self, parent, frame_parent, thevtkobject):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        self.thevtkobject = thevtkobject
        self.parent = parent
        
        self.parent.SetSize(wx.Size(410,310))
        
        self.data_source_path = thevtkobject.my_data_path
        self.index_into_objects = len(self.frame_parent.ListOfObjects)-1
        
        
        self.staticBox1 = wx.StaticBox(id=-1,
              label='Colours', name='staticBox1', parent=self,
              pos=wx.Point(24, 112), size=wx.Size(360, 56), style=0)

        self.staticBox2 = wx.StaticBox(id=-1,
              label='Time-series', name='staticBox2', parent=self,
              pos=wx.Point(24, 16), size=wx.Size(360, 88), style=0)

        self.staticBox3 = wx.StaticBox(id=-1,
              label='Data source', name='staticBox3', parent=self,
              pos=wx.Point(24, 176), size=wx.Size(360, 48), style=0)

        self.textCtrl1 = wx.TextCtrl(id=-1, name='textCtrl1',
              parent=self, pos=wx.Point(32, 192), size=wx.Size(336, 21),
              style=0, value=self.data_source_path)
        self.textCtrl1.SetEditable(False)

        self.staticText1 = wx.StaticText(id=-1,
              label='Last time-point', name='staticText1', parent=self,
              pos=wx.Point(208, 40), size=wx.Size(71, 13), style=0)

        self.staticText2 = wx.StaticText(id=-1,
              label='347', name='staticText2', parent=self,
              pos=wx.Point(288, 40), size=wx.Size(40, 13), style=0)#TODO - hack -hardcoded for HBM

        self.staticText3 = wx.StaticText(id=-1,
              label='First time-point', name='staticText3', parent=self,
              pos=wx.Point(40, 40), size=wx.Size(72, 13), style=0)

        self.staticText4 = wx.StaticText(id=-1,
              label='Transparency', name='staticText4', parent=self,
              pos=wx.Point(40, 136), size=wx.Size(66, 13), style=0)

        self.slider1 = wx.Slider(id=-1, maxValue=100,
              minValue=0, name='slider1', parent=self, pos=wx.Point(120,
              136), size=wx.Size(168, 24), style=wx.SL_HORIZONTAL, value=0)
        self.slider1.Bind(wx.EVT_SLIDER, self.Onslider1,
              id=-1)

        self.staticText5 = wx.StaticText(id=-1,
              label='1', name='staticText5', parent=self,
              pos=wx.Point(120, 40), size=wx.Size(40, 13), style=0)#TODO - hack -hardcoded for HBM

        self.textCtrl2 = wx.TextCtrl(id=-1, name='textCtrl2',
              parent=self, pos=wx.Point(304, 72), size=wx.Size(72, 21),
              style=0, value='0')
        self.textCtrl2.Bind(wx.EVT_TEXT, self.OnTextCtrl2TextEnter,
              id=-1)


        self.slider2 = wx.Slider(id=-1, maxValue=347,
              minValue=1, name='slider2', parent=self, pos=wx.Point(136,
              72), size=wx.Size(168, 24), style=wx.SL_HORIZONTAL, value=0)#TODO - hack -hardcoded for HBM
        self.slider2.Bind(wx.EVT_SLIDER, self.Onslider2,
              id=-1)

        self.textCtrl3 = wx.TextCtrl(id=-1, name='textCtrl3',
              parent=self, pos=wx.Point(304, 136), size=wx.Size(72, 21),
              style=0, value='100')
        self.textCtrl3.Bind(wx.EVT_TEXT, self.OnTextCtrl3TextEnter,
              id=-1)

        self.staticText6 = wx.StaticText(id=-1,
              label='Current time-point', name='staticText6',
              parent=self, pos=wx.Point(40, 72), size=wx.Size(88, 13),
              style=0)
    
    def Onslider2(self, event):
        new_position = self.slider2.GetValue()
        UpdateMinNormType1(self.frame_parent, self, int(new_position))
        self.textCtrl2.SetValue(str(new_position))
        
        
    def Onslider1(self, event):
        opacity = self.slider1.GetValue()/100.0
        self.thevtkobject.GetProperty().SetOpacity(1-opacity)
        self.textCtrl3.SetValue('%d' %int((opacity)*100))
        self.frame_parent.widget.Render()
        event.Skip()
        
    def OnTextCtrl2TextEnter(self, event):
        new_position = int(self.textCtrl2.GetValue())
        UpdateMinNormType1(self.frame_parent, self, int(new_position))
        self.slider2.SetValue(new_position)
        
    def OnTextCtrl3TextEnter(self, event):
        new_val = int(self.textCtrl3.GetValue())
        if new_val > 100:
            self.textCtrl3.SetValue('100')
            new_val = 100
        elif new_val < 0:
            self.textCtrl3.SetValue('0')
            new_val = 0
        self.slider1.SetValue(new_val)
        self.thevtkobject.GetProperty().SetOpacity((100-new_val)/100.0)
        self.frame_parent.widget.Render()




class PropertyPanel_3DContourPlot(wx.Panel):
    def __init__(self, parent, frame_parent, thevtkobject):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        self.thevtkobject = thevtkobject
        self.parent = parent
        
        self.parent.SetSize(wx.Size(410,310))
        
        self.data_source_path = thevtkobject.my_data_path
        self.index_into_objects = len(self.frame_parent.ListOfObjects)-1
        pretrig = self.frame_parent.ListOfObjects[self.index_into_objects].pretrig
        duration = self.frame_parent.ListOfObjects[self.index_into_objects].duration
        
        self.staticBox1 = wx.StaticBox(id=-1,
              label='Colours', name='staticBox1', parent=self,
              pos=wx.Point(24, 112), size=wx.Size(360, 56), style=0)

        self.staticBox2 = wx.StaticBox(id=-1,
              label='Time-series', name='staticBox2', parent=self,
              pos=wx.Point(24, 16), size=wx.Size(360, 88), style=0)

        self.staticBox3 = wx.StaticBox(id=-1,
              label='Data source', name='staticBox3', parent=self,
              pos=wx.Point(24, 176), size=wx.Size(360, 48), style=0)

        self.textCtrl1 = wx.TextCtrl(id=-1, name='textCtrl1',
              parent=self, pos=wx.Point(32, 192), size=wx.Size(336, 21),
              style=0, value=self.data_source_path)
        self.textCtrl1.SetEditable(False)

        self.staticText1 = wx.StaticText(id=-1,
              label='Last time-point', name='staticText1', parent=self,
              pos=wx.Point(208, 40), size=wx.Size(71, 13), style=0)

        self.staticText2 = wx.StaticText(id=-1,
              label='+%d' %(duration-pretrig), name='staticText2', parent=self,
              pos=wx.Point(288, 40), size=wx.Size(40, 13), style=0)#TODO - hack -hardcoded for HBM

        self.staticText3 = wx.StaticText(id=-1,
              label='First time-point', name='staticText3', parent=self,
              pos=wx.Point(40, 40), size=wx.Size(72, 13), style=0)

        self.staticText4 = wx.StaticText(id=-1,
              label='Transparency', name='staticText4', parent=self,
              pos=wx.Point(40, 136), size=wx.Size(66, 13), style=0)

        self.slider1 = wx.Slider(id=-1, maxValue=100,
              minValue=0, name='slider1', parent=self, pos=wx.Point(120,
              136), size=wx.Size(168, 24), style=wx.SL_HORIZONTAL, value=0)
        self.slider1.Bind(wx.EVT_SLIDER, self.Onslider1,
              id=-1)

        self.staticText5 = wx.StaticText(id=-1,
              label='%d' %(0-pretrig), name='staticText5', parent=self,
              pos=wx.Point(120, 40), size=wx.Size(40, 13), style=0)#TODO - hack -hardcoded for HBM

        self.textCtrl2 = wx.TextCtrl(id=-1, name='textCtrl2',
              parent=self, pos=wx.Point(304, 72), size=wx.Size(72, 21),
              style=0, value='0')
        self.textCtrl2.Bind(wx.EVT_TEXT, self.OnTextCtrl2TextEnter,
              id=-1)


        self.slider2 = wx.Slider(id=-1, maxValue=(duration-pretrig),
              minValue=(0-pretrig), name='slider2', parent=self, pos=wx.Point(136,
              72), size=wx.Size(168, 24), style=wx.SL_HORIZONTAL, value=0)
        self.slider2.Bind(wx.EVT_SLIDER, self.Onslider2,
              id=-1)

        self.textCtrl3 = wx.TextCtrl(id=-1, name='textCtrl3',
              parent=self, pos=wx.Point(304, 136), size=wx.Size(72, 21),
              style=0, value='100')
        self.textCtrl3.Bind(wx.EVT_TEXT, self.OnTextCtrl3TextEnter,
              id=-1)

        self.staticText6 = wx.StaticText(id=-1,
              label='Current time-point', name='staticText6',
              parent=self, pos=wx.Point(40, 72), size=wx.Size(88, 13),
              style=0)
    
    def Onslider2(self, event):
        new_position = self.slider2.GetValue()
        UpdateContourPlot3D(self.frame_parent, self, int(new_position))
        self.textCtrl2.SetValue(str(new_position))
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)
        
        
    def Onslider1(self, event):
        opacity = self.slider1.GetValue()/100.0
        self.thevtkobject.GetProperty().SetOpacity(1-opacity)
        self.textCtrl3.SetValue('%d' %int((opacity)*100))
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)
        event.Skip()
        
    def OnTextCtrl2TextEnter(self, event):
        new_position = int(self.textCtrl2.GetValue())
        UpdateContourPlot3D(self.frame_parent, self, int(new_position))
        self.slider2.SetValue(new_position)
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)
        
    def OnTextCtrl3TextEnter(self, event):
        new_val = int(self.textCtrl3.GetValue())
        if new_val > 100:
            self.textCtrl3.SetValue('100')
            new_val = 100
        elif new_val < 0:
            self.textCtrl3.SetValue('0')
            new_val = 0
        self.slider1.SetValue(new_val)
        self.thevtkobject.GetProperty().SetOpacity((100-new_val)/100.0)
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)
        
        
        
        

class PropertyPanel_SurfaceFromFile(wx.Panel): #TODO - finsih this panel
    def __init__(self, parent, frame_parent, thevtkobject):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        self.thevtkobject = thevtkobject
        
        self.data_source_path = thevtkobject.my_data_path

        self.window_CT = wx.StaticBox(id=-1,
              label='Colour / Transparency', name='window_CT', parent=self,
              pos=wx.Point(12, 24), size=wx.Size(265, 90), style=0)
        
        self.ColourChooseButton = wx.Button(self, -1, 'Choose a new colour', (25,45))
        self.Bind(wx.EVT_BUTTON, self.OnColourChooseButton, self.ColourChooseButton)

        self.transp_text_label = wx.StaticText(id=-1, label='Transparency:', name='TranspT',
              parent=self, pos=wx.Point(25, 85), size=wx.Size(75, 13),
              style=0)

        #self.transp_value_label = wx.StaticText(id=-1, label='0%', name='TranspT',
        #      parent=self, pos=wx.Point(235, 85), size=wx.Size(35, 13),
        #      style=0)

        self.transp_value_label = wx.TextCtrl(id=-1, name='TranspT',
              parent=self, pos=wx.Point(235, 85), size=wx.Size(35, 20),
              style=wx.TE_RIGHT, value='0')
        self.transp_value_label.SetEditable(1)
        self.transp_value_label.Bind(wx.EVT_TEXT, self.OnManualTransp, id=-1)
        

        self.SliderTransparency = wx.Slider(id=-1, maxValue=100,
              minValue = 0, name='TransparencySlider', parent=self, pos=wx.Point(100,
              85), size=wx.Size(125, 16), style=wx.SL_HORIZONTAL, value=0)
        self.SliderTransparency.Bind(wx.EVT_SLIDER, self.OnSliderTransparency,
              id=-1)

        self.box = wx.StaticBox(id=-1,
              label='Probe underlying data', name='probe', parent=self,
              pos=wx.Point(12, 120), size=wx.Size(265, 45), style=0)

        self.ProbeButton = wx.Button(self, -1, 'GO', (200,140))
        self.Bind(wx.EVT_BUTTON, self.OnProbeButton, self.ProbeButton)

        self.text_label2 = wx.StaticText(id=-1, label='map stat data to surface', name='instr',
              parent=self, pos=wx.Point(25, 140), 
              style=0)

        self.annotations_box = wx.StaticBox(id=-1,
              label='', name='window_anno', parent=self,
              pos=wx.Point(12, 174), size=wx.Size(265, 80), style=0)
                
        self.source_text_label = wx.StaticText(id=-1, label='Source:', name='SourceT',
              parent=self, pos=wx.Point(20, 198), size=wx.Size(50, 13),
              style=0)

        self.source_text = wx.TextCtrl(id=-1, name='Source',
              parent=self, pos=wx.Point(70, 198), size=wx.Size(200, 20),
              style=wx.TE_RIGHT, value='%s' %thevtkobject.my_data_path)
        self.source_text.SetEditable(0)

    def OnProbeButton(self, evt):
        frame = MyLocalDialogFrame(self.frame_parent, 'Surface_Intersection', self.thevtkobject)
        frame.Show()
        
    
    def OnManualTransp(self, evt):
        new_val = int(self.transp_value_label.GetValue())
        if new_val > 100:
            self.transp_value_label.SetValue('100')
            new_val = 100
        elif new_val < 0:
            self.transp_value_label.SetValue('0')
            new_val = 0
        self.SliderTransparency.SetValue(new_val)
        self.thevtkobject.GetProperty().SetOpacity((100-new_val)/100.0)
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)

    def OnColourChooseButton(self, evt):
        dialog = wx.ColourDialog(self)
        if dialog.ShowModal() == wx.ID_OK:
            new_colour = dialog.GetColourData().GetColour()
            new_colour = new_colour.Get()
            self.thevtkobject.GetProperty().SetDiffuseColor(new_colour[0]/255.0, new_colour[1]/255.0, new_colour[2]/255.0)
            self.frame_parent.widget.Render()
            align_all_planes(self.frame_parent)
            
    def OnSliderTransparency(self, evt):
        opacity = self.SliderTransparency.GetValue()/100.0
        self.thevtkobject.GetProperty().SetOpacity(1-opacity)
        self.transp_value_label.SetLabel('%d' %int((opacity)*100))
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)
        evt.Skip()        


class MyLocalDialogFrame(wx.Frame):
    def __init__(self, frame_parent, type, thevtkobject):
        wx.Frame.__init__(self, None, -1, 'Input required ...',  size=(300, 300), style=wx.STAY_ON_TOP|wx.DEFAULT_FRAME_STYLE)
        #check which type of object we are creating a property panel for
        # and call the appropriate panel class
                
        #if we are dealing with the 'base' image ...
        if type == 'Surface_Intersection':
            panel = SelectOverlayToIntersect(self, frame_parent, thevtkobject)


class SelectOverlayToIntersect(wx.Panel):
    def __init__(self, parent, frame_parent, thevtkobject):
        wx.Panel.__init__(self, parent, -1)  
        
        #some constants to allow handling later
        self.parent = parent
        self.frame_parent = frame_parent
        self.index_to_data = 0
        self.thevtkobject = thevtkobject
        
        
        drop_down_content = [] #the list holder for the volume selection
        drop_down_content.append('')
        
        #scan all loaded volumes not base, tal, or ref (start at 4th element)
        
        for i in range(3,len(self.frame_parent.my_loaded_volumes)):
            #check if any objects are associated with them therefore if list items exist
            for j in range(len(self.frame_parent.ListOfObjects)):
                #as before ..
                try:
                    if self.frame_parent.ListOfObjects[j].my_loaded_volumesindex == i:
                        label = self.frame_parent.ListOfObjects[j].my_label
                        if drop_down_content[-1] == label:
                            pass
                        else:
                            drop_down_content.append(label)
                except:
                    pass

        
        if drop_down_content == ['']:
            print 'No overlay volumes suitable for intersection loaded / generated yet.'
            self.parent.Destroy()
        
        self.OverlayChoiceLabel = wx.StaticText(id=-1, label='Choose an overlay to intersect:', name='ChooseOverlay',
              parent=self, pos=wx.Point(16, 16), style=0)
        
        self.OverlayChoice = wx.Choice(choices=drop_down_content, id=-1,
              name='OverlayChoice', parent=self, pos=wx.Point(16, 42),
              size=wx.Size(250, 21), style=0)
        
        self.DoIntersect = wx.Button(self, -1, 'Export Now', (100,200))
        self.Bind(wx.EVT_BUTTON, self.OnDoIntersectButton, self.DoIntersect)


    def OnDoIntersectButton(self, event):
        choice = self.OverlayChoice.GetStringSelection()
        for j in range(len(self.frame_parent.ListOfObjects)):
            #try:
                if choice == self.frame_parent.ListOfObjects[j].my_label:
                    
                    volume_to_intersect = self.frame_parent.ListOfObjects[j].my_loaded_volumesindex
                    self.parent.Destroy()
                    UseCurrentSurfaceAsDataProbe(self.frame_parent, self.thevtkobject,
                                     self.frame_parent.my_loaded_volumes[volume_to_intersect])
                    return
            #except:
            #    print 'export failed for some reason (?) ...'
            #    pass #TODO fix





class PropertyPanel_BasePlaneWidgets(wx.Panel):
    def __init__(self, parent, frame_parent, thevtkobject):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        self.thevtkobject = thevtkobject
        
        self.curr_max = self.frame_parent.my_loaded_volumes[0][0].data_max
        self.curr_min = self.frame_parent.my_loaded_volumes[0][0].data_min
        self.data_source_path = self.frame_parent.my_loaded_volumes[0][0].data_source_path
        

        self.window_WL = wx.StaticBox(id=-1,
              label='window width/level', name='window_WL', parent=self,
              pos=wx.Point(12, 24), size=wx.Size(265, 80), style=0)


        self.W = wx.StaticText(id=-1, label='W', name='W',
              parent=self, pos=wx.Point(20, 48), size=wx.Size(10, 13),
              style=0)


        self.L = wx.StaticText(id=-1, label='L', name='L',
              parent=self, pos=wx.Point(20, 69), size=wx.Size(8, 13),
              style=0)

        self.sliderLevel= wx.Slider(id=-1, maxValue=self.curr_max,
              minValue=0, name='slider1', parent=self, pos=wx.Point(36,
              72), size=wx.Size(180, 16), style=wx.SL_HORIZONTAL, value=50)
        self.sliderLevel.Bind(wx.EVT_SLIDER, self.OnSliderLevel,
              id=-1)

        self.sliderWindow = wx.Slider(id=-1, maxValue=self.curr_max,
              minValue = 0, name='slider2', parent=self, pos=wx.Point(36,
              48), size=wx.Size(180, 16), style=wx.SL_HORIZONTAL, value=50)
        self.sliderWindow.Bind(wx.EVT_SLIDER, self.OnSliderWindow,
              id=-1)

        #  sliders for plane transparency
        

        self.transp_Ax_text_label = wx.StaticText(id=-1, label='Transparency: Axial ', name='TranspA',
              parent=self, pos=wx.Point(25, 115), 
              style=0)

        self.transp_Cor_text_label = wx.StaticText(id=-1, label='            Coronal', name='TranspC',
              parent=self, pos=wx.Point(25, 135), 
              style=0)

        self.transp_Sag_text_label = wx.StaticText(id=-1, label='          Sagittal', name='TranspS',
              parent=self, pos=wx.Point(25, 155), 
              style=0)

        self.transp_value_labelA = wx.TextCtrl(id=-1, name='TranspATx',
              parent=self, pos=wx.Point(235, 115), size=wx.Size(35, 20),
              style=wx.TE_RIGHT, value='0')
        self.transp_value_labelA.SetEditable(1)
        self.transp_value_labelA.Bind(wx.EVT_TEXT, self.OnManualTranspA, id=-1)

        self.transp_value_labelC = wx.TextCtrl(id=-1, name='TranspCTx',
              parent=self, pos=wx.Point(235, 135), size=wx.Size(35, 20),
              style=wx.TE_RIGHT, value='0')
        self.transp_value_labelC.SetEditable(1)
        self.transp_value_labelC.Bind(wx.EVT_TEXT, self.OnManualTranspC, id=-1)
        
        self.transp_value_labelS = wx.TextCtrl(id=-1, name='TranspSTx',
              parent=self, pos=wx.Point(235, 155), size=wx.Size(35, 20),
              style=wx.TE_RIGHT, value='0')
        self.transp_value_labelS.SetEditable(1)
        self.transp_value_labelS.Bind(wx.EVT_TEXT, self.OnManualTranspS, id=-1)
       

        self.SliderTransparencyA = wx.Slider(id=-1, maxValue=100,
              minValue = 0, name='TransparencySliderS', parent=self, pos=wx.Point(150,
              115), size=wx.Size(75, 16), style=wx.SL_HORIZONTAL, value=0)
        self.SliderTransparencyA.Bind(wx.EVT_SLIDER, self.OnSliderTransparencyA,
              id=-1)        

        self.SliderTransparencyC = wx.Slider(id=-1, maxValue=100,
              minValue = 0, name='TransparencySliderC', parent=self, pos=wx.Point(150,
              135), size=wx.Size(75, 16), style=wx.SL_HORIZONTAL, value=0)
        self.SliderTransparencyC.Bind(wx.EVT_SLIDER, self.OnSliderTransparencyC,
              id=-1)

        self.SliderTransparencyS = wx.Slider(id=-1, maxValue=100,
              minValue = 0, name='TransparencySliderS', parent=self, pos=wx.Point(150,
              155), size=wx.Size(75, 16), style=wx.SL_HORIZONTAL, value=0)
        self.SliderTransparencyS.Bind(wx.EVT_SLIDER, self.OnSliderTransparencyS,
              id=-1) 
        


        ###

        self.Window_Value = wx.StaticText(id=-1, label=str(float(self.sliderWindow.GetValue()/100)), name='Win',
              parent=self, pos=wx.Point(220, 48), size=wx.Size(30, 13),
              style=0)


        self.Level_Value = wx.StaticText(id=-1, label=str(float(self.sliderLevel.GetValue()/100)), name='Level',
              parent=self, pos=wx.Point(220, 69), size=wx.Size(30, 13),
              style=0)


        self.annotations_box = wx.StaticBox(id=-1,
              label='', name='window_anno', parent=self,
              pos=wx.Point(12, 174), size=wx.Size(265, 80), style=0)
        
        
        self.source_text_label = wx.StaticText(id=-1, label='Source:', name='SourceT',
              parent=self, pos=wx.Point(20, 198), size=wx.Size(50, 13),
              style=0)

        self.source_text = wx.TextCtrl(id=-1, name='Source',
              parent=self, pos=wx.Point(70, 198), size=wx.Size(200, 20),
              style=wx.TE_RIGHT, value='%s' %self.data_source_path)
        self.source_text.SetEditable(0)

        self.source_min_max_text = wx.StaticText(id=-1, label='Data max:%0.2f  Data min:%0.2f' %(self.curr_max,self.curr_min), name='MinMax',
              parent=self, pos=wx.Point(20, 229), size=wx.Size(200, 13),
              style=0)
 
    def OnManualTranspA(self, event):
        opacity = float(self.transp_value_labelA.GetValue())/100.0
        self.SliderTransparencyA.SetValue(float(self.transp_value_labelA.GetValue()))
        self.frame_parent.ListOfObjects[2].GetTexturePlaneProperty().SetOpacity(1-opacity)
        self.frame_parent.widget.Render()
        event.Skip()
        
        
    def OnManualTranspC(self, event):
        opacity = float(self.transp_value_labelC.GetValue())/100.0
        self.SliderTransparencyC.SetValue(float(self.transp_value_labelC.GetValue()))
        self.frame_parent.ListOfObjects[1].GetTexturePlaneProperty().SetOpacity(1-opacity)
        self.frame_parent.widget.Render()
        event.Skip()
        
    def OnManualTranspS(self, event):
        opacity = float(self.transp_value_labelS.GetValue())/100.0
        self.SliderTransparencyS.SetValue(float(self.transp_value_labelS.GetValue()))
        self.frame_parent.ListOfObjects[0].GetTexturePlaneProperty().SetOpacity(1-opacity)
        self.frame_parent.widget.Render()
        event.Skip()
        
    def OnSliderTransparencyA(self, event):
        opacity = self.SliderTransparencyA.GetValue()/100.0
        self.transp_value_labelA.SetValue(str(self.SliderTransparencyA.GetValue()))
        self.frame_parent.ListOfObjects[2].GetTexturePlaneProperty().SetOpacity(1-opacity)
        self.frame_parent.widget.Render()
        event.Skip()   
        
    def OnSliderTransparencyC(self, event):
        opacity = self.SliderTransparencyC.GetValue()/100.0
        self.transp_value_labelC.SetValue(str(self.SliderTransparencyC.GetValue()))
        self.frame_parent.ListOfObjects[1].GetTexturePlaneProperty().SetOpacity(1-opacity)
        self.frame_parent.widget.Render()
        event.Skip() 
        
    def OnSliderTransparencyS(self, event):
        opacity = self.SliderTransparencyS.GetValue()/100.0
        self.transp_value_labelS.SetValue(str(self.SliderTransparencyS.GetValue()))
        self.frame_parent.ListOfObjects[0].GetTexturePlaneProperty().SetOpacity(1-opacity)
        self.frame_parent.widget.Render()
        event.Skip()         
        
    def OnSliderLevel(self, event):
        for i in range(len(self.frame_parent.ListOfObjects)):
            if self.frame_parent.ListOfObjects[i].my_parents_label == self.thevtkobject.my_label:
                #self.frame_parent.ListOfObjects[i].SetWindowLevel(float(self.sliderWindow.GetValue()),float(self.sliderLevel.GetValue()), 1)
                #self.frame_parent.widget.Render()

                lut_min =  self.frame_parent.original_LU_table.GetTableRange()[0]
                lut_max =  self.frame_parent.original_LU_table.GetTableRange()[1]
                
                self.frame_parent.original_LU_table.SetTableRange(lut_min, float(self.sliderLevel.GetValue()))
                
                self.Level_Value.SetLabel(str(float(self.sliderLevel.GetValue())))
                align_all_planes(self.frame_parent)
                event.Skip()


    def OnSliderWindow(self, event):
        for i in range(len(self.frame_parent.ListOfObjects)):
            if self.frame_parent.ListOfObjects[i].my_parents_label == self.thevtkobject.my_label:
                #self.frame_parent.ListOfObjects[i].SetWindowLevel(float(self.sliderWindow.GetValue()),float(self.sliderLevel.GetValue()), 1)
                #self.frame_parent.widget.Render()
                
                lut_min =  self.frame_parent.original_LU_table.GetTableRange()[0]
                lut_max =  self.frame_parent.original_LU_table.GetTableRange()[1]
                
                self.frame_parent.original_LU_table.SetTableRange(float(self.sliderWindow.GetValue()), lut_max)
                
                self.Window_Value.SetLabel(str(float(self.sliderWindow.GetValue())))
                align_all_planes(self.frame_parent)
                event.Skip()


class PropertyPanel_OverlayPlaneWidgets(wx.Panel):
    def __init__(self, parent, frame_parent, thevtkobject):
        wx.Panel.__init__(self, parent, -1)

        #some constants to allow handling later
        self.frame_parent = frame_parent
        self.thevtkobject = thevtkobject

        #this is used to figure out which 'number' / index object we have just created
        self.a_o_max = len(self.frame_parent.ListOfObjects)-1
        #indices of associated planes
        self.associated_objects = [self.a_o_max-3,self.a_o_max-2,self.a_o_max-1,\
                                   self.a_o_max+1,self.a_o_max+2,self.a_o_max+3]
        
        count = self.frame_parent.overlay_count + 2

        self.curr_max = self.frame_parent.my_loaded_volumes[count][0].data_max
        self.curr_min = self.frame_parent.my_loaded_volumes[count][0].data_min
        self.data_source_path = self.frame_parent.my_loaded_volumes[count][0].data_source_path


        #some labels and bounding boxes for visual effect
        self.window_WL = wx.StaticBox(id=-1,
              label='Intensity threshold', name='window_WL', parent=self,
              pos=wx.Point(12, 24), size=wx.Size(265, 80), style=0)

        self.Upper_label = wx.StaticText(id=-1, label='Upper', name='W',
              parent=self, pos=wx.Point(20, 48), size=wx.Size(30, 13),
              style=0)

        self.Lower_label = wx.StaticText(id=-1, label='Lower', name='L',
              parent=self, pos=wx.Point(20, 69), size=wx.Size(30, 13),
              style=0)


        #a slider that controls the low threshold
        self.SliderMin= wx.Slider(id=-1, maxValue=self.frame_parent.my_loaded_volumes[count][0].data_max*100,
              minValue=self.frame_parent.my_loaded_volumes[count][0].data_min*100, name='slider1', parent=self, pos=wx.Point(54,
              72), size=wx.Size(140, 16), style=wx.SL_HORIZONTAL, value=0)
        self.SliderMin.Bind(wx.EVT_SLIDER, self.OnSliderMin,
              id=-1)

        #a slider that controls the high threshold
        self.SliderMax = wx.Slider(id=-1, maxValue=self.frame_parent.my_loaded_volumes[count][0].data_max*100,
              minValue = self.frame_parent.my_loaded_volumes[count][0].data_min*100, name='slider2', parent=self, pos=wx.Point(54,
              48), size=wx.Size(140, 16), style=wx.SL_HORIZONTAL, value=self.frame_parent.my_loaded_volumes[count][0].data_max*100)
        self.SliderMax.Bind(wx.EVT_SLIDER, self.OnSliderMax,
              id=-1)

        self.Upper_Value = wx.TextCtrl(id=-1, value=str(float(self.SliderMax.GetValue()/100)), name='W',
              parent=self, pos=wx.Point(200, 48), size=wx.Size(60, 20),
              style=0)
        self.Upper_Value.Bind(wx.EVT_TEXT, self.OnUpperValue, id=-1)
        

        self.Lower_Value = wx.TextCtrl(id=-1, value=str(float(self.SliderMin.GetValue()/100)), name='L',
              parent=self, pos=wx.Point(200, 69), size=wx.Size(60, 20),
              style=0)
        self.Lower_Value.Bind(wx.EVT_TEXT, self.OnLowerValue, id=-1)
        
        self.transp_Cor_text_label = wx.StaticText(id=-1, label='Transparency', name='Transp',
              parent=self, pos=wx.Point(20, 120), 
              style=0)

        self.transp_value_label = wx.TextCtrl(id=-1, name='TranspTx',
              parent=self, pos=wx.Point(200, 120), size=wx.Size(60, 20),
              style=wx.TE_RIGHT, value='0')
        self.transp_value_label.SetEditable(1)
        self.transp_value_label.Bind(wx.EVT_TEXT, self.OnManualTransp, id=-1)        

        self.SliderTransparency = wx.Slider(id=-1, maxValue=100,
              minValue = 0, name='TransparencySlider', parent=self, pos=wx.Point(90,
              120), size=wx.Size(100, 16), style=wx.SL_HORIZONTAL, value=0)
        self.SliderTransparency.Bind(wx.EVT_SLIDER, self.OnSliderTransparency,
              id=-1)

        self.annotations_box = wx.StaticBox(id=-1,
              label='', name='window_anno', parent=self,
              pos=wx.Point(12, 174), size=wx.Size(265, 80), style=0)

        self.source_text_label = wx.StaticText(id=-1, label='Source:', name='SourceT',
              parent=self, pos=wx.Point(20, 198), size=wx.Size(50, 13),
              style=0)

        self.source_text = wx.TextCtrl(id=-1, name='Source',
              parent=self, pos=wx.Point(70, 198), size=wx.Size(200, 20),
              style=wx.TE_RIGHT, value='%s' %self.data_source_path)
        self.source_text.SetEditable(0)

        self.source_min_max_text = wx.StaticText(id=-1, label='Data max:%0.2f  Data min:%0.2f' %(self.curr_max,self.curr_min), name='MinMax',
              parent=self, pos=wx.Point(20, 229), size=wx.Size(200, 13),
              style=0)

        self.lookup_text = wx.StaticText(id=-1, label='Select a colour table', name='ColTxt',
              parent=self, pos=wx.Point(25, 152), size=wx.Size(150, 20),
              style=0)
        
        self.LookupTableSelector = wx.BitmapButton(bitmap=wx.Bitmap(u'./CLT_images/red_yel.bmp',
              wx.BITMAP_TYPE_BMP), id=-1,
              name='bitmapButton1', parent=self, pos=wx.Point(150, 148),
              size=wx.Size(108, 24), style=wx.BU_AUTODRAW)
        self.LookupTableSelector.Bind(wx.EVT_BUTTON, self.OnLookupTableSelector,
              id=-1)
    

    def OnManualTransp(self, event):
        opacity = float(self.transp_value_label.GetValue())/100.0
        self.SliderTransparency.SetValue(float(self.transp_value_label.GetValue()))
        for j in self.associated_objects:
            self.frame_parent.ListOfObjects[j].GetTexturePlaneProperty().SetOpacity(1-opacity)
        self.frame_parent.widget.Render()
        event.Skip() 
        
    def OnSliderTransparency(self, event):
        opacity = self.SliderTransparency.GetValue()/100.0
        self.transp_value_label.SetValue(str(self.SliderTransparency.GetValue()))
        for j in self.associated_objects:
            self.frame_parent.ListOfObjects[j].GetTexturePlaneProperty().SetOpacity(1-opacity)
        self.frame_parent.widget.Render()
        event.Skip()


    def OnUpperValue(self, event):
        self.SliderMax.SetValue(int(float(self.Upper_Value.GetValue())*100))
        self.OnSliderMax(event, 1)
        
    def OnLowerValue(self, event):
        self.SliderMin.SetValue(int(float(self.Lower_Value.GetValue())*100))
        self.OnSliderMin(event, 1)
    
    def OnLookupTableSelector(self, event):
        main_app_frame = self.frame_parent
        t = ColourLookupTableFrame(self, main_app_frame)
        new_img = self.frame_parent.tmp_selected_lookup_table[0]
        imageFile = './CLT_images/'+new_img
        image1 = wx.Image(imageFile, wx.BITMAP_TYPE_ANY).ConvertToBitmap()
        self.LookupTableSelector.SetBitmapLabel(image1)

        voldata = self.frame_parent.my_loaded_volumes[self.index_in_volume_list][0]

        voldata.HueRangeMin = self.frame_parent.tmp_selected_lookup_table[1]
        voldata.HueRangeMax = self.frame_parent.tmp_selected_lookup_table[2]
        voldata.ValueRangeMin = self.frame_parent.tmp_selected_lookup_table[5]
        voldata.ValueRangeMax = self.frame_parent.tmp_selected_lookup_table[6]
        voldata.SaturationRangeMin = self.frame_parent.tmp_selected_lookup_table[3]
        voldata.SaturationRangeMax = self.frame_parent.tmp_selected_lookup_table[4]


        #build a new lookuptable with the new range - but existing colours in the HSVA ramp
        y = vtk.vtkLookupTable()
        y.SetNumberOfTableValues(256)
        y.SetHueRange(voldata.HueRangeMin, voldata.HueRangeMax)
        y.SetValueRange(voldata.ValueRangeMin, voldata.ValueRangeMax)
        y.SetSaturationRange(voldata.SaturationRangeMin, voldata.SaturationRangeMin)
        y.SetAlphaRange(voldata.AlphaRangeMin, voldata.AlphaRangeMax)
        y.SetTableRange(float(self.SliderMin.GetValue())/100, float(self.SliderMax.GetValue())/100)
        self.Upper_Value.SetValue(str(float(self.SliderMin.GetValue())/100))
        y.Build()
        y.SetTableValue(0, (0.0,0.0,0.0,0.0))
        
        #apply the new table for later referecnce - tag it to the volume
        self.frame_parent.my_loaded_volumes[self.index_in_volume_list][0].lookuptable = y
        
        # and now tag it to the planes ...   
        for j in self.associated_objects:
            self.frame_parent.ListOfObjects[j].SetLookupTable(y)
            self.frame_parent.ListOfObjects[self.a_o_max].myScalarBar.GetScalarBarActor().SetLookupTable(y)
            self.frame_parent.widget.Render()
            event.Skip()

        align_all_planes(self.frame_parent)
        event.Skip()
        
    
    def OnSliderMin(self, event, called_by_box = 0):
        #scan the loaded volumes and check if the data there = the data associated with the object
        # we are currently manipulating 
        for i in range(len(self.frame_parent.my_loaded_volumes)):
            if i == 2:
                pass #skip the reference volume - always index 2 in the my_loaded_volumes list
            else:
                voldata = self.frame_parent.my_loaded_volumes[self.index_in_volume_list][0]
                #build a new lookuptable with the new range - but existing colours in the HSVA ramp
                                
                y = vtk.vtkLookupTable()
                y.SetNumberOfTableValues(256)
                y.SetHueRange(voldata.HueRangeMin, voldata.HueRangeMax)
                y.SetValueRange(voldata.ValueRangeMin, voldata.ValueRangeMax)
                y.SetSaturationRange(voldata.SaturationRangeMin, voldata.SaturationRangeMin)
                y.SetAlphaRange(voldata.AlphaRangeMin, voldata.AlphaRangeMax)
                y.SetTableRange(float(self.SliderMin.GetValue())/100, float(self.SliderMax.GetValue())/100)
                if called_by_box == 0:
                    self.Lower_Value.SetValue(str(float(self.SliderMin.GetValue())/100))
                y.Build()
                y.SetTableValue(0, (0.0,0.0,0.0,0.0))
                
                #apply the new table for later referecnce - tag it to the volume
                self.frame_parent.my_loaded_volumes[self.index_in_volume_list][0].lookuptable = y
                
                # and now tag it to the planes ...   
                for j in self.associated_objects:
                    self.frame_parent.ListOfObjects[j].SetLookupTable(y)
                    self.frame_parent.ListOfObjects[self.a_o_max].myScalarBar.GetScalarBarActor().SetLookupTable(y)
                    self.frame_parent.widget.Render()
                    event.Skip()
        
        align_all_planes(self.frame_parent)
        event.Skip()


    def OnSliderMax(self, event, called_by_box = 0):
        #scan the loaded volumes and check if the data there = the data associated with the object
        # we are currently manipulating 
        for i in range(len(self.frame_parent.my_loaded_volumes)):
            if i == 2:
                pass #skip the reference volume - always index 2 in the my_loaded_volumes list
            else:
                #if they match
                if self.frame_parent.my_loaded_volumes[i][0].volume_data.GetOutput() == self.thevtkobject.my_data_volume:
                    voldata = self.frame_parent.my_loaded_volumes[i][0]
                    #build a new lookuptable with the new range - but existing colours in the HSVA ramp
                    y = vtk.vtkLookupTable()
                    y.SetNumberOfTableValues(256)
                    y.SetHueRange(voldata.HueRangeMin, voldata.HueRangeMax)
                    y.SetValueRange(voldata.ValueRangeMin, voldata.ValueRangeMax)
                    y.SetSaturationRange(voldata.SaturationRangeMin, voldata.SaturationRangeMin)
                    y.SetAlphaRange(voldata.AlphaRangeMin, voldata.AlphaRangeMax)
                    y.SetTableRange(float(self.SliderMin.GetValue())/100, float(self.SliderMax.GetValue())/100)
                    if called_by_box == 0:
                        self.Upper_Value.SetValue(str(float(self.SliderMax.GetValue())/100))
                    y.Build()
                    y.SetTableValue(0, (0.0,0.0,0.0,0.0))

                    #apply the new table for later referecnce - tag it to the volume                        
                    self.frame_parent.my_loaded_volumes[i][0].lookuptable = y

                    # and now tag it to the planes ...   
                    for j in self.associated_objects:
                        self.frame_parent.ListOfObjects[j].SetLookupTable(y)
                        self.frame_parent.ListOfObjects[self.a_o_max].myScalarBar.GetScalarBarActor().SetLookupTable(y)
                        self.frame_parent.widget.Render()
                        event.Skip()
        align_all_planes(self.frame_parent)
        event.Skip()
         
        
class MyPropertyFrame(wx.Frame):
    def __init__(self, frame_parent, thevtkobject, index_in_volume_list):
        label = thevtkobject.my_label
        wx.Frame.__init__(self, None, -1, 'Properties for '+label, size=(300, 300), style=wx.STAY_ON_TOP|wx.DEFAULT_FRAME_STYLE)
        #check which type of object we are creating a property panel for
        # and call the appropriate panel class
        
        #if we are dealing with the 'base' image ...
        if thevtkobject == frame_parent.ListOfObjects[3]:      
            panel = PropertyPanel_BasePlaneWidgets(self, frame_parent, thevtkobject)
        
        #else:
        elif thevtkobject.my_property_frame_type == 'PlaneWidgetProperties':
            panel = PropertyPanel_OverlayPlaneWidgets(self, frame_parent, thevtkobject)
            #label the frame with its corresponding data volume (so we can update later)
            panel.index_in_volume_list = index_in_volume_list
        elif thevtkobject.my_property_frame_type == 'SurfaceProperties':
            panel = PropertyPanel_SurfaceFromFile(self, frame_parent, thevtkobject)
            #label the frame with its corresponding data volume (so we can update later)
            panel.index_in_volume_list = index_in_volume_list
        elif thevtkobject.my_property_frame_type == '3DContourPlotProperties':
            panel = PropertyPanel_3DContourPlot(self, frame_parent, thevtkobject)
        elif thevtkobject.my_property_frame_type == 'MinNormType1':
            panel = PropertyPanel_MinNormType1(self, frame_parent, thevtkobject)
        elif thevtkobject.my_property_frame_type == '4DNI_Dipole':
            panel = PropertyPanel_4DNI_Dipole(self, frame_parent, thevtkobject)
        else:
            pass
        
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
        
        
    def OnCloseWindow(self, event):
        self.Show(False)



        