#Process for dealing with and redirecting key bindings to appropriate routines

import wx
import os
import time

from dv3dSurfaceFunctions import *
from CLT_selection_Frame import *

class ProcessKey:
    def __init__(self, parent, frame_parent):
 
        self.frame_parent = frame_parent
        
        if self.frame_parent.key == 't':
            pass # t is for trackball-camera mode .. j for joystick
            #Toggle_stat_contourActor(self, self.frame_parent)
        
        elif self.frame_parent.key == 'j':
            pass
        
        elif self.frame_parent.key == 'k':
            t = self.frame_parent.ListOfObjects[-1]
            t.vlp -= 1
            if t.vlp < 0:
                t.vlp = len(t.vl)
            for i in range(248):
                t.s_scalars[i] = t.vl[t.vlp][i]
            t.projectF.Modified()
            cur_time_pt = 1000/t.vlp - 200
            print 'Contour plot at %f ms.\n' % cur_time_pt
            self.frame_parent.widget.Render()

            
        elif self.frame_parent.key == 'c':
            #Generate_stat_contourActor(self, self.frame_parent)
            for i in range(len(self.frame_parent.ListOfObjects)):
                print 'data source is %s .' %self.frame_parent.ListOfObjects[i].my_data_path
            
        elif self.frame_parent.key == 'y':
            y = vtk.vtkLookupTable()
            y.SetNumberOfTableValues(256)
            y.SetHueRange(0.5, 0.667)
            y.SetValueRange(1.0, 1.0)
            y.SetSaturationRange(1.0, 1.0)
            y.SetAlphaRange(1.0, 1.0)
            y.SetTableRange(0, self.frame_parent.my_loaded_volumes[3][0].TableRangeMax)
            y.Build()
            y.SetTableValue(0, (0.0,0.0,0.0,0.0))

            self.frame_parent.my_loaded_volumes[3][0].lookuptable = y
            self.frame_parent.ListOfObjects[6].SetLookupTable(self.frame_parent.my_loaded_volumes[3][0].lookuptable)
            self.frame_parent.ListOfObjects[5].SetLookupTable(self.frame_parent.my_loaded_volumes[3][0].lookuptable)
            self.frame_parent.ListOfObjects[4].SetLookupTable(self.frame_parent.my_loaded_volumes[3][0].lookuptable)


        elif self.frame_parent.key == 'v':
            y = vtk.vtkLookupTable()
            y.SetNumberOfTableValues(256)
            y.SetHueRange(0.5, 0.667)
            y.SetValueRange(1.0, 1.0)
            y.SetSaturationRange(1.0, 1.0)
            y.SetAlphaRange(1.0, 1.0)
            y.SetTableRange(2, self.frame_parent.my_loaded_volumes[3][0].TableRangeMax)
            y.Build()
            y.SetTableValue(0, (0.0,0.0,0.0,0.0))
            
            self.frame_parent.my_loaded_volumes[3][0].lookuptable = y
            
            self.frame_parent.ListOfObjects[6].SetLookupTable(self.frame_parent.my_loaded_volumes[3][0].lookuptable)
            self.frame_parent.ListOfObjects[5].SetLookupTable(self.frame_parent.my_loaded_volumes[3][0].lookuptable)
            self.frame_parent.ListOfObjects[4].SetLookupTable(self.frame_parent.my_loaded_volumes[3][0].lookuptable)

    
        
        elif self.frame_parent.key == 'l':
            #for i in range(len(self.frame_parent.ListOfObjects)):
            #    if self.frame_parent.ListOfObjects[i][0] == 'base_planewidgetgroup':
            #        t = self.frame_parent.ListOfObjects[i][1]
            #for i in range(3):
            #    t.planewidgets[i].GetTexturePlaneProperty().SetOpacity(0.0)
            #self.frame_parent.widget.Render()
            self.frame_parent.ListOfObjects[1].On()
            
        elif self.frame_parent.key == 'n':
            #self.frame_parent.ListOfObjects[0][1].GetTexturePlaneProperty().SetOpacity(0.0)
            #self.frame_parent.widget.Render()
            self.frame_parent.ListOfObjects[1].Off()

        ##test code for bypassing auto - keys in vtk
        #elif self.frame_parent.key == 'p':
        #    self.frame_parent.planeWidgetX.GetTexturePlaneProperty().SetOpacity(0.0)
        #    self.frame_parent.Render()
        #    time.sleep(2)








