
import wx
import os

import globalvar as globalvar
from utils import *


class MarkersTab(wx.Panel):
    def __init__(self, parent, frame_parent):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        self.studyname_ctrl = wx.TextCtrl(self, -1, size=(100, -1))
        self.resultsdir_ctrl = wx.TextCtrl(self, -1, size=(500, -1))
        self.pretrig_ctrl = wx.TextCtrl(self, -1, size=(100, -1))
        self.epoch_ctrl = wx.TextCtrl(self, -1, size=(100, -1))
        browse_results_button = wx.Button(self, -1, 'Browse', (50,50))
        self.Bind(wx.EVT_BUTTON, self.OnBrowseResultsButton, browse_results_button)
        
        #################
        rotate = wx.Button(self, -1, 'rotate', (250,250))
        self.Bind(wx.EVT_BUTTON, self.OnrotateButton, rotate)
        #################
        
        item_list = [wx.StaticText(self, -1, 'Project Name:')]
        item_list.append(self.studyname_ctrl)
        item_list.append(wx.StaticText(self, -1, ' '))

        item_list.append(wx.StaticText(self, -1, 'Results Directory:'))
        item_list.append(self.resultsdir_ctrl)
        item_list.append(browse_results_button)

        item_list.append(wx.StaticText(self, -1, 'Pretrigger (ms):'))
        item_list.append(self.pretrig_ctrl)
        item_list.append(wx.StaticText(self, -1, ' '))

        item_list.append(wx.StaticText(self, -1, 'Epoch Length (ms):'))
        item_list.append(self.epoch_ctrl)
        item_list.append(wx.StaticText(self, -1, ' '))

        self.study_info = wx.FlexGridSizer(cols=3, hgap=10, vgap=50)
        self.study_info.AddMany(item_list)


        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(self.study_info, 0, wx.EXPAND|wx.ALL, 50)
        sizer.Fit(self)
        sizer.SetSizeHints(self)
        self.SetSizer(sizer)

        self.SetAutoLayout(True)

        self.Bind(wx.EVT_TEXT, self.OnKeyPress, self.studyname_ctrl)
        self.Bind(wx.EVT_TEXT, self.OnKeyPress, self.resultsdir_ctrl)
        self.Bind(wx.EVT_TEXT, self.OnKeyPress, self.pretrig_ctrl)
        self.Bind(wx.EVT_TEXT, self.OnKeyPress, self.epoch_ctrl)



    def OnBrowseResultsButton(self, evt):
        dlg = wx.DirDialog(self, "Choose a directory to store results:",
                          style=wx.DD_DEFAULT_STYLE|wx.DD_NEW_DIR_BUTTON)
        if dlg.ShowModal() == wx.ID_OK:
            path = dlg.GetPath()
            self.resultsdir_ctrl.SetValue(path)

    def OnrotateButton(self, evt):
        self.frame_parent.ren.GetActiveCamera().Azimuth(15)


    def OnKeyPress(self, evt):
        update_title(self)
        globalvar.modified = True
