import vtk
from numpy import *

def Update_4DNI_dipole(frame_parent, the_dialog, new_position, ar, line, Sphere):
    
    #Sphere = the_dialog.sphere_actor.GetMapper().GetInput()
    #line = the_dialog.line_actor.GetMapper().GetInput()
    
    dipole_rows = the_dialog.dipole_rows
    dipole_mat = the_dialog.dipole_mat
    dipole_data = dipole_rows[dipole_rows[:,0] >= float(new_position), :][0]
    coord1 = array([dipole_data[1]/100, dipole_data[2]/100, dipole_data[3]/100,1]).reshape(4,1)
    coord2 = array([dipole_data[4]/100, dipole_data[5]/100, dipole_data[6]/100,1]).reshape(4,1)         
    trans_coord1 = dot(dipole_mat, coord1).reshape(1,4)
    trans_coord2 = dot(dipole_mat, coord2).reshape(1,4)
    Sphere.SetCenter( -trans_coord1[0][0]+ar.fov[0]*ar.pixdim[0], trans_coord1[0][1], trans_coord1[0][2])
    Sphere.SetRadius( dipole_data[7]/2 )
    point1 = [-trans_coord1[0][0]+ar.fov[0]*ar.pixdim[0], trans_coord1[0][1], trans_coord1[0][2]]
    point2 = [-trans_coord2[0][0]-trans_coord1[0][0]+ar.fov[0]*ar.pixdim[0], trans_coord2[0][1]+trans_coord1[0][1], trans_coord2[0][2]+trans_coord1[0][2]]
    point2_rescale = add((subtract(point2,point1))/10,point1)
    line.SetPoint1(point1)
    line.SetPoint2(point2_rescale)
    frame_parent.widget.Render()
    


def UpdateContourPlot3D(the_parent_frame, the_dialog_panel, new_position):
    #get the object that corresponds to the dialog frame from the main window
    t = the_parent_frame.ListOfObjects[the_dialog_panel.index_into_objects]
    #TODO - hard coded for HBM- update so actual data is read!
    
    t.vlp = new_position
    if t.vlp < 0:
        t.vlp = len(t.vl)
    for i in range(248):
        t.s_scalars[i] = t.vl[t.vlp][i]
    t.projectF.Modified()
    the_parent_frame.widget.Render()
    
    
def UpdateMinNormType1(the_parent_frame, the_dialog_panel, new_position):
    the_vtkObject = the_parent_frame.ListOfObjects[the_dialog_panel.index_into_objects]
    
    initial_scalars = vtk.vtkFloatArray()
    
    for i in range(7536):
        initial_scalars.InsertNextValue(the_vtkObject.time_series_data[i][new_position])
    the_vtkObject.ScalarValues.SetScalars(initial_scalars)
    the_vtkObject.PolyData.Update()
    the_vtkObject.Mapper.Update()
    the_parent_frame.widget.Render()