
import wx
import vtk
from common_functions import align_all_planes


class ProbePropertyFrame(wx.Frame):
    def __init__(self, frame_parent, thevtkobject, index_in_volume_list):
        label = thevtkobject.my_label
        wx.Frame.__init__(self, None, -1, 'Properties for '+label, size=(300, 300), style=wx.STAY_ON_TOP|wx.DEFAULT_FRAME_STYLE)
        #check which type of object we are creating a property panel for
        # and call the appropriate panel class
        
        #if we are dealing with the 'base' image ...
        if thevtkobject.my_property_frame_type == 'SurfaceProperties':
            panel = PropertyPanel_ProbePropertyFrame(self, frame_parent, thevtkobject)
            #label the frame with its corresponding data volume (so we can update later)
            panel.index_in_volume_list = index_in_volume_list
        else:
            pass
        
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
        
        
    def OnCloseWindow(self, event):
        self.Show(False)
        


class PropertyPanel_ProbePropertyFrame(wx.Panel): #TODO - finish this panel
    def __init__(self, parent, frame_parent, thevtkobject):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        self.thevtkobject = thevtkobject
        
        self.data_source_path = thevtkobject.my_data_path

        self.window_CT = wx.StaticBox(id=-1,
              label='Colour / Transparency', name='window_CT', parent=self,
              pos=wx.Point(12, 24), size=wx.Size(265, 90), style=0)
        
        self.transp_text_label = wx.StaticText(id=-1, label='Transparency:', name='TranspT',
              parent=self, pos=wx.Point(25, 85), size=wx.Size(75, 13),
              style=0)

        #self.transp_value_label = wx.StaticText(id=-1, label='0%', name='TranspT',
        #      parent=self, pos=wx.Point(235, 85), size=wx.Size(35, 13),
        #      style=0)

        self.transp_value_label = wx.TextCtrl(id=-1, name='TranspT',
              parent=self, pos=wx.Point(235, 85), size=wx.Size(35, 20),
              style=wx.TE_RIGHT, value='0')
        self.transp_value_label.SetEditable(1)
        self.transp_value_label.Bind(wx.EVT_TEXT, self.OnManualTransp, id=-1)
        

        self.SliderTransparency = wx.Slider(id=-1, maxValue=100,
              minValue = 0, name='TransparencySlider', parent=self, pos=wx.Point(100,
              85), size=wx.Size(125, 16), style=wx.SL_HORIZONTAL, value=0)
        self.SliderTransparency.Bind(wx.EVT_SLIDER, self.OnSliderTransparency,
              id=-1)

        self.annotations_box = wx.StaticBox(id=-1,
              label='', name='window_anno', parent=self,
              pos=wx.Point(12, 174), size=wx.Size(265, 80), style=0)
                
        self.source_text_label = wx.StaticText(id=-1, label='Source:', name='SourceT',
              parent=self, pos=wx.Point(20, 198), size=wx.Size(50, 13),
              style=0)

        self.source_text = wx.TextCtrl(id=-1, name='Source',
              parent=self, pos=wx.Point(70, 198), size=wx.Size(200, 20),
              style=wx.TE_RIGHT, value='%s' %thevtkobject.my_data_path)
        self.source_text.SetEditable(0)

    
    def OnManualTransp(self, evt):
        new_val = int(self.transp_value_label.GetValue())
        if new_val > 100:
            self.transp_value_label.SetValue('100')
            new_val = 100
        elif new_val < 0:
            self.transp_value_label.SetValue('0')
            new_val = 0
        self.SliderTransparency.SetValue(new_val)
        self.thevtkobject.GetProperty().SetOpacity((100-new_val)/100.0)
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)

            
    def OnSliderTransparency(self, evt):
        opacity = self.SliderTransparency.GetValue()/100.0
        self.thevtkobject.GetProperty().SetOpacity(1-opacity)
        self.transp_value_label.SetLabel('%d' %int((opacity)*100))
        self.frame_parent.widget.Render()
        align_all_planes(self.frame_parent)
        evt.Skip()