import wx

class MyProbeFrame(wx.Frame):
    def __init__(self, frame_parent, thevtkobject):
        wx.Frame.__init__(self, None, -1, 'use surface as a probe ..', size=(300, 300), style=wx.STAY_ON_TOP|wx.DEFAULT_FRAME_STYLE)
             
        panel = ProbePanel(self, frame_parent, thevtkobject)
        
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
        
        
    def OnCloseWindow(self, event):
        self.Show(False)
        

class ProbePanel(wx.Panel):
    #allows the user to select one of the loaded volumes to interrogate

    def __init__(self, frame_parent, the_vtkobject):
        wx.Panel.__init__(self, parent, -1)
        
        #some constants to allow handling later
        self.parent = parent
        self.frame_parent = frame_parent
        self.the_vtkobject = the_vtkobject
        self.index_to_data = 0
        
        drop_down_content = [] #the list holder for the volume selection
        drop_down_content.append('')
        
        #scan all loaded volumes not base, tal, or ref (start at 4th element)
        
        for i in range(3,len(self.frame_parent.my_loaded_volumes)):
            #check if any objects are associated with them therefore if list items exist
            for j in range(len(self.frame_parent.ListOfObjects)):
                #as before ..
                try:
                    if self.frame_parent.ListOfObjects[j].my_loaded_volumesindex == i:
                        label = self.frame_parent.ListOfObjects[j].my_label
                        drop_down_content.append(label)
                except:
                    pass

        self.VolumeChoiceLabel = wx.StaticText(id=-1, label='Choose a loaded volume:', name='ChooseVol',
              parent=self, pos=wx.Point(16, 16), style=0)
        
        self.VolumeChoice = wx.Choice(choices=drop_down_content, id=-1,
              name='VolumeChoice', parent=self, pos=wx.Point(16, 42),
              size=wx.Size(250, 21), style=0)
        self.VolumeChoice.Bind(wx.EVT_CHOICE, self.OnVolumeChoice,
              id=-1)
        
        self.DataMax = wx.StaticText(id=-1, label='Data maximum: not selected', name='DataMax',
              parent=self, pos=wx.Point(16, 90), style=0)
        
        self.DataMin = wx.StaticText(id=-1, label='Data minimum: not selected', name='DataMin',
              parent=self, pos=wx.Point(16, 110), style=0)

        self.ExtractionThresholdLabel = wx.StaticText(id=-1, label='Set the extraction range (e.g. 2.3,5.5:', name='extThrLab',
              parent=self, pos=wx.Point(16, 135), style=0)

        self.ExtractionThreshold = wx.TextCtrl(id=-1, name='ExtractThr',
              parent=self, pos=wx.Point(175, 130), size=wx.Size(75, 20),
              style=wx.TE_RIGHT, value='0')
        self.ExtractionThreshold.SetEditable(1)
        
        self.GenerateSurface = wx.Button(self, -1, 'Run', (150,200))
        self.Bind(wx.EVT_BUTTON, self.OnGenerateSurfaceButton, self.GenerateSurface)


    def OnGenerateSurfaceButton(self, evt):
        ind = self.index_to_data
        data_vol = self.frame_parent.my_loaded_volumes[ind][0].volume_data
        data_source_path = self.frame_parent.my_loaded_volumes[ind][0].data_source_path
        thr = self.ExtractionThreshold.GetValue()
        thr = thr.split(',')

        for i in range(len(thr)):
            #loop through multiple surfaces if provided
            Generate_surface_from_loaded_volume(thr[i], data_vol, self.frame_parent, self.frame_parent.tmp_data_max, data_source_path)
        self.parent.Destroy()
        
        
    def OnVolumeChoice(self, evt):
        choice = self.VolumeChoice.GetStringSelection()

        if choice == 'Base volume':
            self.frame_parent.tmp_data_max = self.frame_parent.my_loaded_volumes[0][0].data_max
            self.frame_parent.tmp_data_min = self.frame_parent.my_loaded_volumes[0][0].data_min
            self.DataMax.SetLabel('Data maximum: %s' %str(self.frame_parent.tmp_data_max))
            self.DataMin.SetLabel('Data minimum: %s' %str(self.frame_parent.tmp_data_min))                
            
        elif choice != '':
            for i in range(len(self.frame_parent.my_loaded_volumes)):
                try:
                    if self.frame_parent.my_loaded_volumes[i][0].data_label == choice:
                        max = self.frame_parent.my_loaded_volumes[i][0].data_max
                        min = self.frame_parent.my_loaded_volumes[i][0].data_min
                        self.DataMax.SetLabel('Data maximum: %s' %str(max))
                        self.DataMin.SetLabel('Data minimum: %s' %str(min))
                        self.index_to_data = i
                except:
                    self.DataMax.SetLabel('Data maximum: not selected')
                    self.DataMin.SetLabel('Data minimum: not selected')
        else:
            self.DataMax.SetLabel('Data maximum: not selected')
            self.DataMin.SetLabel('Data minimum: not selected')