import vtk

def AddPolyDataClipper(frame_parent, index_to_PolyData):
    f = frame_parent.ListOfObjects[index_to_PolyData].GetMapper().GetInput()
    
    output = f
    output.Update()
    
    planes1 = vtk.vtkPlanes()
    clipper1 = vtk.vtkClipPolyData()
    clipper1.SetInput(output)
    clipper1.SetClipFunction(planes1)
    clipper1.InsideOutOff()
    selectMapper1 = vtk.vtkPolyDataMapper()
    selectMapper1.SetInput(clipper1.GetOutput())
    selectActor1 = vtk.vtkLODActor()
    selectActor1.SetMapper(selectMapper1)
    selectActor1.GetProperty().SetColor(0.6, 0.6, 0.6)
    
    #set some properties for the inner face
    property1 = vtk.vtkProperty()
    property1.SetColor(0.6, 0.6, 0.6)

    selectActor1.SetBackfaceProperty(property1)
    selectActor1.VisibilityOff()
    selectActor1.SetScale(1.01, 1.01, 1.01)
    
    frame_parent.ren.AddActor(selectActor1)
    
    # This callback funciton does the actual work: updates the vtkPlanes
    # implicit function.  This in turn causes the pipeline to update.
    def SelectPolygons1(object, event):
        # object will be the boxWidget
        object.GetPlanes(planes1)
        selectActor1.VisibilityOn()
        origActor.VisibilityOff()
            
    frame_parent.boxWidget1.SetInput(output)
    frame_parent.boxWidget1.PlaceWidget()
    frame_parent.boxWidget1.AddObserver("StartInteractionEvent", SelectPolygons1)