import vtk
import os, sys
from struct import calcsize, unpack
from numpy import *
from dv3dObjectsToRender import *
from dv3dPropertyFrames import *

def LoadMinNormType1(frame_parent, vertex_file, time_series_file):
    surface, lookuptable, time_series_data, mn_ScalarValues, mn_PolyData, mn_Mapper = CreateMinNormSurface(frame_parent, vertex_file, time_series_file)
    
    AddVTKObjectWithAttributes(surface,\
                        frame_parent,\
                        'MinNormType1',\
                        'Min Norm Surface',\
                        None,\
                        None,\
                        0,\
                        1,\
                        1,\
                        'structural',\
                        None,\
                        time_series_file,\
                        1,\
                        'MinNormType1',\
                        None)

    frame_parent.ren.AddActor(frame_parent.ListOfObjects[-1])
    
    #apply the new table for later referecnce - tag it to the volume                        
    frame_parent.ListOfObjects[-1].lookuptable = lookuptable
    frame_parent.ListOfObjects[-1].GetMapper().SetLookupTable(lookuptable)
    frame_parent.ListOfObjects[-1].time_series_data = time_series_data
    frame_parent.ListOfObjects[-1].ScalarValues = mn_ScalarValues
    frame_parent.ListOfObjects[-1].PolyData = mn_PolyData
    frame_parent.ListOfObjects[-1].Mapper = mn_Mapper
    
    
    new_surface = frame_parent.tree.AppendItem(frame_parent.tree_structural, frame_parent.ListOfObjects[-1].my_label)
    #add the newly created treeitem as an atribute of the plane_group
    frame_parent.ListOfObjects[-1].my_treeitem = new_surface


    frame_parent.tree.Refresh()
    
    # .. create a properties window for the plane set ...
    # we pass the parent frame and the newly created object as args
    frame = MyPropertyFrame(frame_parent, frame_parent.ListOfObjects[-1], 0)
    frame.Show(True)
    
    # ... and apply it to the relevant list object
    frame_parent.ListOfObjects[-1].my_property_frame_instance = frame




def CreateMinNormSurface(frame_parent, vertex_file, time_series_file):
    try_me = vtk.vtkPolyDataReader()
    try_me.SetFileName(vertex_file)
    
    #load the data    
    f = open(time_series_file,'rb')
    sz0 = unpack('>l', f.read(calcsize('l')))[0]
    sz1 = unpack('>l', f.read(calcsize('l')))[0]
    start_time = unpack('>f', f.read(calcsize('f')))[0]
    delt = unpack('>f', f.read(calcsize('f')))[0]
    
    vert = []
    for i in range(sz0*sz1):
        n = unpack('>f', f.read(calcsize('f')))[0]
        vert.append(n)
        

    mn_data = reshape(vert, (sz0,sz1))
    f.close()
    
    mn_PolyData = try_me.GetOutput()
    mn_PolyData.Update()
    
    mn_ScalarValues = mn_PolyData.GetPointData()
    
    initial_scalars = vtk.vtkFloatArray()
    
    mn_curr_pos = 0
    
    for i in range(7536):
        initial_scalars.InsertNextValue(mn_data[i][mn_curr_pos])
    
    mn_ScalarValues.SetScalars(initial_scalars)
    
    mn_PolyData.Update()
    
    mn_Mapper = vtk.vtkPolyDataMapper()
    mn_Mapper.SetInput(mn_PolyData)
    mn_Mapper.ScalarVisibilityOn()
    
    mn_Mapper.Update()
    
    my_mnorm_brain = vtk.vtkActor()

    my_mnorm_brain.SetMapper(mn_Mapper)
    
    max_in_data = 300 #max(max(reshape(mn_data,(1,sz0*sz1))))
    #build a new lookuptable with the new range - but existing colours in the HSVA ramp
    
    y = vtk.vtkLookupTable()
    y.SetNumberOfTableValues(256)
    y.SetHueRange(0.0, 0.1667)
    y.SetValueRange(1.0, 1.0)
    y.SetSaturationRange(1.0, 1.0)
    y.SetAlphaRange(1.0, 1.0)
    y.SetTableRange(5.0, max_in_data*1.05)
    y.Build()
    y.SetTableValue(0, (0.0,0.0,0.0,0.0))
    
    
    my_mnorm_brain.GetMapper().SetLookupTable(y)

    return my_mnorm_brain, y, mn_data, mn_ScalarValues, mn_PolyData, mn_Mapper
