import vtk

def readDICOMFolder(dir_name):
    #takes the directory and constucts the volume from the series ... 
    # at the moment the this can only handle 2d/3d data (i.e. not mutli-
    # volume data)
    # all dicom files in the directory must also be from the same series
    
    reader = vtk.vtkDICOMImageReader()
    reader.SetDirectoryName(dir_name)
    print 'loaded DICOM dirname: ', dir_name
    try:
        reader.Update()
    except:
        print 'Error: cannot read this folder. All files must be from the same series;\
        the series must be a single image or single 3d volume (not 4d timeseries)'
        return 'Error'

    bounds = reader.GetOutput().GetBounds()
    (y,x) = reader.GetOutput().GetScalarRange()
    spacing = reader.GetDataSpacing()[2]
    
    x_slice_pos = 10
    y_slice_pos = 10
    z_slice_pos = 10
    
    return reader, x, y, bounds, x_slice_pos, y_slice_pos, z_slice_pos, 0, 0, 0, spacing
