
import wx
import os

import globalvar as globalvar
from utils import *

from dv3dDialogs import *
from dv3dPolydataClipper import *


class SurfacesTab(wx.Panel):
    def __init__(self, parent, frame_parent):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent

        LoadExternalSurface = wx.Button(self, -1, 'Load a surface file ', (20,10))
        self.Bind(wx.EVT_BUTTON, self.OnLoadButton, LoadExternalSurface)

        GenerateSurface = wx.Button(self, -1, 'Generate a surface file from current data', (20,40))
        self.Bind(wx.EVT_BUTTON, self.OnGenerateButton, GenerateSurface)
        
        CreateClippedSurface = wx.Button(self, -1, 'Create a clipped surface', (20,70))
        self.Bind(wx.EVT_BUTTON, self.OnCreateClippedSurfaceButton, CreateClippedSurface)

    def OnCreateClippedSurfaceButton(self, evt):
        AddPolyDataClipper(self.frame_parent, -1)#index_to_PolyData)
        
    def OnLoadButton(self, evt):
        frame = MyDialogFrame(self.frame_parent, 'DialogSurfaceSelection')
        frame.Show(True)
        
    def OnGenerateButton(self, evt):
        frame = MyDialogFrame(self.frame_parent, 'DialogSurfaceGenerate')
        frame.Show(True)