
import wx
import os
from numpy import *

import globalvar as globalvar
from utils import *
from dv3dNiftiReader import *
from dv3dDataVolumes import *


my_filetypes = "NIFTI files (*.nii.gz)|*.nii.gz"
# This is the MNI-toTalairach transformation matrix from Lancaster et al 2007
MTT_pooled = array([[0.9357, 0.0029, -0.0072, -1.0423],[-0.0065, 0.9396, -0.0726, -1.3940],[0.0103, 0.0752, 0.8967, 3.6475],[0,0,0,1]])


class RefTab(wx.Panel):
    def __init__(self, parent, frame_parent):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        
        self.frame_parent.MTT_pooled = array([[0.9357, 0.0029, -0.0072, -1.0423],[-0.0065, 0.9396, -0.0726, -1.3940],[0.0103, 0.0752, 0.8967, 3.6475],[0,0,0,1]])


        self.textCtrl1 = wx.TextCtrl(id=-1, name='textCtrl1',
              parent=self, pos=wx.Point(8, 30), size=wx.Size(264, 21),
              style=0, value='')

        self.DataSourceST = wx.StaticText(id=-1,
              label='Reference Volume data source (e.g. MNI.nii.gz)',
              name='DataSourceST', parent=self, pos=wx.Point(8, 8),
              size=wx.Size(229, 13), style=0)

        self.BrowseBtn = wx.Button(id=-1, label='Browse',
              name='BrowseBtn', parent=self, pos=wx.Point(280, 30),
              size=wx.Size(91, 23), style=0)
        self.BrowseBtn.Bind(wx.EVT_BUTTON, self.OnBrowseResultsButton,
              id=-1)

        self.RefIsMniChkBx = wx.CheckBox(id=-1,
              label='Ref is in MNI space', name='RefIsMniChkBx',
              parent=self, pos=wx.Point(120, 70), size=wx.Size(118, 13),
              style=0)
        self.RefIsMniChkBx.SetValue(False)
        self.RefIsMniChkBx.Bind(wx.EVT_CHECKBOX, self.OnRefIsMniChkBxCheckbox,
              id=-1)

        self.ShowTalChckBx = wx.CheckBox(id=-1,
              label='Show Talairach transform', name='ShowTalChckBx',
              parent=self, pos=wx.Point(264, 70), size=wx.Size(144, 13),
              style=0)
        self.ShowTalChckBx.SetValue(False)
        self.ShowTalChckBx.Bind(wx.EVT_CHECKBOX, self.OnShowTalChckBxCheckbox,
              id=-1)
        self.ShowTalChckBx.Enable(0)

        self.ShowTransformChkBx = wx.CheckBox(id=-1,
              label='Show transform', name='ShowTransformChkBx',
              parent=self, pos=wx.Point(8, 70), size=wx.Size(104, 13),
              style=0)
        self.ShowTransformChkBx.SetValue(False)
        self.ShowTransformChkBx.Bind(wx.EVT_CHECKBOX,
              self.OnShowTransformChkBxCheckbox,
              id=-1)


        self.LoadRefBtn = wx.Button(id=-1, label='LOAD NOW',
              name='LoadRefBtn', parent=self, pos=wx.Point(464, 30),
              size=wx.Size(75, 23), style=0)
        self.LoadRefBtn.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.BOLD, False,
              'Arial'))
        self.LoadRefBtn.SetBackgroundColour(wx.Colour(255, 255, 0))
        self.LoadRefBtn.Bind(wx.EVT_BUTTON, self.OnLoadRefBtnButton,
              id=-1)



    def OnBrowseResultsButton(self, evt):
        dlg = wx.FileDialog(self, "Choose the reference data file:", '', "", my_filetypes, wx.OPEN)
        if dlg.ShowModal() == wx.ID_OK:
            path = dlg.GetPath()
            self.textCtrl1.SetValue(path)



    def OnRefIsMniChkBxCheckbox(self, event):
        if self.RefIsMniChkBx.GetValue() == True:
            self.frame_parent.MNI_active = True
            self.ShowTalChckBx.Enable(1)
        else:
            self.frame_parent.MNI_active = False
            self.ShowTalChckBx.SetValue(False)
            self.ShowTalChckBx.Enable(0)
            self.ShowTalChckBx.SetValue(False)
            self.frame_parent.ShowTalTransform = 0

    def OnShowTalChckBxCheckbox(self, event):
        if self.ShowTalChckBx.GetValue() == True:
            self.frame_parent.ShowTalTransform = 1
        else:
            self.frame_parent.ShowTalTransform = 0

    def OnShowTransformChkBxCheckbox(self, event):
        if self.ShowTransformChkBx.GetValue() == True:
            self.frame_parent.ShowRefTransform = 1
        else:
            self.frame_parent.ShowRefTransform = 0
            self.ShowTalChckBx.SetValue(False)
            self.frame_parent.ShowTalTransform = 0

    def OnLoadRefBtnButton(self, event):
        if self.textCtrl1.GetValue() == '':
            retry = wx.MessageDialog(self, "Supply a file to load")
            if retry.ShowModal() == wx.ID_OK:
                event.Skip()
        else:
            self.frame_parent.ref_data_to_load = self.textCtrl1.GetValue()
            ref_vol = create_new_volume(self.frame_parent.ref_data_to_load ,'ref data')
            self.frame_parent.my_loaded_volumes[2] = ref_vol
            dlg = wx.FileDialog(self, "Choose the reference data file:", '', "", "", wx.OPEN)
            if dlg.ShowModal() == wx.ID_OK:
                path = dlg.GetPath()
                ref_transform_to_load = path
                f = open(ref_transform_to_load)
                self.frame_parent.ref_transform = reshape(fromfile(f, dtype=float, count=-1, sep=' '),(4,4))
                f.close()
                self.frame_parent.ref_loaded = 1
                self.frame_parent.ref_details = nifti_reader(self.frame_parent.ref_data_to_load)
                self.frame_parent.ref_dims = self.frame_parent.ref_details.pixdim
                self.frame_parent.ref_s_form = array([self.frame_parent.ref_details.srow_x,\
                                                      self.frame_parent.ref_details.srow_y,\
                                                      self.frame_parent.ref_details.srow_z,\
                                                      (0,0,0,1)])
                self.ShowTransformChkBx.SetValue(True)
                self.frame_parent.ShowRefTransform = 1

        

        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
