
import wx
import os
from numpy import *

import globalvar as globalvar
from utils import *
from dv3dNiftiReader import *
from dv3dNifti2VtkImageData import *

my_filetypes = "NIFTI files (*.nii.gz)|*.nii.gz"

class FunctionalTab(wx.Panel):
    def __init__(self, parent, frame_parent):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        
        self.textCtrl1 = wx.TextCtrl(id=-1, name='textCtrl1',
              parent=self, pos=wx.Point(8, 30), size=wx.Size(264, 21),
              style=0, value='')

        self.DataSourceST = wx.StaticText(id=-1,
              label='Volume data source (e.g. zstat1.nii.gz)',
              name='DataSourceST', parent=self, pos=wx.Point(8, 8),
              size=wx.Size(229, 13), style=0)

        self.BrowseBtn = wx.Button(id=-1, label='Browse',
              name='BrowseBtn', parent=self, pos=wx.Point(280, 30),
              size=wx.Size(91, 23), style=0)
        self.BrowseBtn.Bind(wx.EVT_BUTTON, self.OnBrowseResultsButton,
              id=-1)

        self.LoadRefBtn = wx.Button(id=-1, label='LOAD NOW',
              name='LoadRefBtn', parent=self, pos=wx.Point(464, 30),
              size=wx.Size(75, 23), style=0)
        self.LoadRefBtn.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.BOLD, False,
              'Tahoma'))
        self.LoadRefBtn.SetBackgroundColour(wx.Colour(255, 255, 0))
        self.LoadRefBtn.Bind(wx.EVT_BUTTON, self.load_stat_volume,
              id=-1)



    def OnBrowseResultsButton(self, evt):
        dlg = wx.FileDialog(self, "Choose the reference data file:", '', "", my_filetypes, wx.OPEN)
        if dlg.ShowModal() == wx.ID_OK:
            path = dlg.GetPath()
            self.textCtrl1.SetValue(path)

    def load_stat_volume(self, event):
        if self.textCtrl1.GetValue() == '':
            retry = wx.MessageDialog(self, "Supply a file to load")
            if retry.ShowModal() == wx.ID_OK:
                event.Skip()
        else:
            stat_file_to_load = self.textCtrl1.GetValue()
            self.frame_parent.stat_vol, self.frame_parent.stat_data_max, self.frame_parent.stat_data_min,           \
                      self.frame_parent.stat_data_bounds, self.frame_parent.stat_x_slice_pos,          \
                      self.frame_parent.stat_y_slice_pos, self.frame_parent.stat_z_slice_pos,          \
                      self.frame_parent.stat_s_row_x, self.frame_parent.stat_s_row_y,                  \
                      self.frame_parent.stat_s_row_z, self.frame_parent.stat_spacing                   \
                       = nifti2vtkImageData(stat_file_to_load)
            self.frame_parent.stat_data = self.frame_parent.stat_vol.GetOutput()
            
            #now generate an object - or feature array for a stat object - to store memory fro later access
            #how many stats do wealready have?
            stat_count = 1
            for i in range(len(self.frame_parent.my_loaded_objects)):
                if self.frame_parent.my_loaded_objects[i][0][0:4] == 'Stat':
                    stat_count += 1
            stat_data_label = 'Stat_%s' %str(stat_count)
            stat_source_file = stat_file_to_load
            
            #append the stat volume to our loaded list
            self.frame_parent.my_loaded_objects.append([stat_data_label, \
                                                        stat_source_file, \
                                                        self.frame_parent.stat_vol, \
                                                        self.frame_parent.stat_data_max, \
                                                        self.frame_parent.stat_data_min])
            
            planeWidgetS = vtk.vtkImagePlaneWidget()
            planeWidgetS.DisplayTextOn()
            planeWidgetS.SetInteractor(self.frame_parent.widget)
            planeWidgetS.SetInput(self.stat_vol.GetOutput())
            planeWidgetS.SetPlaneOrientationToZAxes()
            planeWidgetS.SetSliceIndex(self.frame_parent.x_slice_pos)
            planeWidgetS.SetPicker(self.frame_parent.picker)
            planeWidgetS.SetHandleSize(500)
            #planeWidgetZ.AddObserver("KeyPressEvent", myMouse_tracker)
            prop1 = self.planeWidgetS.GetPlaneProperty()
            prop1.SetColor(1, 1, 1)
            #if we use the same lookuptable, x, y and z all update together
            #self.planeWidgetZ.SetLookupTable(self.planeWidgetX.GetLookupTable())
            self.planeWidgetS.SetKeyPressActivation(0)
            
            self.frame_parent.my_loaded_objects.append(['PW_stat',stat_data_label, planeWidgetS]
            self.frame_parent.
            
            print self.frame_parent.my_loaded_objects
