
import wx
import os
from numpy import *

import globalvar as globalvar
from utils import *
from dv3dNiftiReader import *
from dv3dNifti2VtkImageData import *
from dv3dPlaneWidgets import *
from dv3dDataVolumes import *
from dv3dSetupNewPlanes import *


my_filetypes = "NIFTI files (*.nii.gz)|*.nii.gz|ANALYZE header (*.hdr)|*.hdr|ANALYZE image (*.img)|*.img|DICOM volume (select 1st file in folder)|*.*"

class FunctionalTab(wx.Panel):
    def __init__(self, parent, frame_parent):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        
        self.textCtrl1 = wx.TextCtrl(id=-1, name='textCtrl1',
              parent=self, pos=wx.Point(8, 30), size=wx.Size(264, 63),
              style=wx.TE_MULTILINE, value='')

        self.DataSourceST = wx.StaticText(id=-1,
              label='Volume data source (e.g. zstat1.nii.gz)',
              name='DataSourceST', parent=self, pos=wx.Point(8, 8),
              size=wx.Size(229, 13), style=0)

        self.BrowseBtn = wx.Button(id=-1, label='Browse',
              name='BrowseBtn', parent=self, pos=wx.Point(280, 30),
              size=wx.Size(91, 23), style=0)
        self.BrowseBtn.Bind(wx.EVT_BUTTON, self.OnBrowseResultsButton,
              id=-1)

        self.LoadOverlayBtn = wx.Button(id=-1, label='LOAD NOW',
              name='LoadRefBtn', parent=self, pos=wx.Point(464, 30),
              size=wx.Size(75, 23), style=0)
        self.LoadOverlayBtn.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.BOLD, False,
              'Arial'))
        self.LoadOverlayBtn.SetBackgroundColour(wx.Colour(255, 255, 0))
        self.LoadOverlayBtn.Bind(wx.EVT_BUTTON, self.load_overlay_volume,
              id=-1)



    def OnBrowseResultsButton(self, evt):
        dlg = wx.FileDialog(self, "Choose the data file(s) to load:", '', "", my_filetypes, wx.OPEN|wx.MULTIPLE)
        if dlg.ShowModal() == wx.ID_OK:
            path = dlg.GetPaths()
            self.source_dir = dlg.GetDirectory()
            self.frame_parent.overlay_files_to_load = [] #clear from before
            self.textCtrl1.SetValue('')
            for i in range(len(path)):
                self.frame_parent.overlay_files_to_load.append(str(path[i]))
                self.textCtrl1.AppendText(str(path[i]))
                self.textCtrl1.AppendText('\n')
    
    
    def load_overlay_volume(self, event):
        if self.textCtrl1.GetValue() == '':
            retry = wx.MessageDialog(self, "Supply a file to load")
            if retry.ShowModal() == wx.ID_OK:
                event.Skip()
        else:
            planes_setup(self.frame_parent, self.frame_parent.overlay_files_to_load[0], 'stat', self.source_dir)
            self.frame_parent.ListOfObjects[-5].myScalarBar.On()
