import vtk

from dv3dObjectsToRender import *
from dv3dProbePropertyFrame import *

def UseCurrentSurfaceAsDataProbe(frame_parent, the_surface, the_volume):

    LUT = the_volume[0].lookuptable
    
    #here we do now want null values to be transparent
    LUT.SetTableValue(0, (0.5,0.5,0.5,1.0))
    LUT.Build()
    
    a = the_surface.GetMapper()
    b = a.GetInput()
    
    # the really clever bit (thx VTK!) - wherever i have a datapoint on my
    # surface, go to thesame datapoint in the stat-volume and extract the
    # scalar value there- probe the data with spatial filter - ProbeFilter
    stat_probe = vtk.vtkProbeFilter()
    
    #stat_probe.SetInput(deci.GetOutput()) 
    stat_probe.SetInput(b) 
    stat_probe.SetSource(the_volume[0].volume_data.GetOutput())#.GetOutput())
    
    transform1 = vtk.vtkTransform()
    transform1.Scale(1.001, 1.001, 1.001)
    
    transformer1 = vtk.vtkTransformPolyDataFilter()
    transformer1.SetInput(stat_probe.GetOutput())
    transformer1.SetTransform(transform1)
    
    
    stat_contourMapper = vtk.vtkPolyDataMapper()
    stat_contourMapper.SetInput(transformer1.GetOutput())
    #stat_contourMapper.SetScalarRange(frame_parent.stat_vol.GetOutput().GetScalarRange()) #e.g. dynamically set the scalarrange based on values in the data
    stat_contourMapper.SetScalarRange(LUT.GetTableRange())
    #stat_contourMapper.GetLookupTable().SetTableValue(0, (0.5,0.5,0.5,1.0))
    stat_contourMapper.SetLookupTable(LUT)
    stat_contourMapper.SetColorModeToMapScalars()
    
    # set a colour bar for reference of scalar value mapping
    pos_scalarBar =  vtk.vtkScalarBarActor()
    pos_scalarBar.SetLookupTable(the_volume[0].lookuptable)
    pos_scalarBar.SetTitle('')
    pos_scalarBar.GetTitleTextProperty().SetFontSize(24)
    pos_scalarBar.GetPositionCoordinate().SetCoordinateSystemToNormalizedViewport()
    pos_scalarBar.GetPositionCoordinate().SetValue(0.05,0.75)
    pos_scalarBar.SetWidth(0.05)
    pos_scalarBar.SetHeight(0.2)
    pos_scalarBar.SetNumberOfLabels(5)
    pos_scalarBar.SetOrientationToVertical()
    
    sbw = vtk.vtkScalarBarWidget()
    sbw.SetScalarBarActor(pos_scalarBar)
    
    #now pass all our created and updated objects to the renderer
    stat_contourActor = vtk.vtkActor()
    stat_contourActor.SetMapper(stat_contourMapper)
    stat_contourActor.VisibilityOn()
    stat_contourActor.GetProperty().SetBackfaceCulling(0)
    
    AddVTKObjectWithAttributes(stat_contourActor,\
                        frame_parent,\
                        'vtkPolyDataProbeOutputSurface',\
                        'surface',\
                        None,\
                        None,\
                        0,\
                        1,\
                        1,\
                        'functional',\
                        None,\
                        the_volume[0].data_source_path,\
                        1,\
                        'SurfaceProperties',\
                        None)

    frame_parent.ListOfObjects[-1].my_color_bar = pos_scalarBar
    frame_parent.ortho_window.ortho_ren1.AddActor(frame_parent.ListOfObjects[-1])
    frame_parent.ortho_window.ortho_ren1.AddActor(frame_parent.ListOfObjects[-1].my_color_bar)    
    frame_parent.ortho_window.ortho_ren2.AddActor(frame_parent.ListOfObjects[-1])
    frame_parent.ortho_window.ortho_ren2.AddActor(frame_parent.ListOfObjects[-1].my_color_bar)
    frame_parent.ortho_window.ortho_ren3.AddActor(frame_parent.ListOfObjects[-1])
    frame_parent.ortho_window.ortho_ren3.AddActor(frame_parent.ListOfObjects[-1].my_color_bar)    
    frame_parent.ren.AddActor(frame_parent.ListOfObjects[-1])
    sbw.SetInteractor(frame_parent.widget)
    sbw.SetScalarBarActor(pos_scalarBar)
    sbw.On()
    #frame_parent.ren.AddActor(frame_parent.ListOfObjects[-1].my_color_bar)

    new_surface = frame_parent.tree.AppendItem(frame_parent.tree_structural, frame_parent.ListOfObjects[-1].my_label)
    #add the newly created treeitem as an atribute of the plane_group
    frame_parent.ListOfObjects[-1].my_treeitem = new_surface
    frame_parent.tree.Refresh()
    
    # .. create a properties window for the plane set ...
    # we pass the parent frame and the newly created object as args
    frame = ProbePropertyFrame(frame_parent, frame_parent.ListOfObjects[-1], 0)
    frame.Show(True)
    
    # ... and apply it to the relevant list object
    frame_parent.ListOfObjects[-1].my_property_frame_instance = frame
    
    align_all_planes(the_parent_frame)

