import wx
import vtk

#!/usr/bin/env python
def drawSingleFrame(frame_parent):
    
    export_file_types = "JPEG|*.jpg,*.jpeg|TIFF|*.tif, *.tiff|BITMAP|*.bmp|PNG|*.png|PNM|*.pnm"
    
    save_name = wx.FileDialog(frame_parent, 'Save the image as ..', '', '', export_file_types, wx.SAVE)
    if save_name.ShowModal() == wx.ID_OK:
        save_name.data_source_path = save_name.GetPath()
        
    else:
        print 'Write cancelled\n' 
        return          
    
    type = save_name.GetFilterIndex()
    
    fname = save_name.data_source_path
    
    if type == 0:
        writer = vtk.vtkJPEGWriter()

    elif type == 1:
        writer = vtk.vtkTIFFWriter()
        if fname[-5] != '.tiff':
           fname = fname + '.tiff'

    elif type == 2:
        writer = vtk.vtkBMPWriter()

    elif type == 3:
        writer = vtk.vtkPNGWriter()

    elif type == 4:
        writer = vtk.vtkPNMWriter()

    else:
        print 'Error writing!'
        return
    
    window = frame_parent.ren.GetRenderWindow()
    curr_size = window.GetSize()
    window.SetSize(2500,2500)
    frame_parent.widget.Render()
    
    w2i = vtk.vtkWindowToImageFilter()
    w2i.SetInput(window)
    w2i.Update()
    writer.SetInput(w2i.GetOutput())
    writer.SetFileName(fname)
    frame_parent.widget.Render()
    writer.Write()
    window.SetSize(curr_size)
    frame_parent.widget.Render()
    print 'Saved main window to %s sucessfully\n' %fname