
import wx
import os
import vtk
import time

import globalvar as globalvar
from utils import *

from dv3dExportSingleFrame import *
from dv3dExportMovieStills import *
from dv3dAviExporter import writeAVI
from dv3dExportRTImageStream import *


class ExportTab(wx.Panel):
    def __init__(self, parent, frame_parent):
        wx.Panel.__init__(self, parent, -1)

        self.frame_parent = frame_parent
        
        self.export_tif = wx.Button(self, -1, 'Export current frame to single image', (10,10))
        self.export_tif.Bind(wx.EVT_BUTTON, self.ExportSingleButton, self.export_tif)
        
        self.export_statics = wx.Button(self, -1, 'Export 360 degrees to multiple single images', (10,40))
        self.export_statics.Bind(wx.EVT_BUTTON, self.ExportStaticsButton, self.export_statics)

        self.export_avi_movie = wx.Button(self, -1, 'Export 360 degrees directly to .AVI movie', (10,70))
        self.export_avi_movie.Bind(wx.EVT_BUTTON, self.ExportAVIMovieButton, self.export_avi_movie)

        ## an example of using a non-vtk dependent timer to drive a real-time image
        ##  capture proces from the interactor window - uses the parent frame (Wx) 's
        ##  timer class to effectively set up a thread which periodically captures the
        ##  current displayed content of the vtk window
        self.ImageStreamOn = wx.Button(self, -1, 'Start interactive streaming', (350,10))
        self.ImageStreamOn.SetToolTipString('This is a Hello button... helloooooooooooooooo')
        self.ImageStreamOff = wx.Button(self, -1, 'Stop stream', (350,40))
        self.ImageStreamOff.Disable()
        
        # a text display of the current frame count
        self.ImageStreamFrameCount = wx.StaticText(self, -1, 'Frame count = %05.0f' \
                                                   %len(self.frame_parent.stream_image_list), (450,45))
        
        self.Bind(wx.EVT_BUTTON, self.OnStreamStart, self.ImageStreamOn)
        self.Bind(wx.EVT_BUTTON, self.OnStreamStop,  self.ImageStreamOff)
                
        # Bind all wx.EVT_TIMER events to the routine that actually exports
        #  the images to the images folder
        self.Bind(wx.EVT_TIMER, self.OnWriteStreamActive)


        self.SaveWorkspace = wx.Button(self, -1, 'Save workspace', (350,80))
        self.Bind(wx.EVT_BUTTON, self.OnSaveWorkspace,  self.SaveWorkspace)


    def OnSaveWorkspace(self, evt):
        ##dialog to load our base file
        dlg = wx.FileDialog(self.frame_parent, "Save your workspace file here:", "", "", "DV3D session file|*.sess", wx.SAVE)
        
        if dlg.ShowModal() == wx.ID_OK:
            file_to_load = dlg.GetPath()
            source_dir = dlg.GetDirectory()
            f = open(file_to_load, 'w')
            
            for i in range(len(self.frame_parent.Completed_processes)):
                for j in range(len(self.frame_parent.Completed_processes[i])):
                    f.write(self.frame_parent.Completed_processes[i][j])
                    f.write(',')
                
                f.write('\n')
            
            f.close()
            print 'Workspace saved to %s' %file_to_load


        else:
            print 'Save workspace cancelled by user.'
        
        
        
            
            
            
            
    def OnWriteStreamActive(self, evt):
        #WriteImageStream(self.frame_parent)
        WriteImageStream_buffered(self.frame_parent)
        
    def OnStreamStart(self, evt):
        
        dlg = wx.DirDialog(self, "Choose a directory to store results:",
                          style=wx.DD_DEFAULT_STYLE|wx.DD_NEW_DIR_BUTTON)
        if dlg.ShowModal() == wx.ID_OK:
            path = dlg.GetPath()
            self.frame_parent.write_imagestream_directory = path
        else:
            print 'Cancelled. No directory selected.'
            return

        
        self.t1 = wx.Timer(self)
        self.t1.Start(100)
        print("Image stream active! - timer started\n")
        self.ImageStreamOff.Enable()

    def OnStreamStop(self, evt):
        self.t1.Stop()
        print("Image stream STOPPED.\n")
        WriteImageStream_buffered_WriteNow(self.frame_parent)
        del self.t1
        self.ImageStreamOff.Disable()


    def ExportSingleButton(self, evt):
        drawSingleFrame(self.frame_parent)        
        
    def ExportStaticsButton(self, evt):
        drawStillImages(self.frame_parent)
             
    def ExportAVIMovieButton(self, evt):
        writeAVI(self.frame_parent)