#-----------------------------------------------------------------------------
# Copyright 2006-2008, Andre Gouws
#
# Version:        0.35 Beta
# Name :          ynicDV3D - ynic Data Viewer 3D
# Description :   multi-modal imaging visualisation toolkit
# Author :        Andre Gouws, Will Woods
# Created :       2006-October-06
# Last Update:    2008-October-22
# Notes :
#
#
# History:        windows/linux alpha 0.1 (Oct 2008)
# Dependencies:   Python 2.4.1 or later, VTK 5.0 or later (CVS 5.3+ on PPC Mac),  wxPython 2.6 or later!
# 
#
# Major Changes:  uses a main wx app unlike OS X version (pipes between processes)
#
# TODO :
#      translate major load routines from OS X version
#            - functional data
#            - surfaces
#            - MEG
#            - other (?)
#      Safe exit routine
#      mouse-tracking for mm update on planewidgets
#      TEST transform code for reference comparison (MNI/TAL)
#      treectrl resize errors- sizers?
#-----------------------------------------------------------------------------




# import usual libraries
import sys, os
import vtk
import wx
import math
import time
import random
from scipy import *
from vtk.util.colors import *
import threading
import time


# import custom modules
from dv3dImginfo import *
from dv3dNiftiReader import *
from dv3dSceneExportImport import *
from dv3dAviExporter import *
#from dv3dRenderWindowInteractor import wxVTKRenderWindowInteractor
from vtk.wx.wxVTKRenderWindowInteractor import wxVTKRenderWindowInteractor
from dv3dNifti2VtkImageData import nifti2vtkImageData
from dv3dPlanesTextPos import *
from dv3dTrackMouse import *
from dv3dKeyCapture import ProcessKey
from dv3dCoordLookups import *
from dv3dPlaneWidgets import *
from dv3dDataVolumes import *
from dv3dTreeCtrl import *
from dv3dObjectsToRender import *
from dv3dSetupNewPlanes import *
from dv3dOrthoViews import OrthoViews
from dv3dSurfaceFunctions import *
from dv3dDialogs import *
from dv3dExportRTImageStream import *
from dv3dLoadVTKPolyData import CreateVTKPolyDataSurface
from dv3dAddLight import *
from dv3dLoadPreviousSession import LoadPreviousSession

#utilities / modules for button panels
from utils import *
import globalvar as globalvar
from buttonPanel_planes import *
from buttonPanel_refvol import *
from buttonPanel_functional import *
from buttonPanel_surfaces import *
from buttonPanel_markers import *
from buttonPanel_DTIFibers import *
from buttonPanel_colours import *
from buttonPanel_export import *
from buttonPanel_MEG import *
from buttonPanel_Threads import *

from common_functions import *

class ProcessKeyRoutine(ProcessKey):
    def __init__(self, parent, frame_parent):
        ProcessKey.__init__(self, parent, frame_parent)

class PlanesPage(PlanesTab):
    def __init__(self, parent, frame_parent):
        PlanesTab.__init__(self, parent, frame_parent)

class FunctionalPage(FunctionalTab):
    def __init__(self, parent, frame_parent):
        FunctionalTab.__init__(self, parent, frame_parent)

class SurfacesPage(SurfacesTab):
    def __init__(self, parent, frame_parent):
        SurfacesTab.__init__(self, parent, frame_parent)

class MarkersPage(MarkersTab):
    def __init__(self, parent, frame_parent):
        MarkersTab.__init__(self, parent, frame_parent)

class ColoursPage(ColoursTab):
    def __init__(self, parent, frame_parent):
        ColoursTab.__init__(self, parent, frame_parent)

class ExportPage(ExportTab):
    def __init__(self, parent, frame_parent):
        ExportTab.__init__(self, parent, frame_parent)

class MEGPage(MEGTab):
    def __init__(self, parent, frame_parent):
        MEGTab.__init__(self, parent, frame_parent)

class DTIFiber_page(DTIFiberTab):
    def __init__(self, parent, frame_parent):
        DTIFiberTab.__init__(self, parent, frame_parent)
        
class Threads_page(ThreadsTab):
    def __init__(self, parent, frame_parent):
        ThreadsTab.__init__(self, parent, frame_parent)

class REFVolPage(RefTab):
    def __init__(self, parent, frame_parent):
        RefTab.__init__(self, parent, frame_parent)


class DataObjectTree(CreateObjectTree):
    def __init__(self, parent, frame_parent):
        CreateObjectTree.__init__(self, parent, frame_parent)



#path to the talairach volume
tal_file_to_load = './DV3D_essentials/talairach.nii.gz'
tal_lookup_list = './DV3D_essentials/talairach_labels.txt'


# global lists / variables required to hold data away from vtk routines for threading purposes
thread_input_data = []
thread_output_data = []
parent_frame = ''

###################################################################################


# example test code do demonstrate the power of threading
class StartupThread ( threading.Thread ):
    def run(self):
        my_file = thread_input_data[0]
        #parent_frame.SetStatusText('Processing a thread in the background ...')
        Load_OFF_File(parent_frame, parent_frame, my_file)
        #parent_frame.SetStatusText('Last thread successfully completed.')
        
        


#MAIN APPLICATION CLASS
class Layout(wx.Frame):
    def __init__(self, parent, id, title):
    
        global parent_frame
        
        ###################
        # track all processing events
        #  allows us to write out a workspace file later
        #  this array will hold the following fields:
        # 1 - internal or external data
        # 2 - path / reference to data
        # 3 - manipulation applied
        # 4 - set of values passed (comma separated string)
        self.Completed_processes = [['','','','']]

        ###################
        
        self.x = StartupThread()
        
        #create a list to hold buffered images for output to stream
        self.stream_image_list = []
        
        self.base_loaded = 0
        
        ##dialog to load our base file
        dlg = wx.FileDialog(parent, "You can choose an MRI volume file or a previous session file:", "", "", "NIFTI files (*.nii.gz)|*.nii.gz|ANALYZE header (*.hdr)|*.hdr|ANALYZE image (*.img)|*.img|DICOM volume (select 1st file in folder)|*.*|DV3D session file|*.sess", wx.OPEN)
        
        if dlg.ShowModal() == wx.ID_OK:
            file_to_load = dlg.GetPath()
            
            if file_to_load[-5:] == '.sess':
                file_to_load, source_dir = LoadPreviousSession(self, file_to_load)
            
            else:
                source_dir = dlg.GetDirectory()

                self.base_loaded = 1
        else:
            file_to_load = './DV3D_essentials/MNI_structural.nii.gz'
            source_dir = './DV3D_essentials/'
            self.base_loaded = 0
            
        
        
        #?#we need to set the planewidgets as global to initialise them outside the
        #?# main loop ... a quirk of using the vtkRenderwindowinteractor with wx
        # global planeWidgetX, planeWidgetY, planeWidgetz
        
        #empty lists to hold all objects we create
        self.ListOfObjects = []
        
        self.tmp_selected_lookup_table = 1
                
        self.my_loaded_volumes = [[0],[0],[0]] #LVD   # LoadedVolumeData - a list of vtkImageData objects returned from Nifti2VtkImageData
                                    # 1st (0) is always the base structural volume
                                    # 2nd is always the talairach volume
                                    # 3rd is always a place-holder in case a ref volume is loaded
                                    # 4.... are the overlay volumes
                                        
        #a few variables we will reference throughout the program
        self.first_load = 0 # is this load the first or 'base' image
        self.base_data_min, self.base_data_max = 0, 0
        self.ref_loaded = 0 # when we try to load a reference image .. check if we already have one
        self.ShowRefTransform = 0
        self.ShowTalTransform = 0
        self.overlay_count = 0 #allows us to track and reference extra volumes loaded later
        self.tmp_data_max = 0
        self.SYNC_ortho = 1 #allows the user to disable automatic rendering of ortho windows to improve speed
        #the following are used to output an image stream capturing real-time interaction
        self.write_imagestream_on = 0
        self.write_imagestream_count = 0
        self.write_imagestream_directory = '/tmp/'


        #the input or 'base' data set
        if self.first_load == 0:
            base_vol = create_new_volume(file_to_load,'base data', source_dir)
            self.first_load =1
            self.my_loaded_volumes[0] = [base_vol]
            #method to load the Talairach reference list automaticall on startup

            f = open(tal_lookup_list, 'rb')
            self.tal_ref_list = f.readlines()
            f.close()
            
            #load the talairach data into and array
            talairach_vol = create_new_volume(tal_file_to_load,'talairach data')
            self.first_load =1
            self.my_loaded_volumes[1] = [talairach_vol]
        else:
            vol, ign1, ign2, ign3, ign4, ign5, ign6,ign7, ign8, ign9, ign10  = nifti2vtkImageData(file_to_load)



        #------------- WX WINDOW ------------------------------------

        # -- Set up the main window with its sub-regions --
        # initialise a wx frame to act as the main app window
        wx.Frame.__init__(self, parent, id, title, size=(700,500))

        self.StatusBar = self.CreateStatusBar()
        self.status_message = ('ynicDV3D')
        self.SetStatusText(self.status_message)

        #the main window has a bakground panel and a sizer
        sizer = wx.BoxSizer(wx.HORIZONTAL)
        panel = wx.Panel(self,-1)
        #split the main window into two side by side boxes
        splitter = wx.SplitterWindow(panel)
        splitter.Bind(wx.EVT_SPLITTER_SASH_POS_CHANGED, self.midChange,id=splitter.GetId())

        #LEFT
        #add a sizer for the left side, a panel for its background
        sizer_left = wx.BoxSizer(wx.VERTICAL)
        panel_left = wx.Panel(splitter,-1)

        #split it vertically and add panels for the top and bottom
        splitter_left = wx.SplitterWindow(panel_left, style=1)
        splitter_left.Bind(wx.EVT_SPLITTER_SASH_POS_CHANGED,self.leftChange,id=splitter_left.GetId())

        panel_left_upper = wx.Panel(splitter_left,style= wx.NO_BORDER)
        panel_left_upper.SetBackgroundColour("WHITE")

        self.panel_left_lower = wx.Panel(splitter_left,style= wx.NO_BORDER)
        splitter_left.SplitHorizontally(panel_left_upper,self.panel_left_lower)
        sizer_left.Add(splitter_left,1,wx.EXPAND)

        #RIGHT
        #add a sizer for the rigth side, a panel for its background
        sizer_right = wx.BoxSizer(wx.VERTICAL)
        panel_right = wx.Panel(splitter,-1)

        #split it vertically and add panels for the top and bottom
        splitter_right =wx.SplitterWindow(panel_right)
        splitter_right.Bind(wx.EVT_SPLITTER_SASH_POS_CHANGED, self.rightChange,id=splitter_right.GetId())
        panel_right_upper = wx.Panel(splitter_right,style= wx.NO_BORDER)



        # -------- Set up the objects with populate each of the sub-regions --
        # Top left has logo(?)
        # Top right has the main button panel - a notebook with multiple tabs
        # Bottom Left has a Tree ctrl which holds all loaded objects
        # Bottom Right hold the VTK window


        # a text box to display messages and coords in
        self.textCtrl1 = wx.TextCtrl(id=-1, name='msgBox1',
               parent=panel_left_upper, pos=wx.Point(0, 0), size = wx.Size(600,600),
               style=wx.TE_MULTILINE|wx.NO_BORDER, value='')
        self.textCtrl1.SetHelpText('')
        self.textCtrl1.SetFont(wx.Font(7, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              'Arial'))


        # -------- Main Button Panel - Top right --------
        # the notebook object
        self.MainButtonNotebook = wx.Notebook(id=-1, name='self.MainButtonNotebook',
              parent=panel_right_upper, pos=wx.Point(0, 0), style=0)

        #1.) manipulating the main image planes
        self.planes_page = PlanesPage(self.MainButtonNotebook, self)
        self.MainButtonNotebook.AddPage(self.planes_page, "Planes")

        #2.) load a volume to reference against int real time
        self.ref_page = REFVolPage(self.MainButtonNotebook, self)
        self.MainButtonNotebook.AddPage(self.ref_page, "Reference")

        #3.) loading functional data
        self.functional_page = FunctionalPage(self.MainButtonNotebook, self)
        self.MainButtonNotebook.AddPage(self.functional_page, "Functional")

        #4.) loading surface files
        self.surfaces_page = SurfacesPage(self.MainButtonNotebook, self)
        self.MainButtonNotebook.AddPage(self.surfaces_page, "Surfaces")

        #9.) DTI-Fiber data
        self.DTIFiber_page = DTIFiber_page(self.MainButtonNotebook, self)
        self.MainButtonNotebook.AddPage(self.DTIFiber_page, "Example: DTI Fibers")

        #10.) Threads_example
        self.Threads_page = Threads_page(self.MainButtonNotebook, self)
        self.MainButtonNotebook.AddPage(self.Threads_page, "Example: Threading")


        ##5.) placing markers
        #self.markers_page = MarkersPage(self.MainButtonNotebook, self)
        #self.MainButtonNotebook.AddPage(self.markers_page, "Markers")
        #
        ##6.) manipulating colours
        #self.colours_page = ColoursPage(self.MainButtonNotebook, self)
        #self.MainButtonNotebook.AddPage(self.colours_page, "Colours")

        #7.) export routines
        self.export_page = ExportPage(self.MainButtonNotebook, self)
        self.MainButtonNotebook.AddPage(self.export_page, "Export")

        #8.) YNiC MEG
        self.MEG_page = MEGPage(self.MainButtonNotebook, self)
        self.MainButtonNotebook.AddPage(self.MEG_page, "MEG")


        # Set the sizer for the main button panel and give it a background
        sizer_panel_ru = wx.GridSizer(rows = 1, cols = 1)
        sizer_panel_ru.Add(self.MainButtonNotebook, 0, wx.EXPAND)
        panel_right_upper.SetSizer(sizer_panel_ru)


        # END Main Button Panel --------


        panel_right_lower = wx.Panel(splitter_right,style= wx.BORDER_SUNKEN)
        panel_right_lower.SetBackgroundColour("RED")
        splitter_right.SplitHorizontally(panel_right_upper,panel_right_lower)
        sizer_right.Add(splitter_right,1,wx.EXPAND)

        sizer_panel_rl = wx.GridSizer(rows = 1, cols = 1)
        panel_right_lower.SetSizer(sizer_panel_rl)        
        
        panel_right_upper.SetSizer(sizer_panel_ru)        
        splitter.SplitVertically(panel_left,panel_right)
        sizer.Add(splitter,1,wx.EXPAND)
        panel.SetSizer(sizer)
        panel_left.SetSizer(sizer_left)
        panel_right.SetSizer(sizer_right)

        self.splitter = splitter        
        self.splitter_left = splitter_left
        self.splitter_right = splitter_right
        self.splitter.SetMinimumPaneSize(150)
        self.splitter_left.SetMinimumPaneSize(135)
        self.splitter_right.SetMinimumPaneSize(135)
        
        self.splitter_left.SetSashPosition(135)
        self.splitter_right.SetSashPosition(135)
        self.splitter.SetSashPosition(150)
        # END OF WX STUFF



        #------------- VTK WINDOW ------------------------------------
        #the interactor
        self.widget = wxVTKRenderWindowInteractor(panel_right_lower ,-1)
        
        self.boxWidget1 = vtk.vtkBoxWidget()
        self.boxWidget1.SetPriority(1.0)
        self.boxWidget1.SetInteractor(self.widget)
        self.boxWidget1.SetKeyPressActivationValue('V')
        self.boxWidget1.SetPlaceFactor(1.25)
        
        self.interactor_style = vtk.vtkInteractorStyleTrackballCamera()
        self.widget.SetInteractorStyle(self.interactor_style)

        #allow key bindings to be sent to the interactor
        wx.EVT_CHAR(self.widget, self.myKeyEvents)
        #self.widget.AddObserver("KeyPressEvent", self.myKeyEvents)
        self.widget.AddObserver("MouseMoveEvent", self.myTimerEvents)
        for i in range(200):
            self.widget.UnregisterHotKey(i)

        # The shared picker enables us to use 3 planes at one time
        # and gets the picking order right
        self.picker = vtk.vtkCellPicker()
        self.picker.SetTolerance(0.005)
    
        #add a safe exit routine
        self.widget.AddObserver("ExitEvent", lambda o,e,f=Layout: sys.exit())

        #define the vtk renderer to do the drawing
        self.ren = vtk.vtkRenderer()
        ##self.ren.GetActiveCamera().ParallelProjectionOn()
        #self.ren.SetBackground(self.bg_cols[self.bg_col_index])

        #add the renderwindowinteractor to the wx application
        sizer_panel_rl.Add(self.widget, 0, wx.EXPAND)

        #tell the renderer to draw the widget's output
        self.widget.GetRenderWindow().AddRenderer(self.ren)

        #now enable and initialise the vtk components
        self.widget.Enable(1)
        
        #the base image planes x, y and z
        base_vol = self.my_loaded_volumes[0][0].volume_data.GetOutput()

        #prepare the initial planes - TODO- see 2x comments below
        planes_setup(self, file_to_load, 'base')

        # we may want to reference this later to reset
        self.original_LU_table = self.ListOfObjects[0].GetLookupTable()
        
        self.ListOfObjects[0].SetLookupTable(self.original_LU_table)
        self.ListOfObjects[1].SetLookupTable(self.original_LU_table)
        self.ListOfObjects[2].SetLookupTable(self.original_LU_table)

        self.ListOfObjects[0].SetSliceIndex(self.my_loaded_volumes[0][0].x_slice_pos,)
        self.ListOfObjects[1].SetSliceIndex(self.my_loaded_volumes[0][0].y_slice_pos,)
        self.ListOfObjects[2].SetSliceIndex(self.my_loaded_volumes[0][0].z_slice_pos,)        

        #Add a Tree Control object to hold all the loaded data objects for later
        # interaction
        DataObjectTree(self.panel_left_lower, self)
            
        #clean up any children if the app closes
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)

        #create 3 plane widgets for the ortho planes
        
        self.slice_pos = self.my_loaded_volumes[0][0].x_slice_pos, \
            self.my_loaded_volumes[0][0].y_slice_pos, \
            self.my_loaded_volumes[0][0].z_slice_pos
        
        #routine for preparing a window with automatic orthogonal views of  the main 3d-window
        self.ortho_planes = []
        self.ortho_window = OrthoViews(self)#, plane1, plane2, plane3)
        
        parent_frame = self
        parent_frame.Update()

        if self.base_loaded == 0:
            self.ListOfObjects[0].Off()
            self.ListOfObjects[1].Off()
            self.ListOfObjects[2].Off()
            self.ortho_window.plane1.Off()
            self.ortho_window.plane2.Off()
            self.ortho_window.plane3.Off()
            self.ortho_window.widget1.Render()
            self.ortho_window.widget2.Render()
            self.ortho_window.widget3.Render()

        align_all_planes(self)
        
        #code to initialise real-time image streaming
        self.w2i = vtk.vtkWindowToImageFilter()
        self.w2i.SetInput(self.ren.GetRenderWindow())
        self.writer = vtk.vtkJPEGWriter()
        self.writer.SetInput(self.w2i.GetOutput())
        
        #add some lights to the scene - improves transparency rendering
        # on 3d objects
        AddMainLights(self)

        #for structural only .. ignore values below 0 ?? will this need changing?
        lut_min =  0
        lut_max =  self.original_LU_table.GetTableRange()[1]
        try:
            self.original_LU_table.SetTableValue(0,(0.0,0.0,0.0,1.0))
            self.original_LU_table.SetTableRange(lut_min, lut_max)
            self.original_LU_table.Build()
            
        except:
            pass #todo fix!


        # ? redundant ? 
        ## a quick auto-resize to size all the subwindows
        #self.leftChange('evt')
        #self.midChange('evt')
        #self.rightChange('evt')
        
        
        ###########
        ###TEST CODE ONLY
        
        #write actions so far to processing array
        # 1 - internal or external data
        # 2 - path / reference to data
        # 3 - manipulation applied
        # 4 - set of values passed (comma separated string)
        self.Completed_processes[0] = ['ext',file_to_load,'base volume',str(self.base_loaded)]
        
        
        ###########
    
    
    #------------
    #Functions for interaction in the main window
    
    def OnCloseWindow(self, event):
        sys.exit()
        #todo - more elegant exit routine
    
    
    def ChooseFile(self, my_filetypes):
        dlg = wx.FileDialog(self, "Choose file:", './DV3D_examples', "", my_filetypes, wx.OPEN)
        if dlg.ShowModal() == wx.ID_OK:
            path = dlg.GetPath()
            return path


    def myTimerEvents(self,  *args, **kwargs):
        self.SetStatusText(self.status_message)
        
                    
    
    def myKeyEvents(self,  event):

        # disable some of the native behaviours of key-bindins in vtk
        keycode = (event.GetKeyCode())
        self.key = chr(keycode)

        if self.key == 'l':
            AddLightToActor(self, self.ListOfObjects[-1])
            

        if self.key == 'm':
            my_file = ChooseFile(self, '*.off')
            thread_input_data.append(my_file)
            self.x.start()
            self.status_message = 'Thread running in the background ...'


        #V2 TEST CODE - import and export an entire scene 
        #if self.key == 'x':
        #    exportScene(self)
        #    self.widget.Render()
        #    
        #if self.key == 'o':
        #    importScene(self)
        #    self.widget.Render()
            

        modifiers = event.HasModifiers()
        if keycode < 256:
            key = chr(keycode)
            #save only the native behaviours of these:            
            if key in ['V','3', 'r', 's', 'w', 't', 'j', 'p', 'i']:
                event.Skip()
                return

        #? redundant now?
        #self.key=self.widget.GetKeyCode()
        #ProcessKeyRoutine(self.MainButtonNotebook, self)
        
            
    # track the mouse interaction with gthe planes and ouput the slice number, mm and ref details if loaded
    def MouseTracker(self, *args, **kwargs):
        
        # first use a routine to update the ortho-windows to the current view
        align_all_planes(self)
        
        #scan the list and find groups of planes
        
        if  self.ListOfObjects[0].GetCursorDataStatus() == 1:
            self.cursor_curr_slice_num =  self.ListOfObjects[0].GetCurrentCursorPosition()
            display_coords(self, self)

        elif  self.ListOfObjects[1].GetCursorDataStatus() == 1:
            self.cursor_curr_slice_num =  self.ListOfObjects[1].GetCurrentCursorPosition()
            display_coords(self, self)

        elif  self.ListOfObjects[2].GetCursorDataStatus() == 1:
            self.cursor_curr_slice_num =  self.ListOfObjects[2].GetCurrentCursorPosition()
            display_coords(self, self)

        else:
            return
    
    #control routines for the sub-window sizers - these make sure
    # that if we resize the left the right resizes to the same
    ## weird? - have to loop twice and tell each object to load
    ## it own parameters otherwise panels dont size properly(?)
    def leftChange(self, event):
        for i in range(2):
            pos = self.splitter_left.GetSashPosition()
            self.splitter_right.SetSashPosition(pos)
            pos = self.splitter_right.GetSashPosition()
            self.splitter_left.SetSashPosition(pos)
            #self.tree.SetSize(self.treepanel.GetSize())
            #self.treepanel.Refresh()

    def midChange(self, event):
        for i in range(2):
            pos = self.splitter.GetSashPosition()
            self.splitter.SetSashPosition(pos)
            pos = self.splitter_left.GetSashPosition()
            self.splitter_right.SetSashPosition(pos)
            pos = self.splitter_right.GetSashPosition()
            self.splitter_left.SetSashPosition(pos)
            self.tree.SetSize(self.treepanel.GetSize())
            self.treepanel.Refresh()

    def rightChange(self, event):
        for i in range(2):
            pos = self.splitter_right.GetSashPosition()
            self.splitter_left.SetSashPosition(pos)
            pos = self.splitter_left.GetSashPosition()
            self.splitter_right.SetSashPosition(pos)
            self.tree.SetSize(self.treepanel.GetSize())
            self.treepanel.Refresh()


#The main application loop
app = wx.App(0)
k = Layout(None, -1, 'DV3D Beta 0.35 (c) YNiC 2008 - Main application window')
k.Show(True)
k.SetSize((800,600)) #HACK for OSX: have to resize the window on startup to make the vtk window visible
app.MainLoop()
