import vtk
from vtk import *
 
#setup points and vertices
Points = vtk.vtkPoints()

Points2 = vtk.vtkPoints()

 
id = Points.InsertNextPoint(1.0, 0.0, 0.0)
Points2.InsertNextPoint(1.0, 0.0, 1.0)

id = Points.InsertNextPoint(0.0, 0.0, 0.0)
Points2.InsertNextPoint(0.0, 0.0, 1.0)

id = Points.InsertNextPoint(0.0, 1.0, 0.0)
Points2.InsertNextPoint(0.0, 1.0, 1.0)


Triangles = vtk.vtkCellArray()

Triangle = vtk.vtkTriangle();
Triangle.GetPointIds().SetId(0, 0);
Triangle.GetPointIds().SetId(1, 1);
Triangle.GetPointIds().SetId(2, 2);
Triangles.InsertNextCell(Triangle);


Triangles2 = vtk.vtkCellArray()

Triangle2 = vtk.vtkTriangle();
Triangle2.GetPointIds().SetId(0, 0);
Triangle2.GetPointIds().SetId(1, 1);
Triangle2.GetPointIds().SetId(2, 2);
Triangles2.InsertNextCell(Triangle2);



#setup colors
Colors = vtk.vtkUnsignedCharArray()
Colors.SetNumberOfComponents(4)
Colors.SetName("Colors")
Colors.InsertNextTuple4(255,0,0,255)
Colors.InsertNextTuple4(0,255,0,200)
Colors.InsertNextTuple4(0,0,255,145)

polydata = vtk.vtkPolyData()
polydata.SetPoints(Points)
polydata.SetPolys(Triangles)
polydata.GetPointData().SetScalars(Colors)
polydata.Modified()

pdm = vtk.vtkPolyDataMapper()
pdm.SetInput(polydata)

act = vtk.vtkActor()
act.SetMapper(pdm)
act.GetProperty().SetOpacity(0.999)

polydata2 = vtk.vtkPolyData()
polydata2.SetPoints(Points2)
polydata2.SetPolys(Triangles2)
polydata2.Modified()

pdm2 = vtk.vtkPolyDataMapper()
pdm2.SetInput(polydata2)

act2 = vtk.vtkActor()
act2.SetMapper(pdm2)
act2.GetProperty().SetOpacity(0.999)


renWin = vtk.vtkRenderWindow()
ren = vtk.vtkRenderer()
ren.SetBackground((1.0,1.0,1.0))
renWin.AddRenderer(ren)
renWin.SetSize(480,480)
iren = vtk.vtkRenderWindowInteractor()
iren.SetRenderWindow(renWin)


ren.AddActor(act)
ren.AddActor(act2)

ren.GetCullers().GetLastItem().SetSortingStyleToBackToFront()


iren.Initialize()
renWin.Render()
iren.Start()
