from PyQt4.QtCore import *
from PyQt4.QtGui import *

from fsFlatColorTools import *

def refreshColourPanel(parent, correspondingDataSet):
    dataToUpdate = parent.loadedSurfaceTracker[correspondingDataSet].meta

    lowColour = dataToUpdate['lutHSVAStartColor']
    lowQColor = QColor((0,0,0)) # temp instantiation
    lowQColor.setHsvF(lowColour[0], lowColour[1], lowColour[2], 1.0)
    updateFrameColour(parent.FrameStartColour, lowQColor)  

    highColour = dataToUpdate['lutHSVAEndColor']
    highQColor = QColor((0,0,0))#temp instantiation
    highQColor.setHsvF(highColour[0], highColour[1], highColour[2], 1.0)
    updateFrameColour(parent.FrameEndColour, highQColor)

    parent.lineEditDataMin.setText(str(dataToUpdate['lutVisibleScalarRange'][0]))
    parent.lineEditDataMax.setText(str(dataToUpdate['lutVisibleScalarRange'][1]))
    parent.lineEditDataOpacityMin.setText(str(dataToUpdate['lutHSVAStartColor'][-1]))
    parent.lineEditDataOpacityMax.setText(str(dataToUpdate['lutHSVAEndColor'][-1]))

    if dataToUpdate['lutBinary'] ==  False:
        parent.pushButtonBinariseLUT.setChecked(0)
        parent.pushButtonBinariseLUT.setText('Values below min = transparent')  
    else:
        parent.pushButtonBinariseLUT.setChecked(1)
        parent.pushButtonBinariseLUT.setText('Values below min = same colour as min')

