import vtk

def generateLUT(HSVA_start, HSVA_end, lutVisibleScalarRange, zeroAlphaMinValue=1):
    #create a lookupTbale for the curv data
    print 'asked to update colour LUT with values\n%s\n%s' %(HSVA_start, HSVA_end)
    print lutVisibleScalarRange 
    lut = vtk.vtkLookupTable()
    lut.SetNumberOfTableValues(256)
    lut.SetHueRange(HSVA_start[0], HSVA_end[0])
    lut.SetSaturationRange(HSVA_start[1], HSVA_end[1])
    lut.SetValueRange(HSVA_start[2], HSVA_end[2])
    lut.SetAlphaRange(HSVA_start[3], HSVA_end[3])
    lut.SetTableRange(lutVisibleScalarRange[0], lutVisibleScalarRange[1])
    lut.Build()
    if zeroAlphaMinValue == 1:
        lut.SetTableValue(0,(0.0,0.0,0.0,0.0))

    return lut
