from numpy import *
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from fsFlatGenerateLUT import generateLUT
import vtk


def ColourMapClip(parent, same_or_transp):
    selectedDataIndex = parent.listWidget.item(parent.listWidget.currentRow()).my_index_tracker
    curr_meta = parent.loadedSurfaceTracker[selectedDataIndex].meta
    HSVA_start = curr_meta['lutHSVAStartColor']
    HSVA_end = curr_meta['lutHSVAEndColor']
    lutVisibleScalarRange = curr_meta['lutVisibleScalarRange']
    if same_or_transp == 1:
        curr_meta['lutBinary'] = False
        newLut = generateLUT(HSVA_start, HSVA_end, lutVisibleScalarRange, same_or_transp)
    else:
        curr_meta['lutBinary'] = True
        newLut = generateLUT(HSVA_start, HSVA_end, lutVisibleScalarRange, same_or_transp)           
    curr_meta = parent.loadedSurfaceTracker[selectedDataIndex].GetMapper().SetLookupTable(newLut)
    parent.loadedSurfaceTracker[selectedDataIndex].Modified()
    parent.ren.Render()


def updateScalarRange(parent, correspondingDataSet, newScalarRange):
    dataToUpdate = parent.loadedSurfaceTracker[correspondingDataSet].meta
    
    same_or_transp = dataToUpdate['lutBinary']
    zeroAlphaMinValue = -(same_or_transp)+1 #hack to flip True/False

    #needed later     
    startOpacity = dataToUpdate['lutHSVAStartColor'][-1]
    endOpacity = dataToUpdate['lutHSVAEndColor'][-1]
  
    dataToUpdate['lutVisibleScalarRange'] = newScalarRange
    newLut = generateLUT(dataToUpdate['lutHSVAStartColor'], dataToUpdate['lutHSVAEndColor'], dataToUpdate['lutVisibleScalarRange'], zeroAlphaMinValue)    
    parent.loadedSurfaceTracker[correspondingDataSet].GetMapper().SetLookupTable(newLut)

    #make sure we revert to the original opacity settings the user wanted
    #unfortunately this means redrawing the lut with corrected alpha values
    updateAlphas(parent, correspondingDataSet, startOpacity, endOpacity)
    parent.loadedSurfaceTracker[correspondingDataSet].Modified()    
    parent.ren.Render()


def updateSelectedColours(parent, correspondingDataSet, LowerOrUpper, newRGBA, newHSVA):
    dataToUpdate = parent.loadedSurfaceTracker[correspondingDataSet].meta

    same_or_transp = dataToUpdate['lutBinary']
    zeroAlphaMinValue = -(same_or_transp)+1 #hack to flip True/False

    #needed later     
    startOpacity = dataToUpdate['lutHSVAStartColor'][-1]
    endOpacity = dataToUpdate['lutHSVAEndColor'][-1]

    #get the LUT
    if LowerOrUpper == 'Lower':

        newLut = generateLUT(newHSVA, dataToUpdate['lutHSVAEndColor'], dataToUpdate['lutVisibleScalarRange'], zeroAlphaMinValue)
        dataToUpdate['lutRGBAStartColor'] = newRGBA
        dataToUpdate['lutHSVAStartColor'] = newHSVA

    elif LowerOrUpper == 'Upper':

        newLut = generateLUT(dataToUpdate['lutHSVAStartColor'], newHSVA, dataToUpdate['lutVisibleScalarRange'], zeroAlphaMinValue)
        dataToUpdate['lutRGBAEndColor'] = newRGBA
        dataToUpdate['lutHSVAEndColor'] = newHSVA


    else:
        print 'problem here'

    parent.loadedSurfaceTracker[correspondingDataSet].GetMapper().SetLookupTable(newLut)

    #make sure we revert to the original opacity settings the user wanted
    #unfortunately this means redrawing the lut with corrected alpha values
    updateAlphas(parent, correspondingDataSet, startOpacity, endOpacity)
    parent.loadedSurfaceTracker[correspondingDataSet].Modified()


def updateAlphas(parent, correspondingDataSet, newAlphaLow, newAlphaHigh):
    dataToUpdate = parent.loadedSurfaceTracker[correspondingDataSet].meta

    same_or_transp = dataToUpdate['lutBinary']
    zeroAlphaMinValue = -(same_or_transp)+1 #hack to flip True/False
    
    newRGBAStart = dataToUpdate['lutRGBAStartColor']
    newRGBAStart[-1] = float(newAlphaLow)
    newRGBAEnd = dataToUpdate['lutRGBAEndColor']
    newRGBAEnd[-1] = float(newAlphaHigh)

    newHSVAStart = dataToUpdate['lutHSVAStartColor']
    newHSVAStart[-1] = float(newAlphaLow)
    newHSVAEnd = dataToUpdate['lutHSVAEndColor']
    newHSVAEnd[-1] = float(newAlphaHigh)

    newLut = generateLUT(newHSVAStart, newHSVAEnd, dataToUpdate['lutVisibleScalarRange'],zeroAlphaMinValue)

    dataToUpdate['lutRGBAStartColor'] = newRGBAStart
    dataToUpdate['lutHSVAStartColor'] = newHSVAStart
    dataToUpdate['lutRGBAEndColor'] = newRGBAEnd
    dataToUpdate['lutHSVAEndColor'] = newHSVAEnd

    parent.loadedSurfaceTracker[correspondingDataSet].GetMapper().SetLookupTable(newLut)
    parent.loadedSurfaceTracker[correspondingDataSet].Modified()


def selectNewColour(parent, selectedGUIobject, correspondingDataSet, LowerOrUpper):
    pickedColour = pickColour(parent)
    newRGB = list(pickedColour.getRgbF())
    newHSV = list(pickedColour.getHsvF())
    updateFrameColour(selectedGUIobject, pickedColour)

    updateSelectedColours(parent, correspondingDataSet, LowerOrUpper, newRGB, newHSV)
    


def pickColour(parent):
    newColour = QColorDialog.getColor(QColor( 0, 0, 255 ), parent)
    #print newColour.getHsv()
    #print newColour.getRgb()
    #print newColour.getHsvF()
    #print newColour.getRgbF()
    return newColour


def updateFrameColour(theFrame, theQColor):
    palette = theFrame.palette();
    palette.setColor( theFrame.backgroundRole(), theQColor );
    palette.setColor( theFrame.foregroundRole(), theQColor );
    theFrame.setPalette( palette );
    theFrame.setAutoFillBackground(True);   


def changeMainWindowBackground(parent):
    newColour = pickColour(parent)
    parent.ren.SetBackground(newColour.getRgbF()[0:3])
    parent.ren.Render()

