# core libs
import os,sys
from PyQt4.QtCore import *
from PyQt4.QtGui import *
import vtk

#gui stuff
import fsFlatPy_ui as fs_ui
from fsFlatVTKFrameGui import QVtkInteractorWidget
from fsFlatColorTools import *
from fsFlatRefreshCurrentData import *


#data handlers
from loadFsFlatAnatomy import loadFsFlatAnatomy
from loadFsOverlay import loadFsOverlay


def handleActions(parent):
    parent.loadOverlayButton.connect(parent.loadOverlayButton, SIGNAL("released()"), parent.LoadNewOverlay) #not sure why 'clicked' gives a double hit here

    parent.pushButtonRGBA.connect(parent.pushButtonRGBA, SIGNAL("released()"), parent.processRGBA)

    parent.pushButtonBinariseLUT.connect(parent.pushButtonBinariseLUT, SIGNAL("released()"), parent.toggleBinary)

    parent.pushButton2D3Dswitch.connect(parent.pushButton2D3Dswitch, SIGNAL("released()"), parent.toggle2D3D)

    parent.connect(parent.listWidget, SIGNAL("currentRowChanged()"), parent.PrintList)

    parent.listWidget.doubleClicked.connect(parent.ItemVisibilityToggled)

    parent.listWidget.currentRowChanged.connect(parent.UpdateCurrentItem)

    #NB custom handler written here to capture list order changes: see fsFlatQListWidgetFix.py
    parent.listWidget.connect(parent.listWidget, SIGNAL("orderChanged()"), parent.orderChanged)

    parent.pushButtonStartColour.connect(parent.pushButtonStartColour, SIGNAL("released()"), parent.newColourMapLower)

    parent.pushButtonEndColour.connect(parent.pushButtonEndColour, SIGNAL("released()"), parent.newColourMapUpper)

    parent.lineEditDataOpacityMin.editingFinished.connect(parent.MinOpacityChanged)

    parent.lineEditDataOpacityMax.editingFinished.connect(parent.MaxOpacityChanged)

    parent.lineEditDataMin.editingFinished.connect(parent.DataRangeChanged)

    parent.lineEditDataMax.editingFinished.connect(parent.DataRangeChanged)

    parent.checkBoxJointOpacity.clicked.connect(parent.JointOpacityChanged)

    parent.pushButtonChangeBackgroundColour.connect(parent.pushButtonChangeBackgroundColour, SIGNAL("released()"), parent.changeBackground)


