#!/usr/bin/python
#dv3d_gui_Callbacks.py
#link main window gui items to their callback functions
#DV3D refactor 2
#AG 26/07/2013

#import core libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *

#and our own functions
from dv3d_gui_ColorPicker import dv3d_gui_ColorPicker
from dv3d_gui_FileDialogs import *
from dv3d_data_LoadNiftiVolume_Planes import *
from dv3d_data_UpdatePlanes import *
from dv3d_data_UpdateSurfaces import *
from dv3d_data_UpdateSurfaceGroups import *
from dv3d_data_Sync3Dand2DPlanes import *
from dv3d_data_ChangeViews import *
from dv3d_data_Surfaces import *
from dv3d_gui_updateCurrentInteractions import *
from dv3d_export_SaveLargeImage import *
from dv3d_data_updateAllViews import *

#for auto i/o
# import is different so that I can reload the auto script on the fly
##from dv3d_io_autoScript import runAutoScripts
import dv3d_io_autoScript


## -----------------------------------------------
# first we link each button/widget to its function
def dv3d_gui_Callbacks(the_parent_window):

    tpw = the_parent_window #for brevity

    ## old nomenclature for event bindings: keep for legacy issues
    #QObject.connect(tpw.pushButtonBackgroundColour, SIGNAL("clicked()"), lambda:cb_BackgrounColour(tpw))

    # new form of event binding
    # list manipulations
    tpw.ItemList_QTreeWidget.itemChanged.connect(lambda:cb_TreeWidget_ItemChanged(tpw))
    tpw.ItemList_QTreeWidget.itemSelectionChanged.connect(lambda:cb_TreeWidget_ItemChanged(tpw))
    # buttons
        # planes/views
    tpw.pushButtonResetPlanes.released.connect(lambda:cb_ResetPlanes(tpw))  
    tpw.pushButtonResetView.released.connect(lambda:cb_ViewFrom(tpw))  
    tpw.pushButtonLoadDataForPlanes.released.connect(lambda:cb_LoadDataForPlanes(tpw))  
    tpw.pushButtonBackgroundColour.released.connect(lambda:cb_BackgrounColour(tpw))
    tpw.pushButtonTogglePlaneEdges.released.connect(lambda:cb_ToggleAllPlaneEdges(tpw))
    tpw.pushButtonOrthoBackgroundColor.released.connect(lambda:cb_OrthoBackgrounColour(tpw))


        # surfaces
    tpw.pushButtonLoadSurface.released.connect(lambda:cb_LoadDataForSurface(tpw))
    tpw.pushButtonGenerateSurface.released.connect(lambda:cb_GenerateSingleSurface(tpw))
    tpw.pushButtonGenerateMultiSurfaces.released.connect(lambda:cb_GenerateMultiSurfaces(tpw))

        # combo boxes
    tpw.comboBoxViewFrom.currentIndexChanged.connect(lambda:cb_ViewFrom(tpw))  
    tpw.comboBoxViewType.currentIndexChanged.connect(lambda:cb_ViewType(tpw))  

        # exports
    tpw.pushButtonExport3dWindow.released.connect(lambda:cb_Export3dWindow(tpw))

        # autoScripting
    tpw.pushButtonAutoScript.released.connect(lambda:cb_RunAutoScript(tpw))
    tpw.pushButtonAutoScriptReload.released.connect(lambda:cb_ReloadAutoScript(tpw))


## -----------------------------------------------
# and here we define the functions

def cb_RunAutoScript(tpw):
    dv3d_io_autoScript.runAutoScripts(tpw);

def cb_ReloadAutoScript(tpw):
    reload(dv3d_io_autoScript);

def cb_GenerateMultiSurfaces(tpw):
    dv3d_data_Surfaces_generateMultiSurfaces(tpw)
    dv3d_data_updateAllViews(tpw)

def cb_Export3dWindow(tpw):
    dv3d_export_SaveLargeImage(tpw)
    dv3d_data_updateAllViews(tpw)

def cb_GenerateSingleSurface(tpw):
    dv3d_data_Surfaces_generateSingleSurface(tpw)
    dv3d_data_updateAllViews(tpw)

def cb_ToggleAllPlaneEdges(tpw):
    dv3d_data_TogglePlane_Edges(tpw)
    dv3d_data_updateAllViews(tpw)

def cb_ViewType(tpw):
    ChangePerspectiveRendering(tpw)
    dv3d_data_updateAllViews(tpw)

def cb_ViewFrom(tpw):
    Change3DCameraView(tpw)


def cb_ResetPlanes(tpw):
    ResetPlaneOrientations(tpw)
    dv3d_data_updateAllViews(tpw)

#pick a color dialog
def cb_BackgrounColour(tpw):
    newColor = dv3d_gui_ColorPicker()
    if newColor != 'None':
        tpw.ren3d.SetBackground(newColor)
        tpw.iwidget_3d.interactor.GetRenderWindow().Render()

def cb_OrthoBackgrounColour(tpw):
    newColor = dv3d_gui_ColorPicker()
    if newColor != 'None':
        tpw.ren1.SetBackground(newColor)
        tpw.ren2.SetBackground(newColor)
        tpw.ren3.SetBackground(newColor)
        tpw.iwidget_2dX.interactor.GetRenderWindow().Render()
        tpw.iwidget_2dY.interactor.GetRenderWindow().Render()
        tpw.iwidget_2dZ.interactor.GetRenderWindow().Render()
    dv3d_data_updateAllViews(tpw)

# load planes data
def cb_LoadDataForSurface(tpw, fileToLoad=None, Color=None, Opacity=None, Solid=None):
    tpw.currentlyLoading = 1
    #first get the file
    if fileToLoad == None:
        thisFile = dv3dFileOpen(tpw, "VTK Suface files (*.vtk)") #Nifti (*.nii *.img)\n
        #TODO - add obj, vrml and others?
        if thisFile != None:
            dv3d_data_LoadSurface(tpw, thisFile)
    else:
        #auto loading
        dv3d_data_LoadSurface(tpw, fileToLoad)
    tpw.currentlyLoading = 0
    dv3d_data_updateAllViews(tpw)

# load planes data
def cb_LoadDataForPlanes(tpw, fileToLoad=None):
    tpw.currentlyLoading = 1
    #first get the file
    if fileToLoad == None:
        thisFile = dv3dFileOpen(tpw, "Nifti GZ (*.nii.gz)") #Nifti (*.nii *.img)\n
        if thisFile != None:
            dv3d_data_LoadNiftiVolume_Planes(tpw, thisFile)
    else:
            dv3d_data_LoadNiftiVolume_Planes(tpw, fileToLoad)
    tpw.currentlyLoading = 0
    dv3d_data_updateAllViews(tpw)


# list item has physically changed .. check if we need to turn data on / off
def cb_TreeWidget_ItemChanged(tpw):
    if tpw.currentlyLoading == 0:
        #get the type of item as we labelled it
        d_type = tpw.ItemList_QTreeWidget.currentItem().dv3dDataType

        #print d_type

        #plane data
        if d_type == 'planes':
            dv3d_gui_updateCurrentInteractions(tpw, 'planes')  
            dv3d_data_TogglePlanes_fromList_single(tpw)
        
        elif d_type == 'PlanesHeader':
            if len(tpw.Planes) > 0:
                dv3d_data_TogglePlanes_fromList_all(tpw)
            else:
                print 'No plane data currently loaded - nothing to turn on/off! ...'
                tpw.ItemList_QTreeWidget.topLevelItem(0).setCheckState(0, Qt.CheckState(0))

        
        #surface data       
        elif d_type == 'surface':
            dv3d_gui_updateCurrentInteractions(tpw, 'surfaces')
            dv3d_data_ToggleSurfaces_fromList_single(tpw)
        
        elif d_type == 'SurfacesHeader':
            if len(tpw.Surfaces) > 0:
                dv3d_data_ToggleSurfaces_fromList_all(tpw)
            else:
                print 'No surface data currently loaded - nothing to turn on/off! ...'
                tpw.ItemList_QTreeWidget.topLevelItem(1).setCheckState(0, Qt.CheckState(0))

        #surface data       
        elif d_type == 'surfaceGroupItem':
            dv3d_gui_updateCurrentInteractions(tpw, 'surfacegroups')
            dv3d_data_ToggleSurfaceGroups_fromList_single(tpw)
        
        elif d_type == 'surfaceGroupHeader':
            if len(tpw.SurfaceGroups) > 0:
                dv3d_data_ToggleSurfaceGroups_fromList_all(tpw)
            else:
                print 'No surface groups currently loaded - nothing to turn on/off! ...'
                tpw.ItemList_QTreeWidget.topLevelItem(1).setCheckState(0, Qt.CheckState(0))        

        elif d_type == 'SurfaceGroupsHeader':  #the surfaces group master 
            if len(tpw.SurfaceGroups) > 0:
                dv3d_data_ToggleSurfaceGroups_fromList_allGroups(tpw)
            else:
                print 'No surface groups currently loaded - nothing to turn on/off! ...'
                tpw.ItemList_QTreeWidget.topLevelItem(1).setCheckState(0, Qt.CheckState(0))  

        else:
            pass #for now

    dv3d_data_updateAllViews(tpw)


# the selected item has changed .. we need to update the property panels to reflect this
def cb_TreeWidget_ItemSelectedChanged(tpw): 
    if tpw.currentlyLoading == 0:
        d_type = tpw.ItemList_QTreeWidget.currentItem().dv3dDataType    

        if d_type == 'planes':
            dv3d_gui_updateCurrentInteractions(tpw, 'planes')  
        elif d_type == 'surface':
            dv3d_gui_updateCurrentInteractions(tpw, 'surfaces')  
        else:
            dv3d_gui_updateCurrentInteractions(tpw, 'None')  
            #for now
    dv3d_data_updateAllViews(tpw)


##### TEST CALLBACKS #####
# a test function to temporarily bind any new tool to
def testCallbackFunction(tpw):
    print tpw
    print 'hello .. you called?'
