#!/usr/bin/python
#dv3d_gui_BuildList.py
#Configures the QTreeWidget that hold the list of items
#DV3D refactor 2
#AG 25/07/2013


#import libraries
import PyQt4.QtGui as QtGui
import PyQt4.QtCore as QtCore


def dv3d_gui_BuildList(theQTreeWidget):
    #takes the main window's QTreeWidget as input  

    #lets set up some basic data type placeholders
    dataTypes = ['Planes', 'Surfaces', 'SurfaceGroups', 'Markers', 'Volumes']

    #Add a parent to the tree for each dataType
    for thisType in dataTypes:
        thisHeader = QtGui.QTreeWidgetItem([thisType])
        
        setattr(theQTreeWidget, thisType, thisHeader)
        setattr(thisHeader, 'dv3dDataType', '%sHeader' %(thisType))
        #allow the user to turn the entire group off in one go   
        thisHeader.setCheckState(0,QtCore.Qt.Unchecked)
        #temporarily disbale each of the fields - unitl data is added
        thisHeader.setDisabled(1)
        theQTreeWidget.addTopLevelItem(thisHeader)

    #add the top level group
    theQTreeWidget.addTopLevelItem(thisHeader)

