#!/usr/bin/python
#dv3d_dialogs_surface_properties_panel.py
#dv3d_dialogs_surface_properties_panel launcher
#DV3D refactor 2
#AG 26/07/2013

#core libs
import vtk
import os,sys
from PyQt4.QtCore import *
from PyQt4.QtGui import *

#gui setup 
import ui_surfacePropertyDialog

#functions
from dv3d_gui_ColorPicker import *
from dv3d_data_updateAllViews import *


#set up the property panel
class SurfacePropertyPanel(QDialog, ui_surfacePropertyDialog.Ui_SurfaceDataProperties):  

    def __init__(self, text, the_parent_window):
        super(SurfacePropertyPanel, self).__init__(the_parent_window)
        #super(SurfacePropertyPanel, self).__init__(None)
        self.__text = unicode(text)
        self.__index = 0
        self.setupUi(self)

        ##debug print
        #print 'surface frame generated'
        
        #hold for now so we can fix options
        #self.show()

        self.tpw = the_parent_window

        self.spinboxSurfaceOpacity.setKeyboardTracking(0) #stops update at each keypress

        #default color for surfaces is red so set that here
        palette = self.frameSurfaceColor.palette()
        palette.setColor(self.frameSurfaceColor.backgroundRole(), QColor(255,0,0))
        self.frameSurfaceColor.setPalette(palette)
        self.frameSurfaceColor.setAutoFillBackground(1);
        #setattr(self.tpw.Surfaces[-1], 'currRGB', (1,0,0))
        #setattr(self.tpw.Surfaces[-1], 'currQcolor', QColor(255,0,0))


        self.generateCallbacks()



    # --------------------
    def generateCallbacks(self):

        #pushButtons
        self.pushButtonClipperToggleOnOff.released.connect(self.cb_ClipperOn)
        self.pushButtonClipperToggleInsideOutside.released.connect(self.cb_ClipperInsideOut)
        self.pushButtonClipperReset.released.connect(self.cb_ClipperReset)
        self.pushButtonSurfaceToggleMode.released.connect(self.cb_ToggleSurfaceMode)
        self.pushButtonSurfaceColor.released.connect(self.cb_colorChange)

        # opacity spinBox     
        self.spinboxSurfaceOpacity.valueChanged.connect(self.cb_OpacityChanged)


    # --------------------
    def cb_colorChange(self):
        newCol = dv3d_gui_ColorPicker_QColor()
        theSurface = self.getCurrentSurfaceIndex()
        if newCol != 'None':
            palette = self.frameSurfaceColor.palette()
            palette.setColor(self.frameSurfaceColor.backgroundRole(), newCol)
            self.frameSurfaceColor.setPalette(palette)
            self.frameSurfaceColor.setAutoFillBackground(1);
            self.update()
            self.repaint()

            #now apply the color to the actor
            rgb = newCol.getRgb()[:3]
            theSurface.GetProperty().SetColor(rgb[0]/255.0, rgb[1]/255.0, rgb[2]/255.0)
            dv3d_data_updateAllViews(self.tpw)
            
            #keep track of state
            setattr(theSurface, 'currRGB', (rgb[0]/255.0, rgb[1]/255.0, rgb[2]/255.0))
            setattr(theSurface, 'currQcolor', newCol)



    def cb_OpacityChanged(self):
        theSurface = self.getCurrentSurfaceIndex()
        new_opacity = self.spinboxSurfaceOpacity.value()
        theSurface.GetProperty().SetOpacity(new_opacity)
        dv3d_data_updateAllViews(self.tpw)       
        
        #keep track of state
        setattr(theSurface, 'currOpacity', new_opacity)



    def cb_ToggleSurfaceMode(self):
        theSurface = self.getCurrentSurfaceIndex()
        #switch between wireframe and solid modes
        if self.pushButtonSurfaceToggleMode.isChecked(): #i.e. should be wireframe
            thisMode = 'Wireframe'
            theSurface.GetProperty().SetRepresentationToWireframe()
            theSurface.Modified()
            #update button label
            theSurface.currSurfaceMode = thisMode
            self.pushButtonSurfaceToggleMode.setText(thisMode)
        else:
            thisMode = 'Solid'
            theSurface.GetProperty().SetRepresentationToSurface()
            theSurface.Modified()                
            #update button label
            theSurface.currSurfaceMode = thisMode
            self.pushButtonSurfaceToggleMode.setText(thisMode)
            
        dv3d_data_updateAllViews(self.tpw)
        setattr(theSurface, 'currSurfaceMode', thisMode)



    def cb_ClipperOn(self):
        theSurface = self.getCurrentSurfaceIndex()
        if self.pushButtonClipperToggleOnOff.isChecked(): #i.e.clipper should be ON
            self.pushButtonClipperToggleOnOff.setText('On')
            self.pushButtonClipperToggleInsideOutside.setEnabled(1)
            self.pushButtonClipperReset.setEnabled(1)
            theSurface.ClipperBoxWidget.On()
        else:
            self.pushButtonClipperToggleOnOff.setText('Off')
            self.pushButtonClipperToggleInsideOutside.setEnabled(0)
            self.pushButtonClipperReset.setEnabled(0)
            theSurface.ClipperBoxWidget.Off()
        
        dv3d_data_updateAllViews(self.tpw)



    def cb_ClipperInsideOut(self):
        theSurface = self.getCurrentSurfaceIndex()
        if self.pushButtonClipperToggleInsideOutside.isChecked():
            self.pushButtonClipperToggleInsideOutside.setText('Clip inside')
            theSurface.Clipper.InsideOutOff()
            theSurface.Clipper.UpdateWholeExtent()
            theSurface.Modified()
            setattr(theSurface, 'clipperInsideOut', 'ClipInside')
        else:
            self.pushButtonClipperToggleInsideOutside.setText('Clip outside')
            theSurface.Clipper.InsideOutOn()
            theSurface.Clipper.UpdateWholeExtent()
            theSurface.Modified()
            setattr(theSurface, 'clipperInsideOut', 'ClipOutside')
        dv3d_data_updateAllViews(self.tpw)



    def cb_ClipperReset(self):
        theSurface = self.getCurrentSurfaceIndex()
        clipPlanes = theSurface.clipPlanes
        boxWidget = theSurface.clipBoxWidget

        #do reset
        clipPlanes.SetNormals(theSurface.orig_clipPlaneNormals)
        clipPlanes.SetPoints(theSurface.orig_clipPlanePoints)
        clipPlanes.Modified()
        
        #force the boxWidget recalculate its original bounds
        boxWidget.SetInput(theSurface.orig_Surface.GetMapper().GetInput())
        boxWidget.PlaceWidget()    
        boxWidget.Modified()
        
        dv3d_data_updateAllViews(self.tpw)


    def getCurrentSurfaceIndex(self):
        try:
            self.currentSurfaceIndex = self.tpw.ItemList_QTreeWidget.currentItem().surfaceDataIndex
            return self.tpw.Surfaces[self.currentSurfaceIndex]
        except:
            self.currentSurfaceIndex = self.tpw.ItemList_QTreeWidget.currentItem().surfaceGroupItemDataIndex
            return self.tpw.SurfaceGroups[self.currentSurfaceIndex]            
        











 
      
