#!/usr/bin/python
#dv3d_dialogs_plane_properties_panel.py
#dv3d_dialogs_plane_properties_panel launcher
#DV3D refactor 2
#AG 26/07/2013

#core libs
import vtk
import os,sys
from PyQt4.QtCore import *
from PyQt4.QtGui import *

#gui setup 
import ui_planePropertyDialog

#functions
from dv3d_data_ColorLookupTable import *
from dv3d_gui_ColorPicker import *
from dv3d_data_updateAllViews import *


#set up the property panel
class planePropertyPanel(QDialog, ui_planePropertyDialog.Ui_PlaneDataProperties):  

    def __init__(self, text, the_parent_window):
        super(planePropertyPanel, self).__init__(the_parent_window)
        self.__text = unicode(text)
        self.__index = 0
        self.setupUi(self)
        
        #hold for now so we can fix options
        #self.show()

        self.spinboxDataVisibleMin.setKeyboardTracking(0) #stops update at each keypress
        self.spinboxDataVisibleMax.setKeyboardTracking(0) #stops update at each keypress
        self.spinboxDataOpacity.setKeyboardTracking(0) #stops update at each keypress

        self.tpw = the_parent_window

        self.generateCallbacks()
    
        ##debug print
        #print 'here', the_parent_window


    # let's bind some functionality to the buttons
    def generateCallbacks(self):

        #colour change functions
        # value range
        self.spinboxDataVisibleMin.valueChanged.connect(self.cb_VisibleRange_valueChanged)
        self.spinboxDataVisibleMax.valueChanged.connect(self.cb_VisibleRange_valueChanged)
        # opacity        
        self.spinboxDataOpacity.valueChanged.connect(self.cb_VisibleRange_valueChanged)

        #colour Buttons
        self.pushButtonColorMin.released.connect(self.cb_colorMinChange)
        self.pushButtonColorMax.released.connect(self.cb_colorMaxChange)        

        #check boxes
        self.checkBoxClipAbove.stateChanged.connect(self.cb_VisibleRange_valueChanged)
        self.checkBoxClipBelow.stateChanged.connect(self.cb_VisibleRange_valueChanged)


    def cb_colorMinChange(self):
        cMin = dv3d_gui_ColorPicker_QColor()
        if cMin != 'None':
            #first update the button color            
            palette = self.tpw.PlanePropertyPanel.framePlaneColorMin.palette()
            palette.setColor(self.tpw.PlanePropertyPanel.framePlaneColorMin.backgroundRole(), cMin)
            self.tpw.PlanePropertyPanel.framePlaneColorMin.setPalette(palette)
            self.tpw.PlanePropertyPanel.framePlaneColorMin.setAutoFillBackground(1);
            self.tpw.PlanePropertyPanel.update()
            self.tpw.PlanePropertyPanel.repaint()

            #now do the actual color lookup table
            rgbMin = cMin.getRgb()[:3]
            self.cb_ColorTable_Changed(rgbMin, None)
            dv3d_data_updateAllViews(self.tpw)
            
      
    def cb_colorMaxChange(self):
        cMax = dv3d_gui_ColorPicker_QColor()
        if cMax != 'None':
            palette = self.tpw.PlanePropertyPanel.framePlaneColorMin.palette()
            palette.setColor(self.tpw.PlanePropertyPanel.framePlaneColorMin.backgroundRole(), cMax)
            self.tpw.PlanePropertyPanel.framePlaneColorMax.setPalette(palette)
            self.tpw.PlanePropertyPanel.framePlaneColorMax.setAutoFillBackground(1);
            self.tpw.PlanePropertyPanel.update()
            self.tpw.PlanePropertyPanel.repaint()

            #now do the actual color lookup table
            rgbMax = cMax.getRgb()[:3]
            self.cb_ColorTable_Changed(None, rgbMax)
            dv3d_data_updateAllViews(self.tpw)


    def cb_ColorTable_Changed(self, minRGB=None, maxRGB=None):
        ##debug print        
        #print minRGB, maxRGB
        if self.tpw.currentlyLoading == 0:
            #recalculate the lookuptable
            print 'changing colour lookup table .. colours'
            new_clip_max = self.spinboxDataVisibleMax.value()
            new_clip_min = self.spinboxDataVisibleMin.value()

            new_opacity = self.spinboxDataOpacity.value()
            my_plane_index = self.tpw.ItemList_QTreeWidget.selectedItems()[0].planeDataIndex
            the_plane_set = self.tpw.Planes[my_plane_index]

            if minRGB == None:
                minRGB = the_plane_set.currMinRGB
            else:
                the_plane_set.currMinRGB = minRGB

            if maxRGB == None:
                maxRGB = the_plane_set.currMaxRGB
            else:
                the_plane_set.currMaxRGB = maxRGB

            #and apply
            dv3d_data_ColorLookupTable(self.tpw, the_plane_set, new_clip_min, new_clip_max, minRGB, maxRGB, new_opacity)
            dv3d_data_updateAllViews(self.tpw)


    def cb_VisibleRange_valueChanged(self):
        if self.tpw.currentlyLoading == 0:
            #recalculate the lookuptable
            print 'changing colour lookup table .. values'
            #self.update()
            #self.repaint()
            new_clip_max = self.spinboxDataVisibleMax.value()
            new_clip_min = self.spinboxDataVisibleMin.value()

            new_opacity = self.spinboxDataOpacity.value()
            my_plane_index = self.tpw.ItemList_QTreeWidget.selectedItems()[0].planeDataIndex
            the_plane_set = self.tpw.Planes[my_plane_index]

            #only value range changed so use current colors
            minRGB = the_plane_set.currMinRGB
            maxRGB = the_plane_set.currMaxRGB

            #lazy
            if self.checkBoxClipBelow.isChecked() == 1:
                setattr(the_plane_set, 'enforceLowClip', 1)
            else:
                setattr(the_plane_set, 'enforceLowClip', 0)
            
            if self.checkBoxClipAbove.isChecked() == 1:
                setattr(the_plane_set, 'enforceHighClip', 1)
            else:
                setattr(the_plane_set, 'enforceHighClip', 0)

            #and apply
            dv3d_data_ColorLookupTable(self.tpw, the_plane_set, new_clip_min, new_clip_max, minRGB, maxRGB, new_opacity)
            dv3d_data_updateAllViews(self.tpw)
    


 
      
