#!/usr/bin/python
#dv3d_dialogs_image_export_options_panel.py
#offers some options for image export
#DV3D refactor 2
#AG 05/08/2013

#core libs
import vtk
import os,sys
from PyQt4.QtCore import *
from PyQt4.QtGui import *

#gui setup 
import ui_exportImageDialog

#functions
from dv3d_data_updateAllViews import *


#set up the property panel
class imageExportOptionsPanel(QDialog, ui_exportImageDialog.Ui_exportImageDialog):  

    def __init__(self, text, the_parent_window):
        super(imageExportOptionsPanel, self).__init__(the_parent_window)
        self.__text = unicode(text)
        self.__index = 0
        self.setupUi(self)

        ##debug print
        #print 'surface frame generated'

        self.tpw = the_parent_window

        #get the curretn size of the 3d render window
        curr_size = self.tpw.ren3d.GetSize()
        self.labelCurrHorzSize.setText(str(curr_size[0]))
        self.labelCurrVertSize.setText(str(curr_size[1]))
        self.labelNewHorzSize.setText(str(curr_size[0]))
        self.labelNewVertSize.setText(str(curr_size[1]))

        self.generateCallbacks()
        #hold for now so we can fix options
        self.show()


    # --------------------
    def generateCallbacks(self):

        # magnification spinBox     
        self.spinBoxMagnification.valueChanged.connect(self.cb_MagnificationChanged)
        #OK 
        self.pushButtonOK.released.connect(self.cb_OK)    
        #Cancel 
        self.pushButtonCancel.released.connect(self.cb_CANCEL)    

    def cb_MagnificationChanged(self):
        magnification = self.spinBoxMagnification.value()


        curr_size = self.tpw.ren3d.GetSize()
        self.labelNewHorzSize.setText(str(curr_size[0]*magnification))
        self.labelNewVertSize.setText(str(curr_size[1]*magnification))   
        self.update()        
        self.repaint()        

    def cb_OK(self):
        self.tpw.imageExportOptionsSet = 1
        self.tpw.imageExportOptionsMagnification = self.spinBoxMagnification.value()  
        self.close()

    def cb_CANCEL(self):
        self.tpw.imageExportOptionsSet = 2
        self.tpw.imageExportOptionsMagnification = 1
        self.close()


