#!/usr/bin/python
#dv3d_dialogs_GenerateSingleSurface.py
#options panel launcher for generating surfaces
#DV3D refactor 2
#AG 26/07/2013

#core libs
import vtk
import os,sys
from PyQt4.QtCore import *
from PyQt4.QtGui import *

#gui setup 
import ui_singleSurfaceOptionsDialog

#functions
from dv3d_data_ColorLookupTable import *
from dv3d_gui_ColorPicker import *
from dv3d_vtkTools_generateVTKSurface import *


#set up the property panel
class generateSurfaceOptionsDialog(QDialog, ui_singleSurfaceOptionsDialog.Ui_singleSurfaceOptionsDialog):  

    def __init__(self, the_parent_window):
        super(generateSurfaceOptionsDialog, self).__init__(the_parent_window)
        self.__index = 0
        self.setupUi(self)
        self.show()
        
        self.tpw = the_parent_window

        #generate a list of available data
        dataList = []
        
        for thisSet in self.tpw.Planes:
            dataList.append(thisSet.dataLabel)
        
        #populate the comboBox
        self.comboBoxSelectData.clear()
        self.comboBoxSelectData.addItems(dataList)
        # ... and select the first item
        self.comboBoxSelectData.setCurrentIndex(0)

        #update the fields
        self.the_required_index = 0 #to start with
        self.updateInfoAndRestrictions()

        #add some functions to buttons
        self.generateCallbacks()


    # let's bind some functionality to the buttons
    def generateCallbacks(self):      
        self.comboBoxSelectData.currentIndexChanged.connect(self.cb_chosenDatasetChanged)
        self.accepted.connect(self.cb_accepted)       

    def cb_chosenDatasetChanged(self):
        #user has changed selection so we need to change info/restrictions
        
        #get the selected index which will correspond to the required plane dataset
        self.the_required_index = self.comboBoxSelectData.currentIndex()
        self.updateInfoAndRestrictions()

    def updateInfoAndRestrictions(self):        
         #now we have some data 'selected', update the info fields
        self.labelDataMinValue.setText('%0.4f' %(self.tpw.Planes[self.the_required_index].dMin))
        self.labelDataMaxValue.setText('%0.4f' %(self.tpw.Planes[self.the_required_index].dMax))
        #also restrict the exatrction value        
        self.spinboxExtractionThreshold.setMinimum(self.tpw.Planes[self.the_required_index].dMin)
        self.spinboxExtractionThreshold.setMaximum(self.tpw.Planes[self.the_required_index].dMax)
        # .. and offer extraction options
        self.comboBoxSurfacesToGet.clear() #stops repeat addition on loops        
        self.comboBoxSurfacesToGet.addItems(['All surfaces','Largest connected'])

        #redraw those fields
        self.labelDataMinValue.update()
        self.labelDataMinValue.repaint()
        self.labelDataMaxValue.update()
        self.labelDataMaxValue.repaint()
        self.spinboxExtractionThreshold.update()
        self.spinboxExtractionThreshold.repaint()
        self.comboBoxSurfacesToGet.update()
        self.comboBoxSurfacesToGet.repaint()

    def cb_accepted(self):
        #user said go! .. gather up the info and run
        
        dataIndex = self.comboBoxSelectData.currentIndex()
        extractionValue = self.spinboxExtractionThreshold.value()
        surfacesToGetIndex = self.comboBoxSurfacesToGet.currentIndex()
        smoothingIterations = self.spinBoxSmoothingIterations.value()
        samplingFrequency = self.spinBoxSamplingFrequency.value()
        decimationFactor = self.spinboxDecimationFactor.value()

        dv3d_vtkTools_generateVTKSurfaceFromData(self.tpw, dataIndex, extractionValue, surfacesToGetIndex, smoothingIterations, samplingFrequency, decimationFactor)











