#!/usr/bin/python
#dv3d_data_UpdateSurfaces.py
#Update surface views from callbacks
#DV3D refactor 2
#AG 26/07/2013

#import libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *

from dv3d_data_updateAllViews import *

# functions

# a single list item is selected to toggle its related surface
def dv3d_data_ToggleSurfaces_fromList_single(the_parent_window):

    tpw = the_parent_window #for brevity
    
    my_surface_index = tpw.ItemList_QTreeWidget.currentItem().surfaceDataIndex
    the_surface = tpw.Surfaces[my_surface_index]

    #check the state of the item
    if tpw.ItemList_QTreeWidget.currentItem().checkState(0) == 0:
        #turn all related data views off
        turnSurfaceOnOff(the_surface, 0, tpw)
    else:
        #turn all related data views on    
        turnSurfaceOnOff(the_surface, 1, tpw)


    #whenever any surface items is toggled make sure the default is clipper OFF
    forceClipperOff(tpw)    
    dv3d_data_updateAllViews(tpw)



# the planes header has been selected so toggle all planes
def dv3d_data_ToggleSurfaces_fromList_all(the_parent_window):

    tpw = the_parent_window #for brevity
    theItem = tpw.ItemList_QTreeWidget.currentItem()

    #first get the children of the list
    n_childs = theItem.childCount()
    for i in range(n_childs):
        curr_child_item = theItem.child(i)
        my_surface_index = curr_child_item.surfaceDataIndex
        the_surface = tpw.Surfaces[my_surface_index]
        if theItem.checkState(0) == 0:  
            #turn all planes off
            curr_child_item.setCheckState(0, Qt.CheckState(0))
            turnSurfaceOnOff(the_surface, 0, tpw)
            tpw.SurfacePropertyPanel.setEnabled(0)
        else:
            curr_child_item.setCheckState(0, Qt.CheckState(2))
            turnSurfaceOnOff(the_surface, 1, tpw)


    #whenever any surface items is toggled make sure the default is clipper OFF
    forceClipperOff(tpw)
    dv3d_data_updateAllViews(tpw)    


def turnSurfaceOnOff(the_surface, OnOffBool, tpw):
    the_surface.SetVisibility(OnOffBool)

    if OnOffBool == 0:    
        # also need to ensure clippers are off (may as well do all)
        forceClipperOff(tpw)

    #slight quirk here .. just in case the planes header is off it needs to be turned on
    if the_surface.SetVisibility(OnOffBool) == 1:
        tpw.ItemList_QTreeWidget.topLevelItem(1).setCheckState(0, Qt.CheckState(2))

    dv3d_data_updateAllViews(tpw)



def turnOffClipper(tpw, the_surface):
    the_surface.ClipperBoxWidget.Off()
    if tpw.SurfacePropertyPanel.pushButtonClipperToggleOnOff.isChecked():
        tpw.SurfacePropertyPanel.pushButtonClipperToggleOnOff.setChecked(0)
        tpw.SurfacePropertyPanel.pushButtonClipperToggleOnOff.setText('Off')
        tpw.SurfacePropertyPanel.pushButtonClipperToggleInsideOutside.setEnabled(0)
        tpw.SurfacePropertyPanel.pushButtonClipperReset.setEnabled(0)
        tpw.SurfacePropertyPanel.update()
        tpw.SurfacePropertyPanel.repaint()

    dv3d_data_updateAllViews(tpw)


## info updates in panel when items selected in list

def dv3d_data_UpdatePropertySurfaceInfo_fromList_single(tpw):

    tpw.currentlyLoading = 1
    theItem = tpw.ItemList_QTreeWidget.currentItem()
    my_surface_index = theItem.surfaceDataIndex
    the_surface = tpw.Surfaces[my_surface_index]

    palette = tpw.SurfacePropertyPanel.frameSurfaceColor.palette()
    palette.setColor(tpw.SurfacePropertyPanel.frameSurfaceColor.backgroundRole(), QColor(the_surface.currRGB[0]*255.0, the_surface.currRGB[1]*255.0, the_surface.currRGB[2]*255.0))
    tpw.SurfacePropertyPanel.frameSurfaceColor.setPalette(palette)
    tpw.SurfacePropertyPanel.frameSurfaceColor.setAutoFillBackground(1);
    tpw.SurfacePropertyPanel.update()
    tpw.SurfacePropertyPanel.repaint()  
   
    tpw.SurfacePropertyPanel.spinboxSurfaceOpacity.setValue(the_surface.currOpacity)
    tpw.SurfacePropertyPanel.lineEditSurfaceDataSource.setText(the_surface.dataLabel)

    #surface mode
    currMode = the_surface.currSurfaceMode
    if currMode == 'Solid':
        tpw.SurfacePropertyPanel.pushButtonSurfaceToggleMode.setText('Solid')
        tpw.SurfacePropertyPanel.pushButtonSurfaceToggleMode.setChecked(0)
    elif currMode == 'Wireframe':
        tpw.SurfacePropertyPanel.pushButtonSurfaceToggleMode.setText('Wireframe')
        tpw.SurfacePropertyPanel.pushButtonSurfaceToggleMode.setChecked(1)
    else:
        pass #something's gone wrong

    forceClipperOff(tpw)


    #also check if the item is ticked or not i.e. it is editable ort not
    if theItem.checkState(0) == 0:
        tpw.SurfacePropertyPanel.setEnabled(0)
    else:
        tpw.SurfacePropertyPanel.setEnabled(1)

    tpw.SurfacePropertyPanel.update()
    tpw.SurfacePropertyPanel.repaint()

    tpw.currentlyLoading = 0



#whenever any surface items is toggled make sure the default is clipper OFF
def forceClipperOff(tpw):
    #loop through all surfaces
    try:
        for thisSurface in tpw.Surfaces:
            thisSurface.ClipperBoxWidget.Off()
        
        #update the clipper interaction buttons in the surfaces panel
        tpw.SurfacePropertyPanel.pushButtonClipperToggleOnOff.setChecked(0)
        tpw.SurfacePropertyPanel.pushButtonClipperToggleOnOff.setText('Off')
        
        tpw.SurfacePropertyPanel.pushButtonClipperToggleInsideOutside.setEnabled(0)
        tpw.SurfacePropertyPanel.pushButtonClipperReset.setEnabled(0)
        tpw.SurfacePropertyPanel.checkBoxClipperSynchWithMaster.setEnabled(0)

        tpw.SurfacePropertyPanel.update()
        tpw.SurfacePropertyPanel.repaint()
    except:
        print 'Failed while trying to force surface clippers off .. probably OK though.'
    



