#!/usr/bin/python
#dv3d_data_ColorLookupTable.py
#Create an return a lookuptable colour range
#DV3D refactor 2
#AG 25/07/2013

import vtk
import colorsys

from PyQt4.QtCore import *
from PyQt4.QtGui import *


# lookuptables
def dv3d_data_ColorLookupTable(the_parent_window, the_plane_set, minClip, maxClip, minRGB, maxRGB, opacity):

    ##debug print
    #print 'minRGB, maxRGB'
    #print minRGB, maxRGB

    tpw = the_parent_window #for brevity
    tps = the_plane_set #for brevity

    tpw.currentlyLoading = 1

    #first set the colors or the property frame button indicators
    palette = tpw.PlanePropertyPanel.framePlaneColorMax.palette()
    palette.setColor(tpw.PlanePropertyPanel.framePlaneColorMax.backgroundRole(), QColor(maxRGB[0],maxRGB[1],maxRGB[2]))
    tpw.PlanePropertyPanel.framePlaneColorMax.setPalette(palette)
    tpw.PlanePropertyPanel.framePlaneColorMax.setAutoFillBackground(1);

    palette = tpw.PlanePropertyPanel.framePlaneColorMin.palette()
    palette.setColor(tpw.PlanePropertyPanel.framePlaneColorMin.backgroundRole(), QColor(minRGB[0],minRGB[1],minRGB[2]))
    tpw.PlanePropertyPanel.framePlaneColorMin.setPalette(palette)
    tpw.PlanePropertyPanel.framePlaneColorMin.setAutoFillBackground(1);

    #convert colors to hsv
    maxHSV = colorsys.rgb_to_hsv(maxRGB[0]/255.0, maxRGB[1]/255.0, maxRGB[2]/255.0)
    minHSV = colorsys.rgb_to_hsv(minRGB[0]/255.0, minRGB[1]/255.0, minRGB[2]/255.0)

    #establish whether the user wants the lookuptable to be clipped at the extreme(s)
    clipAtLowerBool = tpw.PlanePropertyPanel.checkBoxClipBelow.isChecked()
    clipAtUpperBool = tpw.PlanePropertyPanel.checkBoxClipAbove.isChecked()

    #first build the table
    theLUT = dv3d_data_BuildVTKColorLookupTable(minHSV, maxHSV, minClip, maxClip, clipAtLowerBool, clipAtUpperBool, opacity)
    
    #now apply these values to the data
    dv3d_data_applyLUT_to_planes(tps, theLUT)


    #let's keep track of some values for update / reference later
    setattr(tps, 'currLUT', theLUT)
    setattr(tps, 'currVisibleMax', maxClip)
    setattr(tps, 'currVisibleMin', minClip)
    setattr(tps, 'currOpacity', opacity)
    setattr(tps, 'currMaxRGB', maxRGB)    
    setattr(tps, 'currMinRGB', minRGB)
    setattr(tps, 'currMaxHSV', maxHSV)    
    setattr(tps, 'currMinHSV', minHSV)
    setattr(tps, 'currIsMinClippingOn', clipAtLowerBool)    
    setattr(tps, 'currIsMaxClippingOn', clipAtUpperBool)

    tpw.currentlyLoading = 0


def dv3d_data_BuildVTKColorLookupTable(minHSV, maxHSV, minClip, maxClip, clipAtLowerBool, clipAtUpperBool, opacity):
    #build a new lookuptable with the new range - but existing colours in the HSVA ramp

    n_table_vals = 512 #number of colours in lookup table

    lut = vtk.vtkLookupTable()
    lut.SetNumberOfTableValues(n_table_vals)
    lut.SetHueRange(minHSV[0], maxHSV[0])
    lut.SetSaturationRange(minHSV[1], maxHSV[1])
    lut.SetValueRange(minHSV[2], maxHSV[2])
    lut.SetAlphaRange(opacity, opacity)
    lut.SetTableRange(minClip, maxClip)
    lut.ForceBuild()
    if clipAtLowerBool == 1:
        #get the currentValue there
        currVal = lut.GetTableValue(0)
        # set the alpha to zero but leave the color unchanged so we minimise edge effects
        newVal = list(currVal) #have to change type
        newVal[3] = 0.0 #assign zero to alpha channel
        newVal = tuple(newVal) #cast back to tuple type
        lut.SetTableValue(0, newVal) # and set

    if clipAtUpperBool == 1:
        currVal = lut.GetTableValue(n_table_vals-1)
        # set the alpha to zero but leave the color unchanged so we minimise edge effects
        newVal = list(currVal) #have to change type
        newVal[3] = 0.0 #assign zero to alpha channel
        newVal = tuple(newVal) #cast back to tuple type
        lut.SetTableValue(n_table_vals-1, newVal) # and set

    return lut


def dv3d_data_applyLUT_to_planes(the_plane_set, theLUT):
    tps = the_plane_set #for brevity
    tps.planeWidget_3dX.SetLookupTable(theLUT)
    tps.planeWidget_3dY.SetLookupTable(theLUT)
    tps.planeWidget_3dZ.SetLookupTable(theLUT)
    tps.planeWidget_2dX.SetLookupTable(theLUT)
    tps.planeWidget_2dY.SetLookupTable(theLUT)
    tps.planeWidget_2dZ.SetLookupTable(theLUT)


    
