#!/usr/bin/python
#dv3d_data_AddSurfaceToWindow.py
#Adds a generated surface actor to the main window with the required structure and attributes
#DV3D refactor 2
#AG 31/07/2013

import vtk
from PyQt4.QtCore import *
from PyQt4.QtGui import *


from dv3d_dialogs_surface_properties_panel import *
from dv3d_data_updateAllViews import *
from dv3d_data_PolydataClipper import *
from dv3d_gui_updateCurrentInteractions import *


def dv3d_data_AddSurfaceToWindow(the_parent_window, theVTKSurface, thisItemIndexInGroup=0, groupCount=0):
    #once vtk surface data has been loaded
    tpw = the_parent_window #for brevity

    # set change state
    tpw.currentlyLoading = 1 #flag to stop unwanted auto-behaviour

    ### ------------------------------------------------ 
    # check if this is the first surface - if so generate a surface property dialog
    # create or update the property panel so the user can adjust the data
    if tpw.SurfaceLoaded == 0: #i.e. this is the first surface oaded    
        tpw.SurfaceLoaded = 1
        tpw.SurfacePropertyPanel = SurfacePropertyPanel('Surface', tpw) #create a panel passing the parent window into its scope

        #big breakthrough here - use window flag as Qt.Window rather than Qt.Dialog to allow minimise button
        # TODO - check cross-platform stability of the this call
        tpw.SurfacePropertyPanel.setWindowFlags(Qt.Window|Qt.WindowMinimizeButtonHint)

        tpw.SurfacePropertyPanel.show()
        tpw.SurfacePropertyPanel.raise_()

    else: 
        pass #it's already created .. just update the info


    #lets determine if this is part of a group of surfaces or a single surface
    if groupCount <= 1: #single surface
        addSingleSurface(the_parent_window, theVTKSurface)

    else: # surface group
        addGroupSurface(the_parent_window, theVTKSurface, thisItemIndexInGroup, groupCount)

 

def addSingleSurface(the_parent_window, theVTKSurface):

    tpw = the_parent_window #for brevity

    # also extract the source so we can use label the tree item
    myDataLabel = theVTKSurface.dataLabel

    ### ------------------------------------------------
    #add entry to 
    child_surface = QTreeWidgetItem([myDataLabel])
    child_surface.setCheckState(0,Qt.Checked)
    child_surface.setFlags(child_surface.flags()|Qt.ItemIsEditable) #allow renaming
    
    tpw.Surfaces.append(theVTKSurface)

    #default colors
    setattr(tpw.Surfaces[-1], 'currRGB', (1,0,0))
    setattr(tpw.Surfaces[-1], 'currQcolor', QColor(255,0,0))

    #first load so enable the surfaces item in the list tree
    tpw.ItemList_QTreeWidget.Surfaces.setDisabled(0)
    
    #also append a pointer to the data this item represents so we can 
    # manipluate the data if we click the list item
    setattr(child_surface, 'dv3dDataType', 'surface')
    setattr(child_surface, 'surfaceDataIndex', len(tpw.Surfaces)-1)

    #add it to the main list
    tpw.ItemList_QTreeWidget.Surfaces.addChild(child_surface) 

    #tell the object list that data has been loaded and is visible
    tpw.ItemList_QTreeWidget.Surfaces.setCheckState(0,Qt.Checked)

    #highlight the correct item in the tree (set focus on current item)
    tpw.ItemList_QTreeWidget.setItemExpanded(tpw.ItemList_QTreeWidget.Surfaces, 1) #make sure its visible
    tpw.ItemList_QTreeWidget.clearSelection() #deselect all currently selected
    tpw.ItemList_QTreeWidget.setCurrentItem(child_surface) #set current and then ...
    child_surface.setSelected(1) #and highlight it
    tpw.ItemList_QTreeWidget.update() #update
    tpw.ItemList_QTreeWidget.repaint() #redraw

    #surfaces have an additional complexity - they have an associated Clipper
    # let's set that up here ..
    clipActor, clipPlanes, clipper = AddPolyDataClipper(tpw, theVTKSurface)

    # replace the recently added surface with this new one
    tpw.Surfaces[-1] = clipActor   

    #let's keep track of some values for update / reference later
    # NB some already set in dv3d_data_ColorLookupTable
    setattr(tpw.Surfaces[-1], 'dataLabel', myDataLabel)
    setattr(tpw.Surfaces[-1], 'bounds', tpw.Surfaces[-1].GetBounds())
    setattr(tpw.Surfaces[-1], 'currSurfaceMode', 'Solid')
    setattr(tpw.Surfaces[-1], 'currOpacity', 1.0)
    setattr(tpw.Surfaces[-1], 'currRGB', (1,0,0))
    setattr(tpw.Surfaces[-1], 'currQColor', QColor(255,0,0))
    setattr(tpw.Surfaces[-1], 'orig_Surface', theVTKSurface)
    setattr(tpw.Surfaces[-1], 'clipper', clipper)
    setattr(tpw.Surfaces[-1], 'clipPlanes', clipPlanes)
    setattr(tpw.Surfaces[-1], 'clipBoxWidget', clipActor.ClipperBoxWidget)
    setattr(tpw.Surfaces[-1], 'clipperInsideOut', 'ClipOutside')


    #we may want to reset the mapper in the future, so keep track of 
    #  the original calculated clipPlane parameters
    clipPlanes.Modified() #make sure they're updated first
    setattr(tpw.Surfaces[-1], 'orig_clipPlanePoints', clipPlanes.GetPoints())
    setattr(tpw.Surfaces[-1], 'orig_clipPlaneNormals', clipPlanes.GetNormals())

    setattr(tpw.Surfaces[-1], 'memberOfGroup',None)
    setattr(tpw.Surfaces[-1], 'groupItemNumber',None)


    tpw.currentlyLoading = 0 #flag to stop unwanted auto-behaviout


    #Add the actor to the Window
    tpw.ren3d.AddActor(clipActor)

    #enable the clipping widget so we can calculate the default layout
    # .. allows us to revert back at the click of a button later
    clipActor.ClipperBoxWidget.On()
    clipActor.ClipperBoxWidget.Modified()
    clipActor.ClipperBoxWidget.PlaceWidget()
    clipActor.ClipperBoxWidget.Modified()

    clipActor.VisibilityOn()
    clipActor.ClipperBoxWidget.Off()
    clipActor.SetOrigin(clipActor.GetCenter())

    dv3d_data_updateAllViews(tpw)

    #some additional environment code
    dv3d_gui_updateCurrentInteractions(tpw, 'surfaces')    
    # --








def addGroupSurface(the_parent_window, theVTKSurface, thisItemIndexInGroup, groupCount):

    tpw = the_parent_window #for brevity

    # also extract the source so we can use label the tree item
    myDataLabel = theVTKSurface.dataLabel

    ### ------------------------------------------------

    
    tpw.SurfaceGroups.append(theVTKSurface)

    #first load so enable the surfaces item in the list tree
    tpw.ItemList_QTreeWidget.SurfaceGroups.setDisabled(0)

    #add it to the main list ----------------------

    # some extra work to do here:
    #  we need a sub-group for each grouping of surfaces
    #  so check if this is the first entry of a new group

    thisGroup = 'Group%s' %(str(tpw.uniqueSurfaceGroupCount))

    if thisItemIndexInGroup == 0: #is first entry
        tpw.uniqueSurfaceGroupCount += 1
        thisGroup = 'Group%s' %(str(tpw.uniqueSurfaceGroupCount))
        #create a new sub-group in tree
        child_surfaceGroupHeader = QTreeWidgetItem(thisGroup)
        child_surfaceGroupHeader.setCheckState(0,Qt.Checked)
        child_surfaceGroupHeader.setFlags(child_surfaceGroupHeader.flags()|Qt.ItemIsEditable) #allow renaming        
        setattr(child_surfaceGroupHeader, 'dv3dDataType', 'surfaceGroupHeader')
        tpw.ItemList_QTreeWidget.SurfaceGroups.addChild(child_surfaceGroupHeader)

    #get the sub-list corresponding to this surfaces group
    thisGroupItem = tpw.ItemList_QTreeWidget.SurfaceGroups.child(tpw.uniqueSurfaceGroupCount-1)

    #now add the individual surface
    #add entry for the tree
    child_surface = QTreeWidgetItem([myDataLabel])
    child_surface.setCheckState(0,Qt.Checked)
    child_surface.setFlags(child_surface.flags()|Qt.ItemIsEditable) #allow renaming
    
    #also append a pointer to the data this item represents so we can 
    # manipluate the data if we click the list item
    setattr(child_surface, 'dv3dDataType', 'surfaceGroupItem')
    setattr(child_surface, 'surfaceGroupItemDataIndex', len(tpw.SurfaceGroups)-1)
    
    thisGroupItem.addChild(child_surface)
    thisGroupItem.setCheckState(0,Qt.Checked)

    #tell the object list that data has been loaded and is visible
    tpw.ItemList_QTreeWidget.SurfaceGroups.setCheckState(0,Qt.Checked)

    #highlight the correct item in the tree (set focus on current item)
    tpw.ItemList_QTreeWidget.setItemExpanded(tpw.ItemList_QTreeWidget.Surfaces, 1) #make sure its visible
    tpw.ItemList_QTreeWidget.clearSelection() #deselect all currently selected
    tpw.ItemList_QTreeWidget.setCurrentItem(child_surface) #set current and then ...
    child_surface.setSelected(1) #and highlight it
    tpw.ItemList_QTreeWidget.update() #update
    tpw.ItemList_QTreeWidget.repaint() #redraw

    #surfaces have an additional complexity - they have an associated Clipper
    # let's set that up here ..
    clipActor, clipPlanes, clipper = AddPolyDataClipper(tpw, theVTKSurface)

    # replace the recently added surface with this new one
    tpw.SurfaceGroups[-1] = clipActor   

    #let's keep track of some values for update / reference later
    # NB some already set in dv3d_data_ColorLookupTable
    setattr(tpw.SurfaceGroups[-1], 'dataLabel', myDataLabel)
    setattr(tpw.SurfaceGroups[-1], 'bounds', tpw.SurfaceGroups[-1].GetBounds())
    setattr(tpw.SurfaceGroups[-1], 'currSurfaceMode', 'Solid')

    #current assigned color settings
    currRGB = theVTKSurface.GetProperty().GetColor()
    currOpacity = theVTKSurface.GetProperty().GetOpacity()

    setattr(tpw.SurfaceGroups[-1], 'currRGB', (currRGB[0],currRGB[1],currRGB[2]))
    setattr(tpw.SurfaceGroups[-1], 'currQcolor', QColor(int(255*currRGB[0]),int(255*currRGB[1]),int(255*currRGB[2])))
    setattr(tpw.SurfaceGroups[-1], 'currOpacity', currOpacity)

    setattr(tpw.SurfaceGroups[-1], 'orig_Surface', theVTKSurface)
    setattr(tpw.SurfaceGroups[-1], 'clipper', clipper)
    setattr(tpw.SurfaceGroups[-1], 'clipPlanes', clipPlanes)
    setattr(tpw.SurfaceGroups[-1], 'clipBoxWidget', clipActor.ClipperBoxWidget)
    setattr(tpw.SurfaceGroups[-1], 'clipperInsideOut', 'ClipOutside')


    #we may want to reset the mapper in the future, so keep track of 
    #  the original calculated clipPlane parameters
    clipPlanes.Modified() #make sure they're updated first
    setattr(tpw.SurfaceGroups[-1], 'orig_clipPlanePoints', clipPlanes.GetPoints())
    setattr(tpw.SurfaceGroups[-1], 'orig_clipPlaneNormals', clipPlanes.GetNormals())

    setattr(tpw.SurfaceGroups[-1], 'memberOfGroup', tpw.uniqueSurfaceGroupCount) #NB NOT zero indexed here
    setattr(tpw.SurfaceGroups[-1], 'groupItemNumber',thisItemIndexInGroup) # order in current group

    tpw.currentlyLoading = 0 #flag to stop unwanted auto-behaviout


    #Add the actor to the Window
    tpw.ren3d.AddActor(clipActor)

    #enable the clipping widget so we can calculate the default layout
    # .. allows us to revert back at the click of a button later
    clipActor.ClipperBoxWidget.On()
    clipActor.ClipperBoxWidget.Modified()
    clipActor.ClipperBoxWidget.PlaceWidget()
    clipActor.ClipperBoxWidget.Modified()

    clipActor.VisibilityOn()
    clipActor.ClipperBoxWidget.Off()
    clipActor.SetOrigin(clipActor.GetCenter())

    dv3d_data_updateAllViews(tpw)

    #some additional environment code
    dv3d_gui_updateCurrentInteractions(tpw, 'surfacegroups')    


