#!/usr/bin/python
#dv3d_data_AddLights.py
#Adds lights to the main 3d window
#DV3D refactor 2
#AG 25/07/2013

import vtk


def dv3d_data_AddLights(the_parent_window):

    tpw = the_parent_window #for brevity

    #a dictionary holding the lighting settings
    # indices are 'lightname':[light_position=(x,y,z), focal_point=(x, y, z), color=(r,g,b), intensity]
    # TODO- wishlist .. may want to change light types too
    # TODO- wishlist .. give users access to these features to allow interaction 

    light_settings = [[(0,0,5000),(0,0,0),(1,1,1),0.25],
                           [(0,0,-5000),(0,0,0),(1,1,1),0.5],
                           [(0,5000,0),(0,0,0),(1,1,1),0.5],
                           [(0,-5000,0),(0,0,0),(1,1,1),0.5],
                           [(5000,0,0),(0,0,0),(1,1,1),0.5],
                           [(-5000,0,0),(0,0,0),(1,1,1),0.5],
                           [(5000,5000,5000),(0,0,0),(1,1,1),0.5],
                           [(5000,-5000,5000),(0,0,0),(1,1,1),0.5],
                           [(5000,-5000,-5000),(0,0,0),(1,1,1),0.5],
                           [(5000,5000,-5000),(0,0,0),(1,1,1),0.5],
                           [(-5000,5000,5000),(0,0,0),(1,1,1),0.5],
                           [(-5000,5000,-5000),(0,0,0),(1,1,1),0.5],
                           [(-5000,-5000,-5000),(0,0,0),(1,1,1),0.5],
                           [(-5000,-5000,-5000),(0,0,0),(1,1,1),0.5]]


    for thisLight in light_settings:

        light = vtk.vtkLight()
        light.SetPosition(thisLight[0][0], thisLight[0][1], thisLight[0][2])
        light.SetFocalPoint(thisLight[1][0], thisLight[1][1], thisLight[1][2])
        light.SetColor(thisLight[2][0], thisLight[2][1], thisLight[2][2])
        light.SetIntensity(thisLight[3])

        light.SetLightTypeToCameraLight()
        
        tpw.Lights.append(light)       
        tpw.ren3d.AddLight(light)       
        tpw.ren1.AddLight(light)           
        tpw.ren2.AddLight(light)
        tpw.ren3.AddLight(light)

    
    
    
