#!/usr/bin/python
#dv3d_io_autoScript.py
#Automatic processing of i/o for images / movies
#DV3D refactor 2
#AG 22/01/2013

''' 
Form the main script, type holders are:

    #the main data type holders
    tpw.Planes = []
    tpw.Volumes = []
    tpw.Surfaces = []
    tpw.SurfaceGroups = []
    tpw.Markers = []
    tpw.Lights = []

'''


import dv3d_gui_Callbacks as cb
import time
import vtk

from dv3d_vtkTools_generateVTKSurface import *
from numpy import *


def writeImage(imageCounter, renderWindow):
    #write an image out to file
    windowToImageFilter = vtk.vtkWindowToImageFilter()
    windowToImageFilter.SetInput(renderWindow)
    windowToImageFilter.SetMagnification(1) #set the resolution of the output image (1x times the current resolution of vtk render window)
    windowToImageFilter.SetInputBufferTypeToRGBA() #also record the alpha (transparency) channel
    windowToImageFilter.Update()

    writer = vtk.vtkTIFFWriter()
    writer.SetCompressionToNoCompression()
    writer.SetFileName('/tmp/frame%05d.tiff' %imageCounter)
    writer.SetInputConnection(windowToImageFilter.GetOutputPort())
    writer.Write()


def runAutoScripts(the_parent_window):
    #pass # for now
    print 'executing auto script'

    tpw = the_parent_window #for brevity

    ## change background colour
    ##tpw.ren3d.SetBackground(0,0,0)

    # load base fmri Volume
    cb.cb_LoadDataForPlanes(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/MNI_structural.nii.gz")
    planes1 = tpw.Planes[0]    

    seeds = vtk.vtkPoints()
    #seeds.InsertNextPoint(-10,10,10)
    #seeds.InsertNextPoint(-100.8, 100.8, 0)
    #seeds.InsertNextPoint(-20,20,20)
    #seeds.InsertNextPoint(-40,40,40)
    seeds.InsertNextPoint(-91,131,52)
                
    
    replacein = ["ReplaceInOn"]#, "ReplaceInOff"]
    replaceout = ["ReplaceOutOn"]#, "ReplaceOutOff"]
    thresholds = ["ThresholdBetween(5000, 10000)"]

    thresh = list()
    map = list()
    act = list()
    ren = list()

    k = 0
    for rin in replacein:
        for rout in replaceout:
            for t in thresholds:

                thresh.append(vtk.vtkImageThresholdConnectivity())
                thresh[k].SetSeedPoints(seeds)
                
                thresh[k].SetInValue(10000)
                thresh[k].SetOutValue(0)
                thresh[k].SetSliceRangeY(119,200)
                thresh[k].SetNeighborhoodFraction(0.25)#0.9
                thresh[k].SetNeighborhoodRadius(0.1,0.1,0.1)
                eval('thresh[k].' + rin + '()')
                eval('thresh[k].' + rout + '()')
                print planes1.planeWidget_3dX.GetInput()
                thresh[k].SetInput(planes1.planeWidget_3dX.GetInput())
                eval('thresh[k].' + t)

                thresh[k].Update()
                print thresh[k].GetOutput()

                planes1.planeWidget_3dY.SetInput(thresh[k].GetOutput())
                planes1.planeWidget_3dY.Modified()

            #map.append(vtk.vtkImageMapper())
            #map[k].SetInputConnection(thresh[k].GetOutputPort())
            #if k < 3:
            #    map[k].SetColorWindow(255)
            #    map[k].SetColorLevel(127.5)
            #else:
            #    map[k].SetColorWindow(2000)
            #    map[k].SetColorLevel(1000)

            #act.append(vtk.vtkActor2D())
            #act[k].SetMapper(map[k])
#
            #ren.append(vtk.vtkRenderer())
            #ren[k].AddActor2D(act[k])

            #renWin.AddRenderer(ren[k])

            #            k += 1





    
    




