#!/usr/bin/python
#dv3d_io_autoScript.py
#Automatic processing of i/o for images / movies
#DV3D refactor 2
#AG 22/01/2013

''' 
Form the main script, type holders are:

    #the main data type holders
    tpw.Planes = []
    tpw.Volumes = []
    tpw.Surfaces = []
    tpw.SurfaceGroups = []
    tpw.Markers = []
    tpw.Lights = []

'''


import dv3d_gui_Callbacks as cb
import time


def runAutoScripts(the_parent_window):
    #pass # for now
    print 'executing auto script'

    tpw = the_parent_window #for brevity

    # change background colour
    tpw.ren3d.SetBackground(1,1,1)

    # load base fmri Volume
    cb.cb_LoadDataForPlanes(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/MNI_structural.nii.gz")
    planes1 = tpw.Planes[-1]    

    # load cortex
    cb.cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/Cortex_3mm.vtk")
    cortex = tpw.Surfaces[-1]
    #change appearance
    #cortex.GetProperty().SetRepresentationToWireframe()
    cortex.GetProperty().SetOpacity(0.1)
    cortex.GetProperty().SetColor(0.95,0.95,0.95)    

    # load thalamus
    cb.cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/ThalamusFull.vtk")
    thalamus = tpw.Surfaces[-1]
    #change appearance
    thalamus.GetProperty().SetRepresentationToWireframe()
    thalamus.GetProperty().SetOpacity(0.05)
    thalamus.GetProperty().SetColor(0,0,1)

    # load pulvinar
    cb.cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/Pulvinar.vtk")
    pulvinar = tpw.Surfaces[-1]
    #change appearance
    ##pulvinar.GetProperty().SetRepresentationToWireframe()
    pulvinar.GetProperty().SetOpacity(0.05)
    pulvinar.GetProperty().SetColor(0,0,1)

    # load LGNs
    cb.cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/LGNs.vtk")
    LGNs = tpw.Surfaces[-1]
    #change appearance
    ##LGNs.GetProperty().SetRepresentationToWireframe()
    ##LGNs.GetProperty().SetOpacity(0.05)
    LGNs.GetProperty().SetColor(1,0,0)

    # load i-pulvinar
    cb.cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/iP.vtk")
    iPulvinar = tpw.Surfaces[-1]
    #change appearance
    ##iPulvinar.GetProperty().SetRepresentationToWireframe()
    ##iPulvinar.GetProperty().SetOpacity(0.05)
    iPulvinar.GetProperty().SetColor(1,0.5,0)

    # load DL-pulvinar
    cb.cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/DLP.vtk")
    dlPulvinar = tpw.Surfaces[-1]
    #change appearance
    ##dlPulvinar.GetProperty().SetRepresentationToWireframe()
    ##dlPulvinar.GetProperty().SetOpacity(0.05)
    dlPulvinar.GetProperty().SetColor(0,1,0)


    # load MD-pulvinar
    cb.cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/MDP.vtk")
    mdPulvinar = tpw.Surfaces[-1]
    #change appearance
    ##mdPulvinar.GetProperty().SetRepresentationToWireframe()
    ##mdPulvinar.GetProperty().SetOpacity(0.05)
    mdPulvinar.GetProperty().SetColor(0.53,0.53,1)

    tpw.iwidget_3d.interactor.GetRenderWindow().Render()

    tpw.ren3d.GetActiveCamera().SetFocalPoint(tpw.Surfaces[0].GetCenter())
    tpw.ren3d.GetActiveCamera().SetViewUp(0,0,1)

    for thisPlaneGroup in tpw.Planes:
        thisPlaneGroup.planeWidget_3dX.Off()
        thisPlaneGroup.planeWidget_3dY.Off()
        thisPlaneGroup.planeWidget_3dZ.Off()

    tpw.ren3d.GetActiveCamera().Elevation(300)
    tpw.ren3d.GetActiveCamera().Zoom(1.5)
    tpw.iwidget_3d.interactor.GetRenderWindow().Render()
    time.sleep(1)


    for i in range(100):
        print i
        tpw.ren3d.GetActiveCamera().Azimuth(3.6)
        tpw.iwidget_3d.interactor.GetRenderWindow().Render()
        #time.sleep(0.01)







   

